# .NET 5.0.3 - February 09, 2021

The .NET 5.0.3 and .NET SDK 5.0.103 releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe]  |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](5.0.3-install-instructions.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.103
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.3 release carries both security and non-security fixes.

### [CVE-2021-1721 | .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-1721)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core and ASP.NET 5. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists when creating HTTPS web request during X509 certificate chain building.

### [CVE-2021-24112 | .NET 5 and .NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-24112)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1, and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists when parsing certain types of graphics files. This vulnerability only exists on systems running on MacOS or Linux.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)


Release feature and bug lists:.

* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A5.0.3+is%3Aclosed+label%3Aservicing-approved)
* [ASP.NET Core](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A5.0.3+is%3Aclosed+label%3Aservicing-approved)
* [EntityFramework Core](https://github.com/dotnet/efcore/issues?q=milestone%3A5.0.3+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.3+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5932](https://github.com/dotnet/core/issues/5932) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.3.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.3-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.3-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-february-2021/




[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.3xx+is%3Aclosed

[linux-packages]: 5.0.3-install-instructions.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 5.0.3.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 5.0.3.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 5.0.3.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
System.Diagnostics.EventLog | 5.0.1.nupkg
System.Diagnostics.PerformanceCounter | 5.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.android-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.android-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.android-x86 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.ios-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.ios-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.ios-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.android-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.ios-x86 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Host.win-x86 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.win-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.linux-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Host.win-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 5.0.3.nupkg
System.Drawing.Common | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 5.0.3.nupkg
Microsoft.Windows.Compatibility | 5.0.2.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
Microsoft.NETCore.Platforms | 5.0.1.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.tvos-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.tvos-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 5.0.3.nupkg
Microsoft.NETCore.DotNetAppHost | 5.0.3.nupkg
Microsoft.NETCore.DotNetHost | 5.0.3.nupkg
Microsoft.NETCore.DotNetHostPolicy | 5.0.3.nupkg
Microsoft.NETCore.DotNetHostResolver | 5.0.3.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 5.0.3.nupkg
System.Speech | 5.0.0.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 5.0.3.nupkg
AspNetCoreRuntime.5.0.x64 | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.Google | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 5.0.3.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 5.0.3.nupkg
dotnet-sql-cache | 5.0.3.nupkg
AspNetCoreRuntime.5.0.x86 | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 5.0.3.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 5.0.3.nupkg
Microsoft.dotnet-openapi | 5.0.3.nupkg
Microsoft.CodeAnalysis.Razor | 5.0.3.nupkg
Microsoft.Authentication.WebAssembly.Msal | 5.0.3.nupkg
Microsoft.AspNetCore.TestHost | 5.0.3.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Common | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 5.0.3.nupkg
Microsoft.AspNetCore.SignalR.Client | 5.0.3.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 5.0.3.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic | 5.0.3.nupkg
Microsoft.AspNetCore.Razor.Language | 5.0.3.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 5.0.3.nupkg
Microsoft.DotNet.Web.ItemTemplates | 5.0.3.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0 | 5.0.3.nupkg
Microsoft.JSInterop.WebAssembly | 5.0.3.nupkg
Microsoft.JSInterop | 5.0.3.nupkg
Microsoft.Extensions.WebEncoders | 5.0.3.nupkg
Microsoft.Extensions.ObjectPool | 5.0.3.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 5.0.3.nupkg
Microsoft.Extensions.Localization.Abstractions | 5.0.3.nupkg
Microsoft.Extensions.Localization | 5.0.3.nupkg
Microsoft.Extensions.Identity.Stores | 5.0.3.nupkg
Microsoft.Extensions.Identity.Core | 5.0.3.nupkg
Microsoft.Extensions.FileProviders.Embedded | 5.0.3.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 5.0.3.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 5.0.3.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 5.0.3.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 5.0.3.nupkg
Microsoft.Extensions.ApiDescription.Server | 5.0.3.nupkg
Microsoft.Extensions.ApiDescription.Client | 5.0.3.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0 | 5.0.3.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 5.0.3.nupkg
Microsoft.AspNetCore.Owin | 5.0.3.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 5.0.3.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 5.0.3.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 5.0.3.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 5.0.3.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 5.0.3.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server | 5.0.3.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 5.0.3.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 5.0.3.nupkg
Microsoft.AspNetCore.Components.WebAssembly | 5.0.3.nupkg
Microsoft.AspNetCore.Components.Web | 5.0.3.nupkg
Microsoft.AspNetCore.Components.Forms | 5.0.3.nupkg
Microsoft.AspNetCore.Components.Authorization | 5.0.3.nupkg
Microsoft.AspNetCore.Components.Analyzers | 5.0.3.nupkg
Microsoft.AspNetCore.Components | 5.0.3.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 5.0.3.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 5.0.3.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 5.0.3.nupkg
Microsoft.AspNetCore.Authorization | 5.0.3.nupkg
Microsoft.AspNetCore.DataProtection | 5.0.3.nupkg
Microsoft.AspNetCore.Mvc.Testing | 5.0.3.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 5.0.3.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 5.0.3.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 5.0.3.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 5.0.3.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 5.0.3.nupkg
Microsoft.AspNetCore.Metadata | 5.0.3.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 5.0.3.nupkg
Microsoft.AspNetCore.JsonPatch | 5.0.3.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 5.0.3.nupkg
Microsoft.AspNetCore.Http.Features | 5.0.3.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 5.0.3.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 5.0.3.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 5.0.3.nupkg
Microsoft.AspNetCore.HeaderPropagation | 5.0.3.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 5.0.3.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 5.0.3.nupkg
Microsoft.AspNetCore.Identity.UI | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Tools | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 5.0.3.nupkg
dotnet-ef | 5.0.3.nupkg
Microsoft.Data.Sqlite | 5.0.3.nupkg
Microsoft.Data.Sqlite.Core | 5.0.3.nupkg
Microsoft.EntityFrameworkCore | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Design | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Proxies | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Relational | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 5.0.3.nupkg
Microsoft.EntityFrameworkCore.InMemory | 5.0.3.nupkg
Microsoft.TemplateSearch.Common | 5.0.3.nupkg
Microsoft.TemplateEngine.Utils | 5.0.3.nupkg
Microsoft.DotNet.Common.ItemTemplates | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 5.0.3.nupkg
Microsoft.DotNet.Common.ProjectTemplates.5.0 | 5.0.3.nupkg
Microsoft.TemplateEngine.Abstractions | 5.0.3.nupkg
Microsoft.TemplateEngine.Core | 5.0.3.nupkg
Microsoft.TemplateEngine.Core.Contracts | 5.0.3.nupkg
Microsoft.TemplateEngine.Edge | 5.0.3.nupkg
Microsoft.TemplateEngine.IDE | 5.0.3.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 5.0.3.nupkg


[//]: # ( Runtime 5.0.3)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/94f3d0cd-6ccc-4eac-bac5-7fd1396581d5/b51a89d445f3fb7b2a795f0119fc0575/dotnet-runtime-5.0.3-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbcf8972-286c-42f5-b7be-6bd61dc1b833/37bbc22e83223bf280883f0f6cce28d2/dotnet-runtime-5.0.3-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/433d8892-ef38-4838-b459-d0bbe4a66008/fda4b9e95c721dac8f01d25f1a39288d/dotnet-runtime-5.0.3-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65045602-b193-496e-b403-bc5fcb5b1091/fd1657171b1f765118203bfc956c97df/dotnet-runtime-5.0.3-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49cc8956-3b51-42ff-a718-0fe6326e2fe5/9c3b23c1b92f0b3a8f9d6c2e3e72095e/dotnet-runtime-5.0.3-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/60a8becd-ff61-4e17-8329-4d85f9d1e3b9/06ef79dad25a85905afbb3965f613bad/dotnet-runtime-5.0.3-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ffc7b0f3-0d18-4b07-b242-4113c48a4067/fbce30bc00e359039ce115300609c16f/dotnet-runtime-5.0.3-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/b63525df-7379-4b27-b8eb-e21e3fbdfc41/646d6d51303ef5cb48ff6000cbb8e887/dotnet-runtime-5.0.3-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d9c565e7-9071-47ce-929f-8154b5bef409/85afd2f197748d789cdb62d70ad1de13/dotnet-runtime-5.0.3-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f05c10fe-fed3-43b6-b676-ff75021c2d9f/15cab750af61a29d70ef33c265354cf2/dotnet-runtime-5.0.3-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/23185b06-bc63-402c-b94e-3bdfa999022b/c802fbf2c5a7511c13b764fcb295dba9/dotnet-runtime-5.0.3-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/58ebd1e5-efc7-4b89-b214-3dffb67f3148/1f7942a026bbd4d8a235a597ab83df9f/dotnet-runtime-5.0.3-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/18026047-c90d-49a3-a4b4-04424eaa65a2/3f6336a041ea19cdd2233d606a613b8d/dotnet-runtime-5.0.3-win-x86.zip

[//]: # ( WindowsDesktop 5.0.3)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c6541c87-42f2-4c5d-b6db-2df0dade5e00/13e89a5fec3ddb224cd93dd18b0761ff/windowsdesktop-runtime-5.0.3-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a8dcbda1-8720-453c-9ec6-5a9d90935643/28754321a8b966f1ce837e6f59035b48/windowsdesktop-runtime-5.0.3-win-x86.exe

[//]: # ( ASP 5.0.3)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d8c577b-d6a2-4110-a105-58f578f136db/236c018b3ee005d47fdcb5e9960eaf1f/aspnetcore-runtime-5.0.3-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcdcf093-9cc1-4591-9a1d-7c1f06c7e462/c34d67bdc70d5f92be1bbbb023220b7c/aspnetcore-runtime-5.0.3-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/baae48ad-7e78-432f-ab7a-3769adf877b9/3f54ab3d55cfc58a8b6738d7abfe1775/aspnetcore-runtime-5.0.3-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8af40459-43ae-465b-b40e-e2cf1f7f8832/8c083a48764ae6fa4de1a288b5e1f903/aspnetcore-runtime-5.0.3-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86b1cadb-8736-40c5-aaf8-654da39394fc/df326f9481f4da03c7e31263d42a3b1d/aspnetcore-runtime-5.0.3-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc06d9c6-e1fb-466f-aa4c-59998dbcd6f9/5636f8791058b3ad809179fc421dda6a/aspnetcore-runtime-5.0.3-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/26feb72c-062a-407b-9ed0-ef31cc4d6099/9b4b355e96d1550a424aa70e63676c5d/aspnetcore-runtime-5.0.3-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/414172c8-580b-45f4-b203-7c8cd4aed3c4/aae889e11dc2c76dc47ababde8649731/aspnetcore-runtime-5.0.3-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aafd17b7-5e78-4526-9ed5-a6388b421ed3/96a536e97bd15d1ed4ab7cfc0e4ca71a/aspnetcore-runtime-5.0.3-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0cd54ac9-9526-4892-a127-cab2c13c6a4b/50faf5c2cbd5f9f42c7c19b4f78bf2df/aspnetcore-runtime-5.0.3-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8ac1d8a1-73ac-48e1-b561-a93536a7c22e/d04f05e12d03e42086e6c5da9585a457/aspnetcore-runtime-5.0.3-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dff39ddb-b399-43c5-9af0-04875134ce04/1c449bb9ad4cf75ec616482854751069/dotnet-hosting-5.0.3-win.exe

[//]: # ( SDK 5.0.103 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd11b0d1-8d79-493f-a702-3ecbadb040aa/d24855458a90944d251dd4c68041d0b7/dotnet-sdk-5.0.103-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c2e5668-d7f9-4705-acb0-04ceeda6dadf/4eca3d1ffd92cb2b5f9152155a5529b4/dotnet-sdk-5.0.103-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d02ece12-7202-4a7b-93f7-661268d8b315/d62d32d57d330943b8a889cbd9cd58df/dotnet-sdk-5.0.103-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2052604-de46-4cd4-8256-9bc222537d32/a798771950904eaf91c0c37c58f516e1/dotnet-sdk-5.0.103-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/43e9caf4-2087-4bc6-8031-5efba1268703/a6b0491578d385a9780603ea51df8de9/dotnet-sdk-5.0.103-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3de2d949-fcb5-4586-a217-2c33854d295f/943f0d92252338e11fd11b002a3a3861/dotnet-sdk-5.0.103-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0aa88e72-364e-45d3-ac39-7dd10f0f2f26/461a398a0ab4e1fca8fac573a7b31a4b/dotnet-sdk-5.0.103-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/3fd92d44-eace-490d-aa9d-f7aef699162e/501e8fdd1438b3795afc55ab72397143/dotnet-sdk-5.0.103-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/674a9f7d-862e-4f92-91b6-f1cf3fed03ce/e07db4de77ada8da2c23261dfe9db138/dotnet-sdk-5.0.103-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/178989cb-2bd9-4da8-881f-1acde0d4386c/5cdcc54c9d8f004ab748397a685d5d1b/dotnet-sdk-5.0.103-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/34abccd8-cff2-4c15-ad61-f16c6469ee53/d38befd0e6538d89e6f997418b4b0b8c/dotnet-sdk-5.0.103-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5696bb86-54a9-4d91-b34d-5ff4cf2daac4/c868e23c87303018994c934b2758ab06/dotnet-sdk-5.0.103-win-x86.zip
