# System.Text.Json.Serialization

``` diff
+namespace System.Text.Json.Serialization {
+    public abstract class JsonAttribute : Attribute {
+        protected JsonAttribute();
+    }
+    public sealed class JsonConstructorAttribute : JsonAttribute {
+        public JsonConstructorAttribute();
+    }
+    public abstract class JsonConverter {
+        public abstract bool CanConvert(Type typeToConvert);
+    }
+    public abstract class JsonConverter<T> : JsonConverter {
+        protected internal JsonConverter();
+        public virtual bool HandleNull { get; }
+        public override bool CanConvert(Type typeToConvert);
+        public abstract T Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options);
+        public abstract void Write(Utf8JsonWriter writer, T value, JsonSerializerOptions options);
+    }
+    public class JsonConverterAttribute : JsonAttribute {
+        protected JsonConverterAttribute();
+        public JsonConverterAttribute(Type converterType);
+        public Type ConverterType { get; }
+        public virtual JsonConverter CreateConverter(Type typeToConvert);
+    }
+    public abstract class JsonConverterFactory : JsonConverter {
+        protected JsonConverterFactory();
+        public abstract JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
+    public sealed class JsonExtensionDataAttribute : JsonAttribute {
+        public JsonExtensionDataAttribute();
+    }
+    public sealed class JsonIgnoreAttribute : JsonAttribute {
+        public JsonIgnoreAttribute();
+        public JsonIgnoreCondition Condition { get; set; }
+    }
+    public enum JsonIgnoreCondition {
+        Always = 1,
+        Never = 0,
+        WhenWritingDefault = 2,
+        WhenWritingNull = 3,
+    }
+    public sealed class JsonIncludeAttribute : JsonAttribute {
+        public JsonIncludeAttribute();
+    }
+    public enum JsonNumberHandling {
+        AllowNamedFloatingPointLiterals = 4,
+        AllowReadingFromString = 1,
+        Strict = 0,
+        WriteAsString = 2,
+    }
+    public sealed class JsonNumberHandlingAttribute : JsonAttribute {
+        public JsonNumberHandlingAttribute(JsonNumberHandling handling);
+        public JsonNumberHandling Handling { get; }
+    }
+    public sealed class JsonPropertyNameAttribute : JsonAttribute {
+        public JsonPropertyNameAttribute(string name);
+        public string Name { get; }
+    }
+    public sealed class JsonStringEnumConverter : JsonConverterFactory {
+        public JsonStringEnumConverter();
+        public JsonStringEnumConverter(JsonNamingPolicy namingPolicy = null, bool allowIntegerValues = true);
+        public override bool CanConvert(Type typeToConvert);
+        public override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
+    public abstract class ReferenceHandler {
+        protected ReferenceHandler();
+        public static ReferenceHandler Preserve { get; }
+        public abstract ReferenceResolver CreateResolver();
+    }
+    public sealed class ReferenceHandler<T> : ReferenceHandler where T : ReferenceResolver, new() {
+        public ReferenceHandler();
+        public override ReferenceResolver CreateResolver();
+    }
+    public abstract class ReferenceResolver {
+        protected ReferenceResolver();
+        public abstract void AddReference(string referenceId, object value);
+        public abstract string GetReference(object value, out bool alreadyExists);
+        public abstract object ResolveReference(string referenceId);
+    }
+}
```

