# System.Text.RegularExpressions

``` diff
 namespace System.Text.RegularExpressions {
-    public class GroupCollection : ICollection, ICollection<Group>, IEnumerable, IEnumerable<Group>, IList, IList<Group>, IReadOnlyCollection<Group>, IReadOnlyList<Group> {
+    public class GroupCollection : ICollection, ICollection<Group>, IEnumerable, IEnumerable<Group>, IEnumerable<KeyValuePair<string, Group>>, IList, IList<Group>, IReadOnlyCollection<Group>, IReadOnlyCollection<KeyValuePair<string, Group>>, IReadOnlyDictionary<string, Group>, IReadOnlyList<Group> {
+        public IEnumerable<string> Keys { get; }
+        public IEnumerable<Group> Values { get; }
+        public bool ContainsKey(string key);
+        IEnumerator<KeyValuePair<string, Group>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Text.RegularExpressions.Group>>.GetEnumerator();
+        public bool TryGetValue(string key, out Group value);
     }
     public class Regex : ISerializable {
+        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname);
+        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname, CustomAttributeBuilder[] attributes);
+        public static void CompileToAssembly(RegexCompilationInfo[] regexinfos, AssemblyName assemblyname, CustomAttributeBuilder[] attributes, string resourceFile);
-        protected bool UseOptionR();
+        protected internal bool UseOptionR();
     }
+    public class RegexCompilationInfo {
+        public RegexCompilationInfo(string pattern, RegexOptions options, string name, string fullnamespace, bool ispublic);
+        public RegexCompilationInfo(string pattern, RegexOptions options, string name, string fullnamespace, bool ispublic, TimeSpan matchTimeout);
+        public bool IsPublic { get; set; }
+        public TimeSpan MatchTimeout { get; set; }
+        public string Name { get; set; }
+        public string Namespace { get; set; }
+        public RegexOptions Options { get; set; }
+        public string Pattern { get; set; }
+    }
     public class RegexMatchTimeoutException : TimeoutException, ISerializable {
-        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo si, StreamingContext context);
+        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public enum RegexParseError {
+        AlternationHasComment = 17,
+        AlternationHasMalformedCondition = 2,
+        AlternationHasMalformedReference = 18,
+        AlternationHasNamedCapture = 16,
+        AlternationHasTooManyConditions = 1,
+        AlternationHasUndefinedReference = 19,
+        CaptureGroupNameInvalid = 20,
+        CaptureGroupOfZero = 21,
+        ExclusionGroupNotLast = 23,
+        InsufficientClosingParentheses = 26,
+        InsufficientOpeningParentheses = 30,
+        InsufficientOrInvalidHexDigits = 8,
+        InvalidGroupingConstruct = 15,
+        InvalidUnicodePropertyEscape = 3,
+        MalformedNamedReference = 12,
+        MalformedUnicodePropertyEscape = 4,
+        MissingControlCharacter = 7,
+        NestedQuantifiersNotParenthesized = 28,
+        QuantifierAfterNothing = 29,
+        QuantifierOrCaptureGroupOutOfRange = 9,
+        ReversedCharacterRange = 24,
+        ReversedQuantifierRange = 27,
+        ShorthandClassInCharacterRange = 25,
+        UndefinedNamedReference = 10,
+        UndefinedNumberedReference = 11,
+        UnescapedEndingBackslash = 13,
+        Unknown = 0,
+        UnrecognizedControlCharacter = 6,
+        UnrecognizedEscape = 5,
+        UnrecognizedUnicodeProperty = 31,
+        UnterminatedBracket = 22,
+        UnterminatedComment = 14,
+    }
+    public sealed class RegexParseException : ArgumentException {
+        public RegexParseError Error { get; }
+        public int Offset { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
 }
```

