# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public class Activity : IDisposable {
+        public IEnumerable<KeyValuePair<string, object>> TagObjects { get; }
+        public Activity AddTag(string key, object value);
+        public Activity SetTag(string key, object value);
     }
     public readonly struct ActivityContext : IEquatable<ActivityContext> {
-        public ActivityContext(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags traceOptions, string traceState = null);

+        public ActivityContext(ActivityTraceId traceId, ActivitySpanId spanId, ActivityTraceFlags traceOptions, string traceState = null, bool isRemote = false);
+        public bool IsRemote { get; }
     }
     public readonly struct ActivityCreationOptions<T> {
-        public IEnumerable<KeyValuePair<string, string>> Tags { get; }
+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
     }
     public readonly struct ActivityEvent {
-        public ActivityEvent(string name, IEnumerable<KeyValuePair<string, object>> attributes);

-        public ActivityEvent(string name, DateTimeOffset timestamp);

-        public ActivityEvent(string name, DateTimeOffset timestamp, IEnumerable<KeyValuePair<string, object>> attributes);

+        public ActivityEvent(string name, DateTimeOffset timestamp = default(DateTimeOffset), ActivityTagsCollection tags = null);
-        public IEnumerable<KeyValuePair<string, object>> Attributes { get; }

+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
     }
     public readonly struct ActivityLink : IEquatable<ActivityLink> {
-        public ActivityLink(ActivityContext context);

-        public ActivityLink(ActivityContext context, IEnumerable<KeyValuePair<string, object>> attributes);

+        public ActivityLink(ActivityContext context, ActivityTagsCollection tags = null);
-        public IEnumerable<KeyValuePair<string, object>> Attributes { get; }

+        public IEnumerable<KeyValuePair<string, object>> Tags { get; }
     }
     public sealed class ActivityListener : IDisposable {
+        public bool AutoGenerateRootContextTraceId { get; set; }
     }
     public sealed class ActivitySource : IDisposable {
+        public Activity StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
-        public Activity StartActivity(string name, ActivityKind kind, ActivityContext parentContext, IEnumerable<KeyValuePair<string, string>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));

+        public Activity StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, object>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));
-        public Activity StartActivity(string name, ActivityKind kind, string parentId, IEnumerable<KeyValuePair<string, string>> tags = null, IEnumerable<ActivityLink> links = null, DateTimeOffset startTime = default(DateTimeOffset));

     }
+    public class ActivityTagsCollection : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IEnumerable, IEnumerable<KeyValuePair<string, object>> {
+        public ActivityTagsCollection();
+        public ActivityTagsCollection(IEnumerable<KeyValuePair<string, object>> list);
+        public int Count { get; }
+        public bool IsReadOnly { get; }
+        public ICollection<string> Keys { get; }
+        public object this[string key] { get; set; }
+        public ICollection<object> Values { get; }
+        public void Add(KeyValuePair<string, object> item);
+        public void Add(string key, object value);
+        public void Clear();
+        public bool Contains(KeyValuePair<string, object> item);
+        public bool ContainsKey(string key);
+        public void CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+        public ActivityTagsCollection.Enumerator GetEnumerator();
+        public bool Remove(KeyValuePair<string, object> item);
+        public bool Remove(string key);
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetValue(string key, out object value);
+        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+            public KeyValuePair<string, object> Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public bool MoveNext();
+            void System.Collections.IEnumerator.Reset();
+        }
+    }
 }
```

