# System.Net.Connections

``` diff
+namespace System.Net.Connections {
+    public abstract class Connection : ConnectionBase {
+        protected Connection();
+        public IDuplexPipe Pipe { get; }
+        public Stream Stream { get; }
+        protected virtual IDuplexPipe CreatePipe();
+        protected virtual Stream CreateStream();
+        public static Connection FromPipe(IDuplexPipe pipe, bool leaveOpen = false, IConnectionProperties properties = null, EndPoint localEndPoint = null, EndPoint remoteEndPoint = null);
+        public static Connection FromStream(Stream stream, bool leaveOpen = false, IConnectionProperties properties = null, EndPoint localEndPoint = null, EndPoint remoteEndPoint = null);
+    }
+    public abstract class ConnectionBase : IAsyncDisposable, IDisposable {
+        protected ConnectionBase();
+        public abstract IConnectionProperties ConnectionProperties { get; }
+        public abstract EndPoint LocalEndPoint { get; }
+        public abstract EndPoint RemoteEndPoint { get; }
+        public ValueTask CloseAsync(ConnectionCloseMethod method = ConnectionCloseMethod.GracefulShutdown, CancellationToken cancellationToken = default(CancellationToken));
+        protected abstract ValueTask CloseAsyncCore(ConnectionCloseMethod method, CancellationToken cancellationToken);
+        public void Dispose();
+        public ValueTask DisposeAsync();
+    }
+    public enum ConnectionCloseMethod {
+        Abort = 1,
+        GracefulShutdown = 0,
+        Immediate = 2,
+    }
+    public static class ConnectionExtensions {
+        public static ConnectionFactory Filter(this ConnectionFactory factory, Func<Connection, IConnectionProperties, CancellationToken, ValueTask<Connection>> filter);
+        public static bool TryGet<T>(this IConnectionProperties properties, out T property);
+    }
+    public abstract class ConnectionFactory : IAsyncDisposable, IDisposable {
+        protected ConnectionFactory();
+        public abstract ValueTask<Connection> ConnectAsync(EndPoint endPoint, IConnectionProperties options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public ValueTask DisposeAsync();
+        protected virtual ValueTask DisposeAsyncCore();
+    }
+    public abstract class ConnectionListener : IAsyncDisposable, IDisposable {
+        protected ConnectionListener();
+        public abstract IConnectionProperties ListenerProperties { get; }
+        public abstract EndPoint LocalEndPoint { get; }
+        public abstract ValueTask<Connection> AcceptAsync(IConnectionProperties options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public ValueTask DisposeAsync();
+        protected virtual ValueTask DisposeAsyncCore();
+    }
+    public abstract class ConnectionListenerFactory : IAsyncDisposable, IDisposable {
+        protected ConnectionListenerFactory();
+        public void Dispose();
+        protected virtual void Dispose(bool disposing);
+        public ValueTask DisposeAsync();
+        protected virtual ValueTask DisposeAsyncCore();
+        public abstract ValueTask<ConnectionListener> ListenAsync(EndPoint endPoint, IConnectionProperties options = null, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public interface IConnectionProperties {
+        bool TryGet(Type propertyKey, out object property);
+    }
+    public class SocketsConnectionFactory : ConnectionFactory {
+        public SocketsConnectionFactory(AddressFamily addressFamily, SocketType socketType, ProtocolType protocolType);
+        public SocketsConnectionFactory(SocketType socketType, ProtocolType protocolType);
+        public override ValueTask<Connection> ConnectAsync(EndPoint endPoint, IConnectionProperties options = null, CancellationToken cancellationToken = default(CancellationToken));
+        protected virtual Socket CreateSocket(AddressFamily addressFamily, SocketType socketType, ProtocolType protocolType, EndPoint endPoint, IConnectionProperties options);
+    }
+}
```

