# System.Net.Http

``` diff
 namespace System.Net.Http {
+    public delegate Encoding HeaderEncodingSelector<TContext>(string headerName, TContext context);
     public class HttpClient : HttpMessageInvoker {
+        public HttpVersionPolicy DefaultVersionPolicy { get; set; }
     }
+    public enum HttpKeepAlivePingPolicy {
+        Always = 1,
+        WithActiveRequests = 0,
+    }
     public class HttpRequestMessage : IDisposable {
+        public HttpRequestOptions Options { get; }
+        public HttpVersionPolicy VersionPolicy { get; set; }
     }
+    public sealed class HttpRequestOptions : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IEnumerable, IEnumerable<KeyValuePair<string, object>> {
+        public HttpRequestOptions();
+        int System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Count { get; }
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.IsReadOnly { get; }
+        object System.Collections.Generic.IDictionary<System.String,System.Object>.this[string key] { get; set; }
+        ICollection<string> System.Collections.Generic.IDictionary<System.String,System.Object>.Keys { get; }
+        ICollection<object> System.Collections.Generic.IDictionary<System.String,System.Object>.Values { get; }
+        public void Set<TValue>(HttpRequestOptionsKey<TValue> key, TValue value);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Add(KeyValuePair<string, object> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Clear();
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Contains(KeyValuePair<string, object> item);
+        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Remove(KeyValuePair<string, object> item);
+        void System.Collections.Generic.IDictionary<System.String,System.Object>.Add(string key, object value);
+        bool System.Collections.Generic.IDictionary<System.String,System.Object>.ContainsKey(string key);
+        bool System.Collections.Generic.IDictionary<System.String,System.Object>.Remove(string key);
+        bool System.Collections.Generic.IDictionary<System.String,System.Object>.TryGetValue(string key, out object value);
+        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        public bool TryGetValue<TValue>(HttpRequestOptionsKey<TValue> key, out TValue value);
+    }
+    public readonly struct HttpRequestOptionsKey<TValue> {
+        public HttpRequestOptionsKey(string key);
+        public string Key { get; }
+    }
+    public enum HttpVersionPolicy {
+        RequestVersionExact = 2,
+        RequestVersionOrHigher = 1,
+        RequestVersionOrLower = 0,
+    }
     public class MultipartContent : HttpContent, IEnumerable, IEnumerable<HttpContent> {
+        public HeaderEncodingSelector<HttpContent> HeaderEncodingSelector { get; set; }
     }
     public sealed class SocketsHttpHandler : HttpMessageHandler {
+        public ConnectionFactory ConnectionFactory { get; set; }
+        public bool EnableMultipleHttp2Connections { get; set; }
+        public static bool IsSupported { get; }
+        public TimeSpan KeepAlivePingDelay { get; set; }
+        public HttpKeepAlivePingPolicy KeepAlivePingPolicy { get; set; }
+        public TimeSpan KeepAlivePingTimeout { get; set; }
+        public Func<HttpRequestMessage, Connection, CancellationToken, ValueTask<Connection>> PlaintextFilter { get; set; }
+        public HeaderEncodingSelector<HttpRequestMessage> RequestHeaderEncodingSelector { get; set; }
+        public HeaderEncodingSelector<HttpRequestMessage> ResponseHeaderEncodingSelector { get; set; }
     }
 }
```

