# .NET 6.0.6 - June 14, 2022

The .NET 6.0.6, .NET SDK 6.0.301, and [.NET SDK 6.0.106](6.0.106.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.301
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
.NET 6.0.6 release carries security fixes.

## Microsoft Security Advisory CVE-2022-30184 | .NET Information Disclosure Vulnerability

### <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0 and .NET Core 3.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A vulnerability exists in .NET 6.0 and .NET Core 3.1 within Nuget where a credential leak can occur.

## Additional fixes in this release

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.6+is%3Aclosed+label%3AServicing-approved+)
* [Efcore](https://github.com/dotnet/efcore/issues?q=milestone%3A6.0.6+is%3Aclosed+label%3AServicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.6+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A6.0.6+is%3Aclosed+label%3AServicing-approved+)
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A6.0.6+is%3Aclosed+label%3Aservicing-approved+)

## Visual Studio Compatibility

You need [Visual Studio 17.2](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7536](https://github.com/dotnet/core/issues/7536) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.6/6.0.6.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.6-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.6-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/june-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.6.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.6.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.6.nupkg
Microsoft.WindowsDesktop.App.Ref| 6.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm.Msi.x64| 6.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
Microsoft.NETCore.App.Host.win-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Host.osx-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Host.linux-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.6.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.6.nupkg
Microsoft.NETCore.App.Composite| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86| 6.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
System.Text.Json |6.0.5.nupkg
Microsoft.NETCore.App.Host.win-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Host.win-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Host.win-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.6.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.6.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 6.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Ref| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.6.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm.Msi.arm64| 6.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
Microsoft.NETCore.Platforms |6.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.6.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.6.nupkg
Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.6.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.6.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.6.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.6.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Host.osx-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Host.linux-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.6.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.6.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x86| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.6.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.6.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.6.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.6.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.6.nupkg
Microsoft.AspNetCore.TestHost| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 6.0.6.nupkg
AspNetCoreRuntime.6.0.x64| 6.0.6.nupkg
dotnet-sql-cache| 6.0.6.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 6.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.6.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.6.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.6.nupkg
Microsoft.AspNetCore.Mvc.Testing| 6.0.6.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.6.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.6.nupkg
Microsoft.Extensions.ApiDescription.Client| 6.0.6.nupkg
Microsoft.Extensions.Caching.SqlServer| 6.0.6.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.6.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Common| 6.0.6.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.6.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 6.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.6.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.6.nupkg
Microsoft.AspNetCore.Components.WebView| 6.0.6.nupkg
Microsoft.AspNetCore.Components.Authorization| 6.0.6.nupkg
Microsoft.AspNetCore.Components.Analyzers| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.Google| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.6.nupkg
Microsoft.Extensions.Http.Polly| 6.0.6.nupkg
Microsoft.Extensions.FileProviders.Embedded| 6.0.6.nupkg
Microsoft.JSInterop.WebAssembly| 6.0.6.nupkg
Microsoft.CodeAnalysis.Razor| 6.0.6.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0 |6.0.6.nupkg
Microsoft.Authentication.WebAssembly.Msal| 6.0.6.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.6.nupkg
Microsoft.AspNetCore.SpaProxy| 6.0.6.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.6.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.6.nupkg
Microsoft.JSInterop| 6.0.6.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.6.nupkg
Microsoft.AspNetCore.Owin| 6.0.6.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.6.nupkg
Microsoft.Extensions.ApiDescription.Server| 6.0.6.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.6.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.6.nupkg
Microsoft.AspNetCore.SignalR.Client| 6.0.6.nupkg
Microsoft.AspNetCore.DataProtection| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.6.nupkg
Microsoft.AspNetCore.App.Ref| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.6.nupkg
Microsoft.AspNetCore.Components.WebAssembly| 6.0.6.nupkg
Microsoft.AspNetCore.Components.Web| 6.0.6.nupkg
Microsoft.AspNetCore.Components.Forms| 6.0.6.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.6.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 6.0.6.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.6.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.6.nupkg
Microsoft.AspNetCore.HeaderPropagation| 6.0.6.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.6.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.6.nupkg
Microsoft.AspNetCore.Razor.Language| 6.0.6.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.6.nupkg
AspNetCoreRuntime.6.0.x86| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.6.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.6.nupkg
Microsoft.AspNetCore.Authorization| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.6.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 6.0.6.nupkg
Microsoft.AspNetCore.Components| 6.0.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.6.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.6.nupkg
Microsoft.Extensions.ObjectPool| 6.0.6.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 6.0.6.nupkg
Microsoft.Extensions.Localization.Abstractions| 6.0.6.nupkg
Microsoft.Extensions.Identity.Stores| 6.0.6.nupkg
Microsoft.Extensions.Localization| 6.0.6.nupkg
Microsoft.Extensions.Identity.Core| 6.0.6.nupkg
Microsoft.Extensions.Features| 6.0.6.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.6.nupkg
Microsoft.AspNetCore.Identity.UI| 6.0.6.nupkg
Microsoft.AspNetCore.JsonPatch| 6.0.6.nupkg
Microsoft.AspNetCore.Metadata| 6.0.6.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.6.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 6.0.6.nupkg
Microsoft.dotnet-openapi| 6.0.6.nupkg
Microsoft.Extensions.WebEncoders| 6.0.6.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.106.nupkg
Microsoft.TemplateEngine.Core| 6.0.106.nupkg
Microsoft.TemplateEngine.Utils| 6.0.106.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.106.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.106.nupkg
Microsoft.TemplateEngine.IDE| 6.0.106.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.106.nupkg
Microsoft.TemplateSearch.Common| 6.0.106.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.106.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.106.nupkg
Microsoft.TemplateEngine.Edge| 6.0.106.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.106.nupkg
Microsoft.DotNet.Compatibility | 1.0.0-servicing.22268.20.nupkg
Microsoft.Data.Sqlite| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Tools| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Relational| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.6.nupkg
dotnet-ef| 6.0.6.nupkg
Microsoft.Data.Sqlite.Core| 6.0.6.nupkg
Microsoft.EntityFrameworkCore| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.InMemory| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Proxies| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Design| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.6.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 6.0.6.nupkg
FSharp.Core| 6.0.5.nupkg
FSharp.Compiler.Service| 41.0.5.nupkg

[//]: # ( Runtime 6.0.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ba760ea-befb-4ec8-9fd8-89e7dd1f46be/17ef5757f98629f1c07e1fbca2b65901/dotnet-runtime-6.0.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44ed3398-9838-4fd0-b225-60d5aadfb00e/00fd4a320d09a380753b45106e2a8e94/dotnet-runtime-6.0.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d209f9d7-4ddc-4627-a0f2-960804b48fe2/3bb2fd882406ca66189ac24e81d86c94/dotnet-runtime-6.0.6-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b62ace6f-a30b-4a6f-a66b-f4e924e3ff3e/051baea234407ce6ed5c7332b1e6aad3/dotnet-runtime-6.0.6-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05375a21-79a9-41f6-a8e2-d6504343ca19/ee77adb1ddaff11925111d94b5987b8a/dotnet-runtime-6.0.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec4172e3-077a-42c0-859d-349e517d7935/82d945cdc4c33fbe440a86a240a58a41/dotnet-runtime-6.0.6-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c02ac195-3d6e-40c8-bab6-7a5cff4ea81a/2cf046c0857dc848d537807c8ee51516/dotnet-runtime-6.0.6-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f91e108d-487b-4a47-b6e9-52bcc56df7ed/d722468512150e73489f2cee0b2d7087/dotnet-runtime-6.0.6-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bc450f6d-2309-4352-b940-e4ac89261afe/e6a64009f3829f7042153a772edfa4ea/dotnet-runtime-6.0.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30056482-998a-42ed-b3a7-8fc057977e2e/698c75b7f2429e796dd3c13f980e4188/dotnet-runtime-6.0.6-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/6180b6ce-48d0-4a0c-951a-bc6d2f5bbc3d/e1c2d351d288e5f02df27d3d9d9d874f/dotnet-runtime-6.0.6-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/475859d7-2fff-4ce8-9f7f-ace506a17fbc/cb7f5ec29cb25f6fd799e2e361ddb67c/dotnet-runtime-6.0.6-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7989338b-8ae9-4a5d-8425-020148016812/c26361fde7f706279265a505b4d1d93a/dotnet-runtime-6.0.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9ffa8051-c8c4-40fa-8a0d-1f37069155a9/8538bef240de6b58918ab670327e8912/dotnet-runtime-6.0.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/60c4767e-c0df-491b-970c-cf69d0c2c581/524ccc6ff8aa96120753ab387bf22d5d/dotnet-runtime-6.0.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2a569272-6923-48e4-a325-6752b7bba641/f60c762922218d1cdd892936742f9ea8/dotnet-runtime-6.0.6-win-x86.zip

[//]: # ( WindowsDesktop 6.0.6)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/d09acad2-0abb-4ec8-8388-b8b42b31cd58/517cff2da8fbcdcb514bb4e2f1dc8879/windowsdesktop-runtime-6.0.6-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/e92cf7ac-5e86-4c4c-8d65-3675de8c253e/826784658f9242cfd9bcbbe056858d2b/windowsdesktop-runtime-6.0.6-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9d6b6b34-44b5-4cf4-b924-79a00deb9795/2f17c30bdf42b6a8950a8552438cf8c1/windowsdesktop-runtime-6.0.6-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e26cb94d-627b-4d4c-99f9-171d85b878d1/56638b52671fa13518bd1ebd65820a75/windowsdesktop-runtime-6.0.6-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cc04076c-d188-4c20-9b4f-89be06f1a39c/32da746ef46fbeedb4f609b67cb451c3/windowsdesktop-runtime-6.0.6-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/58a75fdc-0224-44d1-abcb-6476f771a6dd/0f383aed3d95e6c374951d443da125a8/windowsdesktop-runtime-6.0.6-win-x86.zip

[//]: # ( ASP 6.0.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/084bfc2b-f28d-4995-87f0-d82519245825/7f5398fc2caf95355b154856868ef560/aspnetcore-runtime-6.0.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/94553ccb-ce1a-401c-8840-bdffb4e9d0cb/ab8a0024df90506d953904ac38b5a978/aspnetcore-runtime-6.0.6-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/392f39a2-095b-4841-98f1-a35f36adc004/b3c9cc19e5013a54f332727dac62957f/aspnetcore-runtime-6.0.6-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c649af75-1318-45d5-b780-54ab149fad6c/c3e8c553e1f8772b87db5334bf862a4e/aspnetcore-runtime-6.0.6-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58737b13-a9b4-4ebf-a360-6b8909842ba6/0856279338ab22a3efbdf387068ebfac/aspnetcore-runtime-6.0.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/afd5344f-a9e9-45f9-85b5-de4551c53736/c30996daa407f9bb540ebc5edfcf16fc/aspnetcore-runtime-6.0.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/550f6609-521f-42e4-9b53-ff6c88bbe26a/1abbac456fe075a1b6f0f578716e0c4a/aspnetcore-runtime-6.0.6-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f5eb01e-6b46-4ef3-8c1c-7b99657a36df/7d4807a527cd5bc5a6a864f1fcd354e7/aspnetcore-runtime-6.0.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/60c0c6ec-2635-4580-b019-fdd8df756787/1f1d8f52d589836ddd83d0bdd45d4f54/aspnetcore-runtime-6.0.6-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7751b01b-4548-478d-ac63-ca57f2b66a3f/3339efd1fde8f62fed0ac2406f8bc559/aspnetcore-runtime-6.0.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/188ee779-2b6d-4cf0-b11e-e0514cad80b7/9558e992445f513e3b49ab2ef205c2d3/aspnetcore-runtime-6.0.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/b68b5e5c-aeaa-4efd-b194-b37bd73eff64/b2afe8dbd41c8f266f8df26df8fe4ce9/aspnetcore-runtime-6.0.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4417f0c7-0613-44c3-81fa-d7879aca9b57/4ebbba22ae0a946f2e68cb1b447fc1c0/aspnetcore-runtime-6.0.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0d000d1b-89a4-4593-9708-eb5177777c64/cfb3d74447ac78defb1b66fd9b3f38e0/dotnet-hosting-6.0.6-win.exe

[//]: # ( SDK 6.0.301)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a218e3b9-941b-43be-bfb1-615862777457/80954de34ab68729981ed372a8d25b46/dotnet-sdk-6.0.301-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06c4ee8e-bf2c-4e46-ab1c-e14dd72311c1/f7bc6c9677eaccadd1d0e76c55d361ea/dotnet-sdk-6.0.301-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/952c468c-ac70-46b0-9274-4cb9c270950c/f0cd4c8392158547c2fa38674bfd56fd/dotnet-sdk-6.0.301-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bd2399a-e0e9-43a6-9767-ac15dd430b1c/3dd4307a1ce811e31943d80eee638bc1/dotnet-sdk-6.0.301-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/206aebda-126f-484f-af02-051a17c1ec54/2ec559cb69cec83ffa64dba5441a1b2d/dotnet-sdk-6.0.301-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77d472e5-194c-421e-992d-e4ca1d08e6cc/56c61ac303ddf1b12026151f4f000a2b/dotnet-sdk-6.0.301-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/635bd87f-f656-4c6b-b246-44b4ea377e0b/08efab409fd319fa1752d65c809783f8/dotnet-sdk-6.0.301-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3859fff3-f8a9-4e05-87cd-bd6db75833f5/64ec1099d45f85d14099da3c1f92a5c3/dotnet-sdk-6.0.301-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ee524e48-da60-4da3-bbde-a253c0f55f98/5190a50cc72112aa935c4a8d4d979c24/dotnet-sdk-6.0.301-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cf3e1c73-a9a9-4e08-8607-8f9edae5f3f2/40a021a98a6b6e430a1f170037735f6f/dotnet-sdk-6.0.301-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fe1eb1c7-ff26-41be-bd82-744151a4b563/7e71468f2a64cbae7babb0b1cf8d662a/dotnet-sdk-6.0.301-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/656c8345-6661-409e-871d-00ca93cec542/cae3dcdc5c668c0e0abcf12d838348f1/dotnet-sdk-6.0.301-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/15ab772d-ce5c-46e5-a90e-57df11adabfb/4b1b1330b6279a50c398f94cf716c71e/dotnet-sdk-6.0.301-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/333eba0c-3242-48f3-a923-fdac5f219f77/342a4595101e3b4616360a7666459236/dotnet-sdk-6.0.301-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/119c00fc-bde4-486e-8d04-6a573372932e/4d749fabe7b0c77f02b4fd49548acc77/dotnet-sdk-6.0.301-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0a9cabcb-cb52-4f5e-bb79-1298f9ff9e22/c306c5cc940a9bb9a39ffe6619a255e6/dotnet-sdk-6.0.301-win-x86.zip

[//]: # ( SDK 6.0.106)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cba88c45-5ea4-43ed-b495-099d9925b561/af8f6468186950a4f87e932f888434a8/dotnet-sdk-6.0.106-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3a8c5d20-21ac-40cf-b3c5-2efd29a88870/b6f62cff4a13924832a81574e5ef5a80/dotnet-sdk-6.0.106-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4daddb43-d6c0-444a-ba69-888ff5e764ca/0ff812b5526280610cdc5ef8c8dc1869/dotnet-sdk-6.0.106-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d556d6b6-7ff3-4630-b5b3-65c76e566581/a295c5d78b51a7ca128ab422e80ae9ad/dotnet-sdk-6.0.106-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96aa7a11-3509-4a31-abcd-85748caabec1/c03bc461382c2b46d953d4c2bddc3f7d/dotnet-sdk-6.0.106-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e36f738c-f269-47e4-9637-7e8fe96f9e6f/c9d3bd280fdf9bfff2993c1ba0f9f8e3/dotnet-sdk-6.0.106-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e14e93ac-9abb-43b6-baeb-b08da40bcc4c/f114dbbfd514a04344f558ffbab698a0/dotnet-sdk-6.0.106-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/150e763d-fea2-4c15-97fc-862df9defe05/0bdf52cbdd9b9e2999584f9ff1ace651/dotnet-sdk-6.0.106-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7d0f1d41-06f4-4b18-afe0-f4d71c66556a/ce8bddf7aac0286e9974bcf63169d3b3/dotnet-sdk-6.0.106-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9483b11-a82a-499e-b3c5-e7954f93c262/6891b38e6c532f23d896e908c93df29f/dotnet-sdk-6.0.106-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/cdbe8020-25ba-467a-b867-add0dda751cf/02886846ee50af1343d0737d7cc93cc0/dotnet-sdk-6.0.106-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/9822aa7b-9109-47ad-9743-ed5968b1b952/88085bd4db8b7862d9c22499778462db/dotnet-sdk-6.0.106-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/569408e2-e6c7-4c7c-8564-6de9daedd9d7/eef50ddcf5e30843efbab355d4b88e53/dotnet-sdk-6.0.106-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/74564d07-5697-4d79-91b4-d101f0f139a5/2bb92fa45663d6fbcc3230e8474537aa/dotnet-sdk-6.0.106-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/777a3e10-4027-47f7-83cb-73271430cfc7/a555d60b3595e57a0f2b964f1331c5a0/dotnet-sdk-6.0.106-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4ec41b18-9b03-42ef-b5dd-8a2e840f4a59/9a2732a24614a4886a46cb83f5474bfd/dotnet-sdk-6.0.106-win-x86.zip
