# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
+    public sealed class ConfigureHostBuilder : IHostBuilder, ISupportsConfigureWebHost {
+        public IDictionary<object, object> Properties { get; }
+        public IHostBuilder ConfigureAppConfiguration(Action<HostBuilderContext, IConfigurationBuilder> configureDelegate);
+        public IHostBuilder ConfigureContainer<TContainerBuilder>(Action<HostBuilderContext, TContainerBuilder> configureDelegate);
+        public IHostBuilder ConfigureHostConfiguration(Action<IConfigurationBuilder> configureDelegate);
+        public IHostBuilder ConfigureServices(Action<HostBuilderContext, IServiceCollection> configureDelegate);
+        IHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsConfigureWebHost.ConfigureWebHost(Action<IWebHostBuilder> configure, Action<WebHostBuilderOptions> configureOptions);
+        IHost Microsoft.Extensions.Hosting.IHostBuilder.Build();
+        public IHostBuilder UseServiceProviderFactory<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory);
+        public IHostBuilder UseServiceProviderFactory<TContainerBuilder>(Func<HostBuilderContext, IServiceProviderFactory<TContainerBuilder>> factory);
+    }
+    public sealed class ConfigureWebHostBuilder : ISupportsStartup, IWebHostBuilder {
+        public IWebHostBuilder ConfigureAppConfiguration(Action<WebHostBuilderContext, IConfigurationBuilder> configureDelegate);
+        public IWebHostBuilder ConfigureServices(Action<WebHostBuilderContext, IServiceCollection> configureServices);
+        public IWebHostBuilder ConfigureServices(Action<IServiceCollection> configureServices);
+        public string GetSetting(string key);
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.Configure(Action<IApplicationBuilder> configure);
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.Configure(Action<WebHostBuilderContext, IApplicationBuilder> configure);
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.UseStartup(Type startupType);
+        IWebHostBuilder Microsoft.AspNetCore.Hosting.Infrastructure.ISupportsStartup.UseStartup<TStartup>(Func<WebHostBuilderContext, TStartup> startupFactory);
+        IWebHost Microsoft.AspNetCore.Hosting.IWebHostBuilder.Build();
+        public IWebHostBuilder UseSetting(string key, string value);
+    }
     public static class EndpointRouteBuilderExtensions {
+        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, RoutePattern pattern, Delegate handler);
+        public static RouteHandlerBuilder Map(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static RouteHandlerBuilder MapDelete(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, Delegate handler);
+        public static RouteHandlerBuilder MapFallback(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static RouteHandlerBuilder MapGet(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static RouteHandlerBuilder MapMethods(this IEndpointRouteBuilder endpoints, string pattern, IEnumerable<string> httpMethods, Delegate handler);
+        public static RouteHandlerBuilder MapPost(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
+        public static RouteHandlerBuilder MapPut(this IEndpointRouteBuilder endpoints, string pattern, Delegate handler);
     }
+    public static class HttpLoggingBuilderExtensions {
+        public static IApplicationBuilder UseHttpLogging(this IApplicationBuilder app);
+        public static IApplicationBuilder UseW3CLogging(this IApplicationBuilder app);
+    }
     public class IISServerOptions {
+        public int MaxRequestBodyBufferSize { get; set; }
     }
     public static class MapExtensions {
+        public static IApplicationBuilder Map(this IApplicationBuilder app, string pathMatch, Action<IApplicationBuilder> configuration);
     }
+    public sealed class RouteHandlerBuilder : IEndpointConventionBuilder {
+        public RouteHandlerBuilder(IEnumerable<IEndpointConventionBuilder> endpointConventionBuilders);
+        public void Add(Action<EndpointBuilder> convention);
+    }
     public static class RoutingEndpointConventionBuilderExtensions {
+        public static TBuilder WithGroupName<TBuilder>(this TBuilder builder, string endpointGroupName) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithName<TBuilder>(this TBuilder builder, string endpointName) where TBuilder : IEndpointConventionBuilder;
     }
     public static class UseExtensions {
+        public static IApplicationBuilder Use(this IApplicationBuilder app, Func<HttpContext, RequestDelegate, Task> middleware);
     }
+    public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
+        public IConfiguration Configuration { get; }
+        public IWebHostEnvironment Environment { get; }
+        public IHostApplicationLifetime Lifetime { get; }
+        public ILogger Logger { get; }
+        IServiceProvider Microsoft.AspNetCore.Builder.IApplicationBuilder.ApplicationServices { get; set; }
+        IDictionary<string, object> Microsoft.AspNetCore.Builder.IApplicationBuilder.Properties { get; }
+        IFeatureCollection Microsoft.AspNetCore.Builder.IApplicationBuilder.ServerFeatures { get; }
+        ICollection<EndpointDataSource> Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.DataSources { get; }
+        IServiceProvider Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.ServiceProvider { get; }
+        public IServiceProvider Services { get; }
+        public ICollection<string> Urls { get; }
+        public static WebApplication Create(string[] args = null);
+        public static WebApplicationBuilder CreateBuilder();
+        public static WebApplicationBuilder CreateBuilder(WebApplicationOptions options);
+        public static WebApplicationBuilder CreateBuilder(string[] args);
+        public ValueTask DisposeAsync();
+        RequestDelegate Microsoft.AspNetCore.Builder.IApplicationBuilder.Build();
+        IApplicationBuilder Microsoft.AspNetCore.Builder.IApplicationBuilder.New();
+        IApplicationBuilder Microsoft.AspNetCore.Builder.IApplicationBuilder.Use(Func<RequestDelegate, RequestDelegate> middleware);
+        IApplicationBuilder Microsoft.AspNetCore.Routing.IEndpointRouteBuilder.CreateApplicationBuilder();
+        public void Run(string url = null);
+        public Task RunAsync(string url = null);
+        public Task StartAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public Task StopAsync(CancellationToken cancellationToken = default(CancellationToken));
+        void System.IDisposable.Dispose();
+    }
+    public sealed class WebApplicationBuilder {
+        public ConfigurationManager Configuration { get; }
+        public IWebHostEnvironment Environment { get; }
+        public ConfigureHostBuilder Host { get; }
+        public ILoggingBuilder Logging { get; }
+        public IServiceCollection Services { get; }
+        public ConfigureWebHostBuilder WebHost { get; }
+        public WebApplication Build();
+    }
+    public class WebApplicationOptions {
+        public WebApplicationOptions();
+        public string ApplicationName { get; set; }
+        public string[] Args { get; set; }
+        public string ContentRootPath { get; set; }
+        public string EnvironmentName { get; set; }
+        public string WebRootPath { get; set; }
+    }
 }
```

