# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
+    public readonly struct CLong : IEquatable<CLong> {
+        public CLong(int value);
+        public CLong(IntPtr value);
+        public IntPtr Value { get; }
+        public override bool Equals(object o);
+        public bool Equals(CLong other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
     public abstract class ComWrappers {
+        public object GetOrRegisterObjectForComInstance(IntPtr externalComObject, CreateObjectFlags flags, object wrapper, IntPtr inner);
     }
     public enum CreateObjectFlags {
+        Aggregation = 4,
+        Unwrap = 8,
     }
+    public readonly struct CULong : IEquatable<CULong> {
+        public CULong(uint value);
+        public CULong(UIntPtr value);
+        public UIntPtr Value { get; }
+        public override bool Equals(object o);
+        public bool Equals(CULong other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
     public static class Marshal {
+        public static void InitHandle(SafeHandle safeHandle, IntPtr handle);
     }
+    public readonly struct NFloat : IEquatable<NFloat> {
+        public NFloat(double value);
+        public NFloat(float value);
+        public double Value { get; }
+        public override bool Equals(object o);
+        public bool Equals(NFloat other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
     public abstract class SafeBuffer : SafeHandleZeroOrMinusOneIsInvalid {
+        public void ReadSpan<T>(ulong byteOffset, Span<T> buffer) where T : struct;
+        public void WriteSpan<T>(ulong byteOffset, ReadOnlySpan<T> data) where T : struct;
     }
 }
```

