# System.IO

``` diff
 namespace System.IO {
     public static class File {
+        public static FileStream Open(string path, FileStreamOptions options);
+        public static SafeFileHandle OpenHandle(string path, FileMode mode = FileMode.Open, FileAccess access = FileAccess.Read, FileShare share = FileShare.Read, FileOptions options = FileOptions.None, long preallocationSize = (long)0);
     }
     public sealed class FileInfo : FileSystemInfo {
+        public FileStream Open(FileStreamOptions options);
     }
     public sealed class FileStreamOptions {
+        public int BufferSize { get; set; }
     }
+    public static class RandomAccess {
+        public static long GetLength(SafeFileHandle handle);
+        public static long Read(SafeFileHandle handle, IReadOnlyList<Memory<byte>> buffers, long fileOffset);
+        public static int Read(SafeFileHandle handle, Span<byte> buffer, long fileOffset);
+        public static ValueTask<long> ReadAsync(SafeFileHandle handle, IReadOnlyList<Memory<byte>> buffers, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> ReadAsync(SafeFileHandle handle, Memory<byte> buffer, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static long Write(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset);
+        public static int Write(SafeFileHandle handle, ReadOnlySpan<byte> buffer, long fileOffset);
+        public static ValueTask<long> WriteAsync(SafeFileHandle handle, IReadOnlyList<ReadOnlyMemory<byte>> buffers, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> WriteAsync(SafeFileHandle handle, ReadOnlyMemory<byte> buffer, long fileOffset, CancellationToken cancellationToken = default(CancellationToken));
+    }
     public class StreamReader : TextReader {
+        public StreamReader(string path, FileStreamOptions options);
+        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks, FileStreamOptions options);
     }
     public class StreamWriter : TextWriter {
+        public StreamWriter(string path, FileStreamOptions options);
+        public StreamWriter(string path, Encoding encoding, FileStreamOptions options);
     }
 }
```

