# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    public ref struct DefaultInterpolatedStringHandler {
+        public DefaultInterpolatedStringHandler(int literalLength, int formattedCount);
+        public DefaultInterpolatedStringHandler(int literalLength, int formattedCount, IFormatProvider provider);
+        public DefaultInterpolatedStringHandler(int literalLength, int formattedCount, IFormatProvider provider, Span<char> initialBuffer);
+        public void AppendFormatted(object value, int alignment = 0, string format = null);
+        public void AppendFormatted(ReadOnlySpan<char> value);
+        public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);
+        public void AppendFormatted(string value);
+        public void AppendFormatted(string value, int alignment = 0, string format = null);
+        public void AppendFormatted<T>(T value);
+        public void AppendFormatted<T>(T value, int alignment);
+        public void AppendFormatted<T>(T value, int alignment, string format);
+        public void AppendFormatted<T>(T value, string format);
+        public void AppendLiteral(string value);
+        public override string ToString();
+        public string ToStringAndClear();
+    }
-    public ref struct InterpolatedStringBuilder {
 {
-        public void AppendFormatted(object value, int alignment = 0, string format = null);

-        public void AppendFormatted(ReadOnlySpan<char> value);

-        public void AppendFormatted(ReadOnlySpan<char> value, int alignment = 0, string format = null);

-        public void AppendFormatted(string value);

-        public void AppendFormatted(string value, int alignment = 0, string format = null);

-        public void AppendFormatted<T>(T value);

-        public void AppendFormatted<T>(T value, int alignment);

-        public void AppendFormatted<T>(T value, int alignment, string format);

-        public void AppendFormatted<T>(T value, string format);

-        public void AppendLiteral(string value);

-        public static InterpolatedStringBuilder Create(int literalLength, int formattedCount);

-        public static InterpolatedStringBuilder Create(int literalLength, int formattedCount, IFormatProvider provider);

-        public static InterpolatedStringBuilder Create(int literalLength, int formattedCount, IFormatProvider provider, Span<char> scratchBuffer);

-        public static InterpolatedStringBuilder Create(int literalLength, int formattedCount, Span<char> scratchBuffer);

-        public override string ToString();

-        public string ToStringAndClear();

-    }
+    public sealed class InterpolatedStringHandlerArgumentAttribute : Attribute {
+        public InterpolatedStringHandlerArgumentAttribute(string argument);
+        public InterpolatedStringHandlerArgumentAttribute(params string[] arguments);
+        public string[] Arguments { get; }
+    }
+    public sealed class InterpolatedStringHandlerAttribute : Attribute {
+        public InterpolatedStringHandlerAttribute();
+    }
 }
```

