# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public abstract class AsymmetricAlgorithm : IDisposable {
+        public string ExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<char> password, PbeParameters pbeParameters);
+        public string ExportPkcs8PrivateKeyPem();
+        public string ExportSubjectPublicKeyInfoPem();
+        public bool TryExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<char> destination, out int charsWritten);
+        public bool TryExportPkcs8PrivateKeyPem(Span<char> destination, out int charsWritten);
+        public bool TryExportSubjectPublicKeyInfoPem(Span<char> destination, out int charsWritten);
     }
+    public abstract class ECAlgorithm : AsymmetricAlgorithm {
+        protected ECAlgorithm();
+        public virtual byte[] ExportECPrivateKey();
+        public string ExportECPrivateKeyPem();
+        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);
+        public virtual ECParameters ExportParameters(bool includePrivateParameters);
+        public virtual void GenerateKey(ECCurve curve);
+        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);
+        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);
+        public override void ImportFromPem(ReadOnlySpan<char> input);
+        public virtual void ImportParameters(ECParameters parameters);
+        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);
+        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);
+        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);
+        public bool TryExportECPrivateKeyPem(Span<char> destination, out int charsWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);
+        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);
+        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);
+    }
-    public abstract class ECDiffieHellman : AsymmetricAlgorithm {
+    public abstract class ECDiffieHellman : ECAlgorithm {
-        public virtual byte[] ExportECPrivateKey();

-        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);

-        public virtual ECParameters ExportParameters(bool includePrivateParameters);

-        public virtual void GenerateKey(ECCurve curve);

-        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);

-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);

-        public override void ImportFromPem(ReadOnlySpan<char> input);

-        public virtual void ImportParameters(ECParameters parameters);

-        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);

-        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);

-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);

-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);

-        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);

-        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);

     }
-    public abstract class ECDsa : AsymmetricAlgorithm {
+    public abstract class ECDsa : ECAlgorithm {
-        public virtual byte[] ExportECPrivateKey();

-        public virtual ECParameters ExportExplicitParameters(bool includePrivateParameters);

-        public virtual ECParameters ExportParameters(bool includePrivateParameters);

-        public virtual void GenerateKey(ECCurve curve);

-        public virtual void ImportECPrivateKey(ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<byte> passwordBytes);

-        public override void ImportFromEncryptedPem(ReadOnlySpan<char> input, ReadOnlySpan<char> password);

-        public override void ImportFromPem(ReadOnlySpan<char> input);

-        public virtual void ImportParameters(ECParameters parameters);

-        public override void ImportPkcs8PrivateKey(ReadOnlySpan<byte> source, out int bytesRead);

-        public override void ImportSubjectPublicKeyInfo(ReadOnlySpan<byte> source, out int bytesRead);

-        public virtual bool TryExportECPrivateKey(Span<byte> destination, out int bytesWritten);

-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);

-        public override bool TryExportEncryptedPkcs8PrivateKey(ReadOnlySpan<char> password, PbeParameters pbeParameters, Span<byte> destination, out int bytesWritten);

-        public override bool TryExportPkcs8PrivateKey(Span<byte> destination, out int bytesWritten);

-        public override bool TryExportSubjectPublicKeyInfo(Span<byte> destination, out int bytesWritten);

     }
     public class HMACMD5 : HMAC {
+        public const int HashSizeInBits = 128;
+        public const int HashSizeInBytes = 16;
     }
     public class HMACSHA1 : HMAC {
+        public const int HashSizeInBits = 160;
+        public const int HashSizeInBytes = 20;
     }
     public class HMACSHA256 : HMAC {
+        public const int HashSizeInBits = 256;
+        public const int HashSizeInBytes = 32;
     }
     public class HMACSHA384 : HMAC {
+        public const int HashSizeInBits = 384;
+        public const int HashSizeInBytes = 48;
     }
     public class HMACSHA512 : HMAC {
+        public const int HashSizeInBits = 512;
+        public const int HashSizeInBytes = 64;
     }
     public abstract class MD5 : HashAlgorithm {
+        public const int HashSizeInBits = 128;
+        public const int HashSizeInBytes = 16;
     }
     public abstract class RSA : AsymmetricAlgorithm {
+        public string ExportRSAPrivateKeyPem();
+        public string ExportRSAPublicKeyPem();
+        public bool TryExportRSAPrivateKeyPem(Span<char> destination, out int charsWritten);
+        public bool TryExportRSAPublicKeyPem(Span<char> destination, out int charsWritten);
     }
     public abstract class SHA1 : HashAlgorithm {
+        public const int HashSizeInBits = 160;
+        public const int HashSizeInBytes = 20;
     }
     public abstract class SHA256 : HashAlgorithm {
+        public const int HashSizeInBits = 256;
+        public const int HashSizeInBytes = 32;
     }
     public abstract class SHA384 : HashAlgorithm {
+        public const int HashSizeInBits = 384;
+        public const int HashSizeInBytes = 48;
     }
     public abstract class SHA512 : HashAlgorithm {
+        public const int HashSizeInBits = 512;
+        public const int HashSizeInBytes = 64;
     }
 }
```

