# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
     public abstract class AxHost : Control, ICustomTypeDescriptor, ISupportInitialize {
         public class StateConverter : TypeConverter {
-            public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+            public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
         }
     }
     public abstract class BindingManagerBase {
-        protected EventHandler onCurrentChangedHandler;
+        protected EventHandler? onCurrentChangedHandler;
-        protected EventHandler onPositionChangedHandler;
+        protected EventHandler? onPositionChangedHandler;
-        protected internal virtual PropertyDescriptorCollection GetItemProperties(ArrayList dataSources, ArrayList listAccessors);
+        protected internal virtual PropertyDescriptorCollection? GetItemProperties(ArrayList dataSources, ArrayList listAccessors);
-        protected virtual PropertyDescriptorCollection GetItemProperties(Type listType, int offset, ArrayList dataSources, ArrayList listAccessors);
+        protected virtual PropertyDescriptorCollection? GetItemProperties(Type listType, int offset, ArrayList dataSources, ArrayList listAccessors);
-        protected internal abstract string GetListName(ArrayList listAccessors);
+        protected internal abstract string GetListName(ArrayList? listAccessors);
     }
     public static class ButtonRenderer {
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, bool focused, PushButtonState state);
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, TextFormatFlags flags, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, TextFormatFlags flags, bool focused, PushButtonState state);
-        public static void DrawButton(Graphics g, Rectangle bounds, string buttonText, Font font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
+        public static void DrawButton(Graphics g, Rectangle bounds, string? buttonText, Font? font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, PushButtonState state);
     }
     public static class CheckBoxRenderer {
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, bool focused, CheckBoxState state);
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, TextFormatFlags flags, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, TextFormatFlags flags, bool focused, CheckBoxState state);
-        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string checkBoxText, Font font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
+        public static void DrawCheckBox(Graphics g, Point glyphLocation, Rectangle textBounds, string? checkBoxText, Font? font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, CheckBoxState state);
     }
     public static class Clipboard {
-        public static bool ContainsData(string format);
+        public static bool ContainsData(string? format);
-        public static Stream GetAudioStream();
+        public static Stream? GetAudioStream();
-        public static object GetData(string format);
+        public static object? GetData(string format);
-        public static IDataObject GetDataObject();
+        public static IDataObject? GetDataObject();
-        public static Image GetImage();
+        public static Image? GetImage();
     }
     public class ComboBox : ListControl {
         public class ChildAccessibleObject : AccessibleObject {
-            public override string Name { get; }
+            public override string? Name { get; }
         }
     }
     public static class ComboBoxRenderer {
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, Rectangle textBounds, TextFormatFlags flags, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, Rectangle textBounds, TextFormatFlags flags, ComboBoxState state);
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, Rectangle textBounds, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, Rectangle textBounds, ComboBoxState state);
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, TextFormatFlags flags, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, TextFormatFlags flags, ComboBoxState state);
-        public static void DrawTextBox(Graphics g, Rectangle bounds, string comboBoxText, Font font, ComboBoxState state);
+        public static void DrawTextBox(Graphics g, Rectangle bounds, string? comboBoxText, Font? font, ComboBoxState state);
     }
     public class ContainerControl : ScrollableControl, IContainerControl {
+        protected override void OnMove(EventArgs e);
+        protected override void OnResize(EventArgs e);
     }
     public class Control : Component, IArrangedElement, IBindableComponent, IComponent, IDisposable, IDropTarget, IHandle, IKeyboardToolTip, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISupportOleDropSource, ISynchronizeInvoke, IWin32Window {
         public class ControlCollection : ArrangedElementCollection, ICloneable, ICollection, IEnumerable, IList {
-            public virtual Control this[string key] { get; }
+            public virtual Control? this[string? key] { get; }
-            public virtual void Add(Control value);
+            public virtual void Add(Control? value);
-            public bool Contains(Control control);
+            public bool Contains(Control? control);
-            public virtual bool ContainsKey(string key);
+            public virtual bool ContainsKey(string? key);
-            public int IndexOf(Control control);
+            public int IndexOf(Control? control);
-            public virtual int IndexOfKey(string key);
+            public virtual int IndexOfKey(string? key);
-            public virtual void Remove(Control value);
+            public virtual void Remove(Control? value);
-            public virtual void RemoveByKey(string key);
+            public virtual void RemoveByKey(string? key);
-            int System.Collections.IList.Add(object control);
+            int IList.Add(object? control);
-            void System.Collections.IList.Remove(object control);
+            void IList.Remove(object? control);
-            object System.ICloneable.Clone();
+            object ICloneable.Clone();
         }
     }
     public class DataGridView : Control, ISupportInitialize {
         protected class DataGridViewTopRowAccessibleObject : AccessibleObject {
-            public DataGridView Owner { get; set; }
+            public DataGridView? Owner { get; set; }
-            public override AccessibleObject GetChild(int index);
+            public override AccessibleObject? GetChild(int index);
-            public override AccessibleObject Navigate(AccessibleNavigation navigationDirection);
+            public override AccessibleObject? Navigate(AccessibleNavigation navigationDirection);
         }
     }
     public sealed class DockingAttribute : Attribute {
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
     }
     public class DomainUpDown : UpDownBase {
         public class DomainItemAccessibleObject : AccessibleObject {
-            public DomainItemAccessibleObject(string name, AccessibleObject parent);
+            public DomainItemAccessibleObject(string? name, AccessibleObject parent);
-            public override string Name { get; set; }
+            public override string? Name { get; set; }
-            public override string Value { get; }
+            public override string? Value { get; }
         }
         public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject {
-            public override AccessibleObject GetChild(int index);
+            public override AccessibleObject? GetChild(int index);
         }
     }
     public class ErrorProvider : Component, IExtenderProvider, ISupportInitialize {
+        public bool HasErrors { get; }
     }
     public abstract class FeatureSupport : IFeatureSupport {
-        public abstract Version GetVersionPresent(object feature);
+        public abstract Version? GetVersionPresent(object feature);
-        public static Version GetVersionPresent(string featureClassName, string featureConstName);
+        public static Version? GetVersionPresent(string featureClassName, string featureConstName);
     }
     public abstract class FileDialog : CommonDialog {
+        public bool AddToRecent { get; set; }
+        public bool OkRequiresInteraction { get; set; }
+        public bool ShowHiddenFiles { get; set; }
+        public bool ShowPinnedPlaces { get; set; }
     }
     public sealed class FolderBrowserDialog : CommonDialog {
+        public bool AddToRecent { get; set; }
+        public bool OkRequiresInteraction { get; set; }
+        public bool ShowHiddenFiles { get; set; }
+        public bool ShowPinnedPlaces { get; set; }
     }
     public interface IFeatureSupport {
-        Version GetVersionPresent(object feature);
+        Version? GetVersionPresent(object feature);
     }
     public class ImageIndexConverter : Int32Converter {
-        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
+        public override object? ConvertFrom(ITypeDescriptorContext? context, CultureInfo? culture, object value);
-        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
+        public override object? ConvertTo(ITypeDescriptorContext? context, CultureInfo? culture, object? value, Type destinationType);
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
+        public override bool GetStandardValuesExclusive(ITypeDescriptorContext? context);
-        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
+        public override bool GetStandardValuesSupported(ITypeDescriptorContext? context);
     }
     public class LinkConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
     }
-    public delegate void LinkLabelLinkClickedEventHandler(object sender, LinkLabelLinkClickedEventArgs e);
+    public delegate void LinkLabelLinkClickedEventHandler(object? sender, LinkLabelLinkClickedEventArgs e);
     public class ListBox : ListControl {
         public class IntegerCollection : ICollection, IEnumerable, IList {
-            bool System.Collections.ICollection.IsSynchronized { get; }
+            bool ICollection.IsSynchronized { get; }
-            object System.Collections.ICollection.SyncRoot { get; }
+            object ICollection.SyncRoot { get; }
-            bool System.Collections.IList.IsFixedSize { get; }
+            bool IList.IsFixedSize { get; }
-            bool System.Collections.IList.IsReadOnly { get; }
+            bool IList.IsReadOnly { get; }
-            object System.Collections.IList.this[int index] { get; set; }
+            object? IList.this[int index] { get; set; }
-            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            IEnumerator IEnumerable.GetEnumerator();
-            int System.Collections.IList.Add(object item);
+            int IList.Add(object? item);
-            void System.Collections.IList.Clear();
+            void IList.Clear();
-            bool System.Collections.IList.Contains(object item);
+            bool IList.Contains(object? item);
-            int System.Collections.IList.IndexOf(object item);
+            int IList.IndexOf(object? item);
-            void System.Collections.IList.Insert(int index, object value);
+            void IList.Insert(int index, object? value);
-            void System.Collections.IList.Remove(object value);
+            void IList.Remove(object? value);
-            void System.Collections.IList.RemoveAt(int index);
+            void IList.RemoveAt(int index);
         }
     }
     public class ListViewItemStateImageIndexConverter : ImageIndexConverter {
-        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
+        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext? context);
     }
     public class MonthCalendar : Control {
-        protected override void Dispose(bool disposing);

     }
     public class OpacityConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
     }
     public sealed class OpenFileDialog : FileDialog {
+        public bool SelectReadOnly { get; set; }
+        public bool ShowPreview { get; set; }
     }
     public class OSFeature : FeatureSupport {
-        public override Version GetVersionPresent(object feature);
+        public override Version? GetVersionPresent(object feature);
     }
     public class Panel : ScrollableControl {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
     public class PropertyGrid : ContainerControl, IComPropertyBrowser, Interop.Ole32.IPropertyNotifySink {
-        void System.Windows.Forms.ComponentModel.Com2Interop.IComPropertyBrowser.LoadState(RegistryKey optRoot);
+        void System.Windows.Forms.ComponentModel.Com2Interop.IComPropertyBrowser.LoadState(RegistryKey key);
-        void System.Windows.Forms.ComponentModel.Com2Interop.IComPropertyBrowser.SaveState(RegistryKey optRoot);
+        void System.Windows.Forms.ComponentModel.Com2Interop.IComPropertyBrowser.SaveState(RegistryKey key);
     }
     public static class RadioButtonRenderer {
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, bool focused, RadioButtonState state);
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, TextFormatFlags flags, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, TextFormatFlags flags, bool focused, RadioButtonState state);
-        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string radioButtonText, Font font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
+        public static void DrawRadioButton(Graphics g, Point glyphLocation, Rectangle textBounds, string? radioButtonText, Font? font, TextFormatFlags flags, Image image, Rectangle imageBounds, bool focused, RadioButtonState state);
     }
     public sealed class SaveFileDialog : FileDialog {
+        public bool CheckWriteAccess { get; set; }
+        public bool ExpandedMode { get; set; }
     }
     public class SelectionRangeConverter : TypeConverter {
-        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
+        public override bool CanConvertFrom(ITypeDescriptorContext? context, Type sourceType);
-        public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
+        public override object CreateInstance(ITypeDescriptorContext? context, IDictionary propertyValues);
-        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
+        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext? context, object value, Attribute[]? attributes);
     }
     public class TabPage : Panel {
         public class TabPageControlCollection : Control.ControlCollection {
-            public override void Add(Control value);
+            public override void Add(Control? value);
         }
     }
     public static class TabRenderer {
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, TextFormatFlags flags, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, TextFormatFlags flags, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, TextFormatFlags flags, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, TextFormatFlags flags, Image image, Rectangle imageRectangle, bool focused, TabItemState state);
-        public static void DrawTabItem(Graphics g, Rectangle bounds, string tabItemText, Font font, TabItemState state);
+        public static void DrawTabItem(Graphics g, Rectangle bounds, string? tabItemText, Font? font, TabItemState state);
     }
     public class Timer : Component {
-        public object Tag { get; set; }
+        public object? Tag { get; set; }
     }
     public class ToolStripArrowRenderEventArgs : EventArgs {
-        public ToolStripArrowRenderEventArgs(Graphics g, ToolStripItem toolStripItem, Rectangle arrowRectangle, Color arrowColor, ArrowDirection arrowDirection);
+        public ToolStripArrowRenderEventArgs(Graphics g, ToolStripItem? toolStripItem, Rectangle arrowRectangle, Color arrowColor, ArrowDirection arrowDirection);
-        public ToolStripItem Item { get; }
+        public ToolStripItem? Item { get; }
     }
     public class ToolStripItemImageRenderEventArgs : ToolStripItemRenderEventArgs {
-        public ToolStripItemImageRenderEventArgs(Graphics g, ToolStripItem item, Image image, Rectangle imageRectangle);
+        public ToolStripItemImageRenderEventArgs(Graphics g, ToolStripItem item, Image? image, Rectangle imageRectangle);
     }
     public class ToolStripItemRenderEventArgs : EventArgs {
-        public ToolStrip ToolStrip { get; }
+        public ToolStrip? ToolStrip { get; }
     }
     public class ToolStripItemTextRenderEventArgs : ToolStripItemRenderEventArgs {
-        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string text, Rectangle textRectangle, Color textColor, Font textFont, ContentAlignment textAlign);
+        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string? text, Rectangle textRectangle, Color textColor, Font? textFont, ContentAlignment textAlign);
-        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string text, Rectangle textRectangle, Color textColor, Font textFont, TextFormatFlags format);
+        public ToolStripItemTextRenderEventArgs(Graphics g, ToolStripItem item, string? text, Rectangle textRectangle, Color textColor, Font? textFont, TextFormatFlags format);
     }
 }
```

