# System.Diagnostics.Metrics

``` diff
 namespace System.Diagnostics.Metrics {
     public class Meter : IDisposable {
+        public ObservableUpDownCounter<T> CreateObservableUpDownCounter<T>(string name, Func<IEnumerable<Measurement<T>>> observeValues, string unit = null, string description = null) where T : struct;
+        public ObservableUpDownCounter<T> CreateObservableUpDownCounter<T>(string name, Func<Measurement<T>> observeValue, string unit = null, string description = null) where T : struct;
+        public ObservableUpDownCounter<T> CreateObservableUpDownCounter<T>(string name, Func<T> observeValue, string unit = null, string description = null) where T : struct;
+        public UpDownCounter<T> CreateUpDownCounter<T>(string name, string unit = null, string description = null) where T : struct;
     }
+    public sealed class ObservableUpDownCounter<T> : ObservableInstrument<T> where T : struct {
+        protected override IEnumerable<Measurement<T>> Observe();
+    }
+    public sealed class UpDownCounter<T> : Instrument<T> where T : struct {
+        public void Add(T delta);
+        public void Add(T delta, KeyValuePair<string, object?> tag);
+        public void Add(T delta, KeyValuePair<string, object?> tag1, KeyValuePair<string, object?> tag2);
+        public void Add(T delta, KeyValuePair<string, object?> tag1, KeyValuePair<string, object?> tag2, KeyValuePair<string, object?> tag3);
+        public void Add(T delta, params KeyValuePair<string, object>[] tags);
+        public void Add(T delta, in TagList tagList);
+        public void Add(T delta, ReadOnlySpan<KeyValuePair<string, object?>> tags);
+    }
 }
```

