# Microsoft.AspNetCore.Http.HttpResults

``` diff
+namespace Microsoft.AspNetCore.Http.HttpResults {
+    public sealed class Accepted : IEndpointMetadataProvider, IResult {
+        public string? Location { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class Accepted<TValue> : IEndpointMetadataProvider, IResult {
+        public string Location { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class AcceptedAtRoute : IEndpointMetadataProvider, IResult {
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class AcceptedAtRoute<TValue> : IEndpointMetadataProvider, IResult {
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class BadRequest : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class BadRequest<TValue> : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class ChallengeHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class Conflict : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class Conflict<TValue> : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class ContentHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public string ResponseContent { get; internal set; }
+        public int? StatusCode { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class Created : IEndpointMetadataProvider, IResult {
+        public string? Location { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class Created<TValue> : IEndpointMetadataProvider, IResult {
+        public string Location { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class CreatedAtRoute : IEndpointMetadataProvider, IResult {
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class CreatedAtRoute<TValue> : IEndpointMetadataProvider, IResult {
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class EmptyHttpResult : IResult {
+        public static EmptyHttpResult Instance { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class FileContentHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public ReadOnlyMemory<byte> FileContents { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class FileStreamHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public Stream FileStream { get; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ForbidHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class JsonHttpResult<TValue> : IResult {
+        public string ContentType { get; internal set; }
+        public JsonSerializerOptions JsonSerializerOptions { get; internal set; }
+        public int? StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public class NoContent : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class NotFound : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class NotFound<TValue> : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public TValue Value { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class Ok : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class Ok<TValue> : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class PhysicalFileHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public string FileName { get; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class ProblemHttpResult : IResult {
+        public string ContentType { get; }
+        public ProblemDetails ProblemDetails { get; }
+        public int? StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class PushStreamHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue EntityTag { get; internal set; }
+        public string FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class RedirectHttpResult : IResult {
+        public bool AcceptLocalUrlOnly { get; }
+        public bool Permanent { get; }
+        public bool PreserveMethod { get; }
+        public string Url { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class RedirectToRouteHttpResult : IResult {
+        public string Fragment { get; }
+        public bool Permanent { get; }
+        public bool PreserveMethod { get; }
+        public string RouteName { get; }
+        public RouteValueDictionary RouteValues { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class Results<TResult1, TResult2> : IEndpointMetadataProvider, IResult where TResult1 : IResult where TResult2 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+        public static implicit operator Results<TResult1, TResult2> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2> (TResult2 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3> : IEndpointMetadataProvider, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+        public static implicit operator Results<TResult1, TResult2, TResult3> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3> (TResult3 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3, TResult4> : IEndpointMetadataProvider, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult where TResult4 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult3 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4> (TResult4 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3, TResult4, TResult5> : IEndpointMetadataProvider, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult where TResult4 : IResult where TResult5 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult3 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult4 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5> (TResult5 result);
+    }
+    public sealed class Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> : IEndpointMetadataProvider, IResult where TResult1 : IResult where TResult2 : IResult where TResult3 : IResult where TResult4 : IResult where TResult5 : IResult where TResult6 : IResult {
+        public IResult Result { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult1 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult2 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult3 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult4 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult5 result);
+        public static implicit operator Results<TResult1, TResult2, TResult3, TResult4, TResult5, TResult6> (TResult6 result);
+    }
+    public sealed class SignInHttpResult : IResult {
+        public string AuthenticationScheme { get; internal set; }
+        public ClaimsPrincipal Principal { get; internal set; }
+        public AuthenticationProperties Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class SignOutHttpResult : IResult {
+        public IReadOnlyList<string> AuthenticationSchemes { get; internal set; }
+        public AuthenticationProperties? Properties { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class StatusCodeHttpResult : IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class UnauthorizedHttpResult : IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+    public sealed class UnprocessableEntity : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class UnprocessableEntity<TValue> : IEndpointMetadataProvider, IResult {
+        public int StatusCode { get; }
+        public TValue Value { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class ValidationProblem : IEndpointMetadataProvider, IResult {
+        public string ContentType { get; }
+        public HttpValidationProblemDetails ProblemDetails { get; }
+        public int StatusCode { get; }
+        public Task ExecuteAsync(HttpContext httpContext);
+        static void IEndpointMetadataProvider.PopulateMetadata(EndpointMetadataContext context);
+    }
+    public sealed class VirtualFileHttpResult : IResult {
+        public string ContentType { get; internal set; }
+        public bool EnableRangeProcessing { get; internal set; }
+        public EntityTagHeaderValue? EntityTag { get; internal set; }
+        public string? FileDownloadName { get; internal set; }
+        public long? FileLength { get; internal set; }
+        public string FileName { get; internal set; }
+        public DateTimeOffset? LastModified { get; internal set; }
+        public Task ExecuteAsync(HttpContext httpContext);
+    }
+}
```

