# System

``` diff
 namespace System {
     public readonly struct Byte : IAdditionOperators<byte, byte, byte>, IAdditiveIdentity<byte, byte>, IBinaryInteger<byte>, IBinaryNumber<byte>, IBitwiseOperators<byte, byte, byte>, IComparable, IComparable<byte>, IComparisonOperators<byte, byte>, IConvertible, IDecrementOperators<byte>, IDivisionOperators<byte, byte, byte>, IEqualityOperators<byte, byte>, IEquatable<byte>, IFormattable, IIncrementOperators<byte>, IMinMaxValue<byte>, IModulusOperators<byte, byte, byte>, IMultiplicativeIdentity<byte, byte>, IMultiplyOperators<byte, byte, byte>, INumber<byte>, INumberBase<byte>, IParsable<byte>, IShiftOperators<byte, byte>, ISpanFormattable, ISpanParsable<byte>, ISubtractionOperators<byte, byte, byte>, IUnaryNegationOperators<byte, byte>, IUnaryPlusOperators<byte, byte>, IUnsignedNumber<byte> {
+        static int System.Numerics.INumberBase<System.Byte>.Radix { get; }
-        public static byte CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static byte CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static byte CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(byte value);
+        public static bool IsOddInteger(byte value);
-        long IBinaryInteger<byte>.GetShortestBitLength();
+        int IBinaryInteger<byte>.GetShortestBitLength();
+        bool IBinaryInteger<byte>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
-        static byte INumber<byte>.Abs(byte value);
-        static bool INumber<byte>.IsNegative(byte value);
-        static byte INumber<byte>.MaxMagnitude(byte x, byte y);
+        static byte INumber<byte>.MaxNumber(byte x, byte y);
-        static byte INumber<byte>.MinMagnitude(byte x, byte y);
+        static byte INumber<byte>.MinNumber(byte x, byte y);
+        static byte INumberBase<byte>.Abs(byte value);
+        static bool INumberBase<byte>.IsCanonical(byte value);
+        static bool INumberBase<byte>.IsComplexNumber(byte value);
+        static bool INumberBase<byte>.IsFinite(byte value);
+        static bool INumberBase<byte>.IsImaginaryNumber(byte value);
+        static bool INumberBase<byte>.IsInfinity(byte value);
+        static bool INumberBase<byte>.IsInteger(byte value);
+        static bool INumberBase<byte>.IsNaN(byte value);
+        static bool INumberBase<byte>.IsNegative(byte value);
+        static bool INumberBase<byte>.IsNegativeInfinity(byte value);
+        static bool INumberBase<byte>.IsNormal(byte value);
+        static bool INumberBase<byte>.IsPositive(byte value);
+        static bool INumberBase<byte>.IsPositiveInfinity(byte value);
+        static bool INumberBase<byte>.IsRealNumber(byte value);
+        static bool INumberBase<byte>.IsSubnormal(byte value);
+        static bool INumberBase<byte>.IsZero(byte value);
+        static byte INumberBase<byte>.MaxMagnitude(byte x, byte y);
+        static byte INumberBase<byte>.MaxMagnitudeNumber(byte x, byte y);
+        static byte INumberBase<byte>.MinMagnitude(byte x, byte y);
+        static byte INumberBase<byte>.MinMagnitudeNumber(byte x, byte y);
+        static bool INumberBase<byte>.TryConvertFromChecked<TOther>(TOther value, out byte result);
+        static bool INumberBase<byte>.TryConvertFromSaturating<TOther>(TOther value, out byte result);
+        static bool INumberBase<byte>.TryConvertFromTruncating<TOther>(TOther value, out byte result);
+        static bool INumberBase<byte>.TryConvertToChecked<TOther>(byte value, out TOther result);
+        static bool INumberBase<byte>.TryConvertToSaturating<TOther>(byte value, out TOther result);
+        static bool INumberBase<byte>.TryConvertToTruncating<TOther>(byte value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out byte result) where TOther : INumber<TOther>;
     }
     public readonly struct Char : IAdditionOperators<char, char, char>, IAdditiveIdentity<char, char>, IBinaryInteger<char>, IBinaryNumber<char>, IBitwiseOperators<char, char, char>, IComparable, IComparable<char>, IComparisonOperators<char, char>, IConvertible, IDecrementOperators<char>, IDivisionOperators<char, char, char>, IEqualityOperators<char, char>, IEquatable<char>, IFormattable, IIncrementOperators<char>, IMinMaxValue<char>, IModulusOperators<char, char, char>, IMultiplicativeIdentity<char, char>, IMultiplyOperators<char, char, char>, INumber<char>, INumberBase<char>, IParsable<char>, IShiftOperators<char, char>, ISpanFormattable, ISpanParsable<char>, ISubtractionOperators<char, char, char>, IUnaryNegationOperators<char, char>, IUnaryPlusOperators<char, char>, IUnsignedNumber<char> {
+        static int System.Numerics.INumberBase<System.Char>.Radix { get; }
-        public static char Clamp(char value, char min, char max);
-        public static char CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static char CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static char CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static (char Quotient, char Remainder) DivRem(char left, char right);
+        public static bool IsAsciiDigit(char c);
+        public static bool IsAsciiHexDigit(char c);
+        public static bool IsAsciiHexDigitLower(char c);
+        public static bool IsAsciiHexDigitUpper(char c);
+        public static bool IsAsciiLetter(char c);
+        public static bool IsAsciiLetterLower(char c);
+        public static bool IsAsciiLetterOrDigit(char c);
+        public static bool IsAsciiLetterUpper(char c);
+        public static bool IsBetween(char c, char minInclusive, char maxInclusive);
-        public static bool IsPow2(char value);
-        public static char LeadingZeroCount(char value);
-        public static char Log2(char value);
-        public static char Max(char x, char y);
-        public static char Min(char x, char y);
-        public static char PopCount(char value);
-        public static char RotateLeft(char value, int rotateAmount);
-        public static char RotateRight(char value, int rotateAmount);
-        public static int Sign(char value);
+        static (char Quotient, char Remainder) IBinaryInteger<char>.DivRem(char left, char right);
-        long IBinaryInteger<char>.GetShortestBitLength();
+        int IBinaryInteger<char>.GetShortestBitLength();
+        static char IBinaryInteger<char>.LeadingZeroCount(char value);
+        static char IBinaryInteger<char>.PopCount(char value);
+        static char IBinaryInteger<char>.RotateLeft(char value, int rotateAmount);
+        static char IBinaryInteger<char>.RotateRight(char value, int rotateAmount);
+        static char IBinaryInteger<char>.TrailingZeroCount(char value);
+        bool IBinaryInteger<char>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        static bool IBinaryNumber<char>.IsPow2(char value);
+        static char IBinaryNumber<char>.Log2(char value);
-        static char INumber<char>.Abs(char value);
+        static char INumber<char>.Clamp(char value, char min, char max);
-        static bool INumber<char>.IsNegative(char value);
+        static char INumber<char>.Max(char x, char y);
-        static char INumber<char>.MaxMagnitude(char x, char y);
+        static char INumber<char>.MaxNumber(char x, char y);
+        static char INumber<char>.Min(char x, char y);
-        static char INumber<char>.MinMagnitude(char x, char y);
+        static char INumber<char>.MinNumber(char x, char y);
-        static char INumber<char>.Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider);
-        static char INumber<char>.Parse(string s, NumberStyles style, IFormatProvider provider);
+        static int INumber<char>.Sign(char value);
-        static bool INumber<char>.TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out char result);
-        static bool INumber<char>.TryParse(string s, NumberStyles style, IFormatProvider provider, out char result);
+        static char INumberBase<char>.Abs(char value);
+        static bool INumberBase<char>.IsCanonical(char value);
+        static bool INumberBase<char>.IsComplexNumber(char value);
+        static bool INumberBase<char>.IsEvenInteger(char value);
+        static bool INumberBase<char>.IsFinite(char value);
+        static bool INumberBase<char>.IsImaginaryNumber(char value);
+        static bool INumberBase<char>.IsInfinity(char value);
+        static bool INumberBase<char>.IsInteger(char value);
+        static bool INumberBase<char>.IsNaN(char value);
+        static bool INumberBase<char>.IsNegative(char value);
+        static bool INumberBase<char>.IsNegativeInfinity(char value);
+        static bool INumberBase<char>.IsNormal(char value);
+        static bool INumberBase<char>.IsOddInteger(char value);
+        static bool INumberBase<char>.IsPositive(char value);
+        static bool INumberBase<char>.IsPositiveInfinity(char value);
+        static bool INumberBase<char>.IsRealNumber(char value);
+        static bool INumberBase<char>.IsSubnormal(char value);
+        static bool INumberBase<char>.IsZero(char value);
+        static char INumberBase<char>.MaxMagnitude(char x, char y);
+        static char INumberBase<char>.MaxMagnitudeNumber(char x, char y);
+        static char INumberBase<char>.MinMagnitude(char x, char y);
+        static char INumberBase<char>.MinMagnitudeNumber(char x, char y);
+        static char INumberBase<char>.Parse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider);
+        static char INumberBase<char>.Parse(string s, NumberStyles style, IFormatProvider provider);
+        static bool INumberBase<char>.TryConvertFromChecked<TOther>(TOther value, out char result);
+        static bool INumberBase<char>.TryConvertFromSaturating<TOther>(TOther value, out char result);
+        static bool INumberBase<char>.TryConvertFromTruncating<TOther>(TOther value, out char result);
+        static bool INumberBase<char>.TryConvertToChecked<TOther>(char value, out TOther result);
+        static bool INumberBase<char>.TryConvertToSaturating<TOther>(char value, out TOther result);
+        static bool INumberBase<char>.TryConvertToTruncating<TOther>(char value, out TOther result);
+        static bool INumberBase<char>.TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out char result);
+        static bool INumberBase<char>.TryParse(string s, NumberStyles style, IFormatProvider provider, out char result);
-        public static char TrailingZeroCount(char value);
-        public static bool TryCreate<TOther>(TOther value, out char result) where TOther : INumber<TOther>;
     }
-    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IComparisonOperators<DateOnly, DateOnly>, IEqualityOperators<DateOnly, DateOnly>, IEquatable<DateOnly>, IFormattable, IMinMaxValue<DateOnly>, IParsable<DateOnly>, ISpanFormattable, ISpanParsable<DateOnly>
+    public readonly struct DateOnly : IComparable, IComparable<DateOnly>, IEquatable<DateOnly>, IFormattable, IParsable<DateOnly>, ISpanFormattable, ISpanParsable<DateOnly>
-    public readonly struct DateTime : IAdditionOperators<DateTime, TimeSpan, DateTime>, IAdditiveIdentity<DateTime, TimeSpan>, IComparable, IComparable<DateTime>, IComparisonOperators<DateTime, DateTime>, IConvertible, IEqualityOperators<DateTime, DateTime>, IEquatable<DateTime>, IFormattable, IMinMaxValue<DateTime>, IParsable<DateTime>, ISerializable, ISpanFormattable, ISpanParsable<DateTime>, ISubtractionOperators<DateTime, DateTime, TimeSpan>, ISubtractionOperators<DateTime, TimeSpan, DateTime> {
+    public readonly struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, IParsable<DateTime>, ISerializable, ISpanFormattable, ISpanParsable<DateTime> {
-        static TimeSpan System.Numerics.IAdditiveIdentity<System.DateTime,System.TimeSpan>.AdditiveIdentity { get; }
-        static DateTime System.Numerics.IMinMaxValue<System.DateTime>.MaxValue { get; }
-        static DateTime System.Numerics.IMinMaxValue<System.DateTime>.MinValue { get; }
-        static DateTime IAdditionOperators<DateTime, TimeSpan, DateTime>.operator checked +(DateTime left, TimeSpan right);
-        static TimeSpan ISubtractionOperators<DateTime, DateTime, TimeSpan>.operator checked -(DateTime left, DateTime right);
-        static DateTime ISubtractionOperators<DateTime, TimeSpan, DateTime>.operator checked -(DateTime left, TimeSpan right);
     }
-    public readonly struct DateTimeOffset : IAdditionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>, IAdditiveIdentity<DateTimeOffset, TimeSpan>, IComparable, IComparable<DateTimeOffset>, IComparisonOperators<DateTimeOffset, DateTimeOffset>, IDeserializationCallback, IEqualityOperators<DateTimeOffset, DateTimeOffset>, IEquatable<DateTimeOffset>, IFormattable, IMinMaxValue<DateTimeOffset>, IParsable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParsable<DateTimeOffset>, ISubtractionOperators<DateTimeOffset, DateTimeOffset, TimeSpan>, ISubtractionOperators<DateTimeOffset, TimeSpan, DateTimeOffset> {
+    public readonly struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, IParsable<DateTimeOffset>, ISerializable, ISpanFormattable, ISpanParsable<DateTimeOffset> {
-        static TimeSpan System.Numerics.IAdditiveIdentity<System.DateTimeOffset,System.TimeSpan>.AdditiveIdentity { get; }
-        static DateTimeOffset System.Numerics.IMinMaxValue<System.DateTimeOffset>.MaxValue { get; }
-        static DateTimeOffset System.Numerics.IMinMaxValue<System.DateTimeOffset>.MinValue { get; }
-        static DateTimeOffset IAdditionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>.operator checked +(DateTimeOffset left, TimeSpan right);
-        static TimeSpan ISubtractionOperators<DateTimeOffset, DateTimeOffset, TimeSpan>.operator checked -(DateTimeOffset left, DateTimeOffset right);
-        static DateTimeOffset ISubtractionOperators<DateTimeOffset, TimeSpan, DateTimeOffset>.operator checked -(DateTimeOffset left, TimeSpan right);
     }
     public readonly struct Decimal : IAdditionOperators<decimal, decimal, decimal>, IAdditiveIdentity<decimal, decimal>, IComparable, IComparable<decimal>, IComparisonOperators<decimal, decimal>, IConvertible, IDecrementOperators<decimal>, IDeserializationCallback, IDivisionOperators<decimal, decimal, decimal>, IEqualityOperators<decimal, decimal>, IEquatable<decimal>, IFloatingPoint<decimal>, IFormattable, IIncrementOperators<decimal>, IMinMaxValue<decimal>, IModulusOperators<decimal, decimal, decimal>, IMultiplicativeIdentity<decimal, decimal>, IMultiplyOperators<decimal, decimal, decimal>, INumber<decimal>, INumberBase<decimal>, IParsable<decimal>, ISerializable, ISignedNumber<decimal>, ISpanFormattable, ISpanParsable<decimal>, ISubtractionOperators<decimal, decimal, decimal>, IUnaryNegationOperators<decimal, decimal>, IUnaryPlusOperators<decimal, decimal> {
+        static int System.Numerics.INumberBase<System.Decimal>.Radix { get; }
-        public static decimal CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static decimal CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static decimal CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsCanonical(decimal value);
+        public static bool IsEvenInteger(decimal value);
+        public static bool IsInteger(decimal value);
+        public static bool IsOddInteger(decimal value);
+        public static bool IsPositive(decimal value);
-        long IFloatingPoint<decimal>.GetExponentShortestBitLength();
+        int IFloatingPoint<decimal>.GetExponentShortestBitLength();
-        long IFloatingPoint<decimal>.GetSignificandBitLength();
+        int IFloatingPoint<decimal>.GetSignificandBitLength();
+        bool IFloatingPoint<decimal>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<decimal>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        static decimal INumber<decimal>.MaxNumber(decimal x, decimal y);
+        static decimal INumber<decimal>.MinNumber(decimal x, decimal y);
+        static bool INumberBase<decimal>.IsComplexNumber(decimal value);
+        static bool INumberBase<decimal>.IsFinite(decimal value);
+        static bool INumberBase<decimal>.IsImaginaryNumber(decimal value);
+        static bool INumberBase<decimal>.IsInfinity(decimal value);
+        static bool INumberBase<decimal>.IsNaN(decimal value);
+        static bool INumberBase<decimal>.IsNegativeInfinity(decimal value);
+        static bool INumberBase<decimal>.IsNormal(decimal value);
+        static bool INumberBase<decimal>.IsPositiveInfinity(decimal value);
+        static bool INumberBase<decimal>.IsRealNumber(decimal value);
+        static bool INumberBase<decimal>.IsSubnormal(decimal value);
+        static bool INumberBase<decimal>.IsZero(decimal value);
+        static decimal INumberBase<decimal>.MaxMagnitudeNumber(decimal x, decimal y);
+        static decimal INumberBase<decimal>.MinMagnitudeNumber(decimal x, decimal y);
+        static bool INumberBase<decimal>.TryConvertFromChecked<TOther>(TOther value, out decimal result);
+        static bool INumberBase<decimal>.TryConvertFromSaturating<TOther>(TOther value, out decimal result);
+        static bool INumberBase<decimal>.TryConvertFromTruncating<TOther>(TOther value, out decimal result);
+        static bool INumberBase<decimal>.TryConvertToChecked<TOther>(decimal value, out TOther result);
+        static bool INumberBase<decimal>.TryConvertToSaturating<TOther>(decimal value, out TOther result);
+        static bool INumberBase<decimal>.TryConvertToTruncating<TOther>(decimal value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out decimal result) where TOther : INumber<TOther>;
     }
     public readonly struct Double : IAdditionOperators<double, double, double>, IAdditiveIdentity<double, double>, IBinaryFloatingPointIeee754<double>, IBinaryNumber<double>, IBitwiseOperators<double, double, double>, IComparable, IComparable<double>, IComparisonOperators<double, double>, IConvertible, IDecrementOperators<double>, IDivisionOperators<double, double, double>, IEqualityOperators<double, double>, IEquatable<double>, IExponentialFunctions<double>, IFloatingPoint<double>, IFloatingPointIeee754<double>, IFormattable, IHyperbolicFunctions<double>, IIncrementOperators<double>, ILogarithmicFunctions<double>, IMinMaxValue<double>, IModulusOperators<double, double, double>, IMultiplicativeIdentity<double, double>, IMultiplyOperators<double, double, double>, INumber<double>, INumberBase<double>, IParsable<double>, IPowerFunctions<double>, IRootFunctions<double>, ISignedNumber<double>, ISpanFormattable, ISpanParsable<double>, ISubtractionOperators<double, double, double>, ITrigonometricFunctions<double>, IUnaryNegationOperators<double, double>, IUnaryPlusOperators<double, double> {
+        static int System.Numerics.INumberBase<System.Double>.Radix { get; }
-        public static double CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static double CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static double CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static double Exp10(double x);
+        public static double Exp10M1(double x);
+        public static double Exp2(double x);
+        public static double Exp2M1(double x);
+        public static double ExpM1(double x);
+        public static bool IsEvenInteger(double value);
+        public static bool IsInteger(double value);
+        public static bool IsOddInteger(double value);
+        public static bool IsPositive(double value);
+        public static bool IsRealNumber(double value);
+        public static double Log10P1(double x);
+        public static double Log2P1(double x);
+        public static double LogP1(double x);
+        public static double MaxMagnitudeNumber(double x, double y);
+        public static double MaxNumber(double x, double y);
+        public static double MinMagnitudeNumber(double x, double y);
+        public static double MinNumber(double x, double y);
-        long IFloatingPoint<double>.GetExponentShortestBitLength();
+        int IFloatingPoint<double>.GetExponentShortestBitLength();
-        long IFloatingPoint<double>.GetSignificandBitLength();
+        int IFloatingPoint<double>.GetSignificandBitLength();
+        bool IFloatingPoint<double>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<double>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        static bool INumberBase<double>.IsCanonical(double value);
+        static bool INumberBase<double>.IsComplexNumber(double value);
+        static bool INumberBase<double>.IsImaginaryNumber(double value);
+        static bool INumberBase<double>.IsZero(double value);
+        static bool INumberBase<double>.TryConvertFromChecked<TOther>(TOther value, out double result);
+        static bool INumberBase<double>.TryConvertFromSaturating<TOther>(TOther value, out double result);
+        static bool INumberBase<double>.TryConvertFromTruncating<TOther>(TOther value, out double result);
+        static bool INumberBase<double>.TryConvertToChecked<TOther>(double value, out TOther result);
+        static bool INumberBase<double>.TryConvertToSaturating<TOther>(double value, out TOther result);
+        static bool INumberBase<double>.TryConvertToTruncating<TOther>(double value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out double result) where TOther : INumber<TOther>;
     }
     public static class GC {
+        public static TimeSpan GetTotalPauseDuration();
     }
-    public readonly struct Guid : IComparable, IComparable<Guid>, IComparisonOperators<Guid, Guid>, IEqualityOperators<Guid, Guid>, IEquatable<Guid>, IFormattable, IParsable<Guid>, ISpanFormattable, ISpanParsable<Guid>
+    public readonly struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable, IParsable<Guid>, ISpanFormattable, ISpanParsable<Guid>
     public readonly struct Half : IAdditionOperators<Half, Half, Half>, IAdditiveIdentity<Half, Half>, IBinaryFloatingPointIeee754<Half>, IBinaryNumber<Half>, IBitwiseOperators<Half, Half, Half>, IComparable, IComparable<Half>, IComparisonOperators<Half, Half>, IDecrementOperators<Half>, IDivisionOperators<Half, Half, Half>, IEqualityOperators<Half, Half>, IEquatable<Half>, IExponentialFunctions<Half>, IFloatingPoint<Half>, IFloatingPointIeee754<Half>, IFormattable, IHyperbolicFunctions<Half>, IIncrementOperators<Half>, ILogarithmicFunctions<Half>, IMinMaxValue<Half>, IModulusOperators<Half, Half, Half>, IMultiplicativeIdentity<Half, Half>, IMultiplyOperators<Half, Half, Half>, INumber<Half>, INumberBase<Half>, IParsable<Half>, IPowerFunctions<Half>, IRootFunctions<Half>, ISignedNumber<Half>, ISpanFormattable, ISpanParsable<Half>, ISubtractionOperators<Half, Half, Half>, ITrigonometricFunctions<Half>, IUnaryNegationOperators<Half, Half>, IUnaryPlusOperators<Half, Half> {
+        public static Half NegativeOne { get; }
+        public static Half One { get; }
-        static Half System.Numerics.INumberBase<System.Half>.One { get; }
+        static int System.Numerics.INumberBase<System.Half>.Radix { get; }
-        static Half System.Numerics.INumberBase<System.Half>.Zero { get; }
-        static Half System.Numerics.ISignedNumber<System.Half>.NegativeOne { get; }
+        public static Half Zero { get; }
-        public static Half CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static Half CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static Half CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static Half Exp10(Half x);
+        public static Half Exp10M1(Half x);
+        public static Half Exp2(Half x);
+        public static Half Exp2M1(Half x);
+        public static Half ExpM1(Half x);
+        public static bool IsEvenInteger(Half value);
+        public static bool IsInteger(Half value);
+        public static bool IsOddInteger(Half value);
+        public static bool IsPositive(Half value);
+        public static bool IsRealNumber(Half value);
+        public static Half Log10P1(Half x);
+        public static Half Log2P1(Half x);
+        public static Half LogP1(Half x);
+        public static Half MaxMagnitudeNumber(Half x, Half y);
+        public static Half MaxNumber(Half x, Half y);
+        public static Half MinMagnitudeNumber(Half x, Half y);
+        public static Half MinNumber(Half x, Half y);
+        public static explicit operator checked byte (Half value);
+        public static explicit operator checked char (Half value);
+        public static explicit operator checked short (Half value);
+        public static explicit operator checked int (Half value);
+        public static explicit operator checked long (Half value);
+        public static explicit operator checked Int128 (Half value);
+        public static explicit operator checked IntPtr (Half value);
+        public static explicit operator checked sbyte (Half value);
+        public static explicit operator checked ushort (Half value);
+        public static explicit operator checked uint (Half value);
+        public static explicit operator checked ulong (Half value);
+        public static explicit operator checked UInt128 (Half value);
+        public static explicit operator checked UIntPtr (Half value);
+        public static explicit operator Half (char value);
+        public static explicit operator Half (decimal value);
+        public static explicit operator byte (Half value);
+        public static explicit operator char (Half value);
+        public static explicit operator decimal (Half value);
+        public static explicit operator Int128 (Half value);
+        public static explicit operator short (Half value);
+        public static explicit operator int (Half value);
+        public static explicit operator long (Half value);
+        public static explicit operator IntPtr (Half value);
+        public static explicit operator sbyte (Half value);
+        public static explicit operator UInt128 (Half value);
+        public static explicit operator ushort (Half value);
+        public static explicit operator uint (Half value);
+        public static explicit operator ulong (Half value);
+        public static explicit operator UIntPtr (Half value);
+        public static explicit operator Half (short value);
+        public static explicit operator Half (int value);
+        public static explicit operator Half (long value);
+        public static explicit operator Half (IntPtr value);
+        public static explicit operator Half (ushort value);
+        public static explicit operator Half (uint value);
+        public static explicit operator Half (ulong value);
+        public static explicit operator Half (UIntPtr value);
+        public static implicit operator Half (byte value);
+        public static implicit operator Half (sbyte value);
-        long IFloatingPoint<Half>.GetExponentShortestBitLength();
+        int IFloatingPoint<Half>.GetExponentShortestBitLength();
-        long IFloatingPoint<Half>.GetSignificandBitLength();
+        int IFloatingPoint<Half>.GetSignificandBitLength();
+        bool IFloatingPoint<Half>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<Half>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        static bool INumberBase<Half>.IsCanonical(Half value);
+        static bool INumberBase<Half>.IsComplexNumber(Half value);
+        static bool INumberBase<Half>.IsImaginaryNumber(Half value);
+        static bool INumberBase<Half>.IsZero(Half value);
+        static bool INumberBase<Half>.TryConvertFromChecked<TOther>(TOther value, out Half result);
+        static bool INumberBase<Half>.TryConvertFromSaturating<TOther>(TOther value, out Half result);
+        static bool INumberBase<Half>.TryConvertFromTruncating<TOther>(TOther value, out Half result);
+        static bool INumberBase<Half>.TryConvertToChecked<TOther>(Half value, out TOther result);
+        static bool INumberBase<Half>.TryConvertToSaturating<TOther>(Half value, out TOther result);
+        static bool INumberBase<Half>.TryConvertToTruncating<TOther>(Half value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out Half result) where TOther : INumber<TOther>;
     }
+    public readonly struct Int128 : IAdditionOperators<Int128, Int128, Int128>, IAdditiveIdentity<Int128, Int128>, IBinaryInteger<Int128>, IBinaryNumber<Int128>, IBitwiseOperators<Int128, Int128, Int128>, IComparable, IComparable<Int128>, IComparisonOperators<Int128, Int128>, IDecrementOperators<Int128>, IDivisionOperators<Int128, Int128, Int128>, IEqualityOperators<Int128, Int128>, IEquatable<Int128>, IFormattable, IIncrementOperators<Int128>, IMinMaxValue<Int128>, IModulusOperators<Int128, Int128, Int128>, IMultiplicativeIdentity<Int128, Int128>, IMultiplyOperators<Int128, Int128, Int128>, INumber<Int128>, INumberBase<Int128>, IParsable<Int128>, IShiftOperators<Int128, Int128>, ISignedNumber<Int128>, ISpanFormattable, ISpanParsable<Int128>, ISubtractionOperators<Int128, Int128, Int128>, IUnaryNegationOperators<Int128, Int128>, IUnaryPlusOperators<Int128, Int128> {
+        public Int128(ulong upper, ulong lower);
+        public static Int128 MaxValue { get; }
+        public static Int128 MinValue { get; }
+        public static Int128 NegativeOne { get; }
+        public static Int128 One { get; }
+        static Int128 System.Numerics.IAdditiveIdentity<System.Int128,System.Int128>.AdditiveIdentity { get; }
+        static Int128 System.Numerics.IMultiplicativeIdentity<System.Int128,System.Int128>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.Int128>.Radix { get; }
+        public static Int128 Zero { get; }
+        public static Int128 Abs(Int128 value);
+        public static Int128 Clamp(Int128 value, Int128 min, Int128 max);
+        public int CompareTo(Int128 value);
+        public int CompareTo(object? value);
+        public static Int128 CopySign(Int128 value, Int128 sign);
+        public static (Int128 Quotient, Int128 Remainder) DivRem(Int128 left, Int128 right);
+        public bool Equals(Int128 other);
+        public override bool Equals(object? obj);
+        public override int GetHashCode();
+        public static bool IsEvenInteger(Int128 value);
+        public static bool IsNegative(Int128 value);
+        public static bool IsOddInteger(Int128 value);
+        public static bool IsPositive(Int128 value);
+        public static bool IsPow2(Int128 value);
+        public static Int128 LeadingZeroCount(Int128 value);
+        public static Int128 Log2(Int128 value);
+        public static Int128 Max(Int128 x, Int128 y);
+        public static Int128 MaxMagnitude(Int128 x, Int128 y);
+        public static Int128 Min(Int128 x, Int128 y);
+        public static Int128 MinMagnitude(Int128 x, Int128 y);
+        public static Int128 operator +(Int128 left, Int128 right);
+        public static Int128 operator &(Int128 left, Int128 right);
+        public static Int128 operator |(Int128 left, Int128 right);
+        public static Int128 operator checked +(Int128 left, Int128 right);
+        public static Int128 operator checked --(Int128 value);
+        public static Int128 operator checked /(Int128 left, Int128 right);
+        public static explicit operator checked Int128 (double value);
+        public static explicit operator checked byte (Int128 value);
+        public static explicit operator checked char (Int128 value);
+        public static explicit operator checked short (Int128 value);
+        public static explicit operator checked int (Int128 value);
+        public static explicit operator checked long (Int128 value);
+        public static explicit operator checked nint (Int128 value);
+        public static explicit operator checked sbyte (Int128 value);
+        public static explicit operator checked ushort (Int128 value);
+        public static explicit operator checked uint (Int128 value);
+        public static explicit operator checked ulong (Int128 value);
+        public static explicit operator checked UInt128 (Int128 value);
+        public static explicit operator checked nuint (Int128 value);
+        public static explicit operator checked Int128 (float value);
+        public static Int128 operator checked ++(Int128 value);
+        public static Int128 operator checked *(Int128 left, Int128 right);
+        public static Int128 operator checked -(Int128 left, Int128 right);
+        public static Int128 operator checked -(Int128 value);
+        public static Int128 operator --(Int128 value);
+        public static Int128 operator /(Int128 left, Int128 right);
+        public static bool operator ==(Int128 left, Int128 right);
+        public static Int128 operator ^(Int128 left, Int128 right);
+        public static explicit operator Int128 (decimal value);
+        public static explicit operator Int128 (double value);
+        public static explicit operator byte (Int128 value);
+        public static explicit operator char (Int128 value);
+        public static explicit operator decimal (Int128 value);
+        public static explicit operator double (Int128 value);
+        public static explicit operator Half (Int128 value);
+        public static explicit operator short (Int128 value);
+        public static explicit operator int (Int128 value);
+        public static explicit operator long (Int128 value);
+        public static explicit operator nint (Int128 value);
+        public static explicit operator sbyte (Int128 value);
+        public static explicit operator float (Int128 value);
+        public static explicit operator UInt128 (Int128 value);
+        public static explicit operator ushort (Int128 value);
+        public static explicit operator uint (Int128 value);
+        public static explicit operator ulong (Int128 value);
+        public static explicit operator nuint (Int128 value);
+        public static explicit operator Int128 (float value);
+        public static bool operator >(Int128 left, Int128 right);
+        public static bool operator >=(Int128 left, Int128 right);
+        public static implicit operator Int128 (byte value);
+        public static implicit operator Int128 (char value);
+        public static implicit operator Int128 (short value);
+        public static implicit operator Int128 (int value);
+        public static implicit operator Int128 (long value);
+        public static implicit operator Int128 (nint value);
+        public static implicit operator Int128 (sbyte value);
+        public static implicit operator Int128 (ushort value);
+        public static implicit operator Int128 (uint value);
+        public static implicit operator Int128 (ulong value);
+        public static implicit operator Int128 (nuint value);
+        public static Int128 operator ++(Int128 value);
+        public static bool operator !=(Int128 left, Int128 right);
+        public static Int128 operator <<(Int128 value, int shiftAmount);
+        public static bool operator <(Int128 left, Int128 right);
+        public static bool operator <=(Int128 left, Int128 right);
+        public static Int128 operator %(Int128 left, Int128 right);
+        public static Int128 operator *(Int128 left, Int128 right);
+        public static Int128 operator ~(Int128 value);
+        public static Int128 operator >>(Int128 value, int shiftAmount);
+        public static Int128 operator -(Int128 left, Int128 right);
+        public static Int128 operator -(Int128 value);
+        public static Int128 operator +(Int128 value);
+        public static Int128 operator >>>(Int128 value, int shiftAmount);
+        public static Int128 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        public static Int128 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static Int128 Parse(string s);
+        public static Int128 Parse(string s, NumberStyles style);
+        public static Int128 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static Int128 Parse(string s, IFormatProvider? provider);
+        public static Int128 PopCount(Int128 value);
+        public static Int128 RotateLeft(Int128 value, int rotateAmount);
+        public static Int128 RotateRight(Int128 value, int rotateAmount);
+        public static int Sign(Int128 value);
+        int IBinaryInteger<Int128>.GetByteCount();
+        int IBinaryInteger<Int128>.GetShortestBitLength();
+        bool IBinaryInteger<Int128>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<Int128>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static Int128 INumber<Int128>.MaxNumber(Int128 x, Int128 y);
+        static Int128 INumber<Int128>.MinNumber(Int128 x, Int128 y);
+        static bool INumberBase<Int128>.IsCanonical(Int128 value);
+        static bool INumberBase<Int128>.IsComplexNumber(Int128 value);
+        static bool INumberBase<Int128>.IsFinite(Int128 value);
+        static bool INumberBase<Int128>.IsImaginaryNumber(Int128 value);
+        static bool INumberBase<Int128>.IsInfinity(Int128 value);
+        static bool INumberBase<Int128>.IsInteger(Int128 value);
+        static bool INumberBase<Int128>.IsNaN(Int128 value);
+        static bool INumberBase<Int128>.IsNegativeInfinity(Int128 value);
+        static bool INumberBase<Int128>.IsNormal(Int128 value);
+        static bool INumberBase<Int128>.IsPositiveInfinity(Int128 value);
+        static bool INumberBase<Int128>.IsRealNumber(Int128 value);
+        static bool INumberBase<Int128>.IsSubnormal(Int128 value);
+        static bool INumberBase<Int128>.IsZero(Int128 value);
+        static Int128 INumberBase<Int128>.MaxMagnitudeNumber(Int128 x, Int128 y);
+        static Int128 INumberBase<Int128>.MinMagnitudeNumber(Int128 x, Int128 y);
+        static bool INumberBase<Int128>.TryConvertFromChecked<TOther>(TOther value, out Int128 result);
+        static bool INumberBase<Int128>.TryConvertFromSaturating<TOther>(TOther value, out Int128 result);
+        static bool INumberBase<Int128>.TryConvertFromTruncating<TOther>(TOther value, out Int128 result);
+        static bool INumberBase<Int128>.TryConvertToChecked<TOther>(Int128 value, out TOther result);
+        static bool INumberBase<Int128>.TryConvertToSaturating<TOther>(Int128 value, out TOther result);
+        static bool INumberBase<Int128>.TryConvertToTruncating<TOther>(Int128 value, out TOther result);
+        public override string ToString();
+        public string ToString(IFormatProvider? provider);
+        public string ToString(string? format);
+        public string ToString(string? format, IFormatProvider? provider);
+        public static Int128 TrailingZeroCount(Int128 value);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Int128 result);
+        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse(string? s, IFormatProvider? provider, out Int128 result);
+        public static bool TryParse(string? s, out Int128 result);
+    }
     public readonly struct Int16 : IAdditionOperators<short, short, short>, IAdditiveIdentity<short, short>, IBinaryInteger<short>, IBinaryNumber<short>, IBitwiseOperators<short, short, short>, IComparable, IComparable<short>, IComparisonOperators<short, short>, IConvertible, IDecrementOperators<short>, IDivisionOperators<short, short, short>, IEqualityOperators<short, short>, IEquatable<short>, IFormattable, IIncrementOperators<short>, IMinMaxValue<short>, IModulusOperators<short, short, short>, IMultiplicativeIdentity<short, short>, IMultiplyOperators<short, short, short>, INumber<short>, INumberBase<short>, IParsable<short>, IShiftOperators<short, short>, ISignedNumber<short>, ISpanFormattable, ISpanParsable<short>, ISubtractionOperators<short, short, short>, IUnaryNegationOperators<short, short>, IUnaryPlusOperators<short, short> {
+        static int System.Numerics.INumberBase<System.Int16>.Radix { get; }
-        public static short CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static short CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static short CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(short value);
+        public static bool IsOddInteger(short value);
+        public static bool IsPositive(short value);
-        long IBinaryInteger<short>.GetShortestBitLength();
+        int IBinaryInteger<short>.GetShortestBitLength();
+        bool IBinaryInteger<short>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        static short INumber<short>.MaxNumber(short x, short y);
+        static short INumber<short>.MinNumber(short x, short y);
+        static bool INumberBase<short>.IsCanonical(short value);
+        static bool INumberBase<short>.IsComplexNumber(short value);
+        static bool INumberBase<short>.IsFinite(short value);
+        static bool INumberBase<short>.IsImaginaryNumber(short value);
+        static bool INumberBase<short>.IsInfinity(short value);
+        static bool INumberBase<short>.IsInteger(short value);
+        static bool INumberBase<short>.IsNaN(short value);
+        static bool INumberBase<short>.IsNegativeInfinity(short value);
+        static bool INumberBase<short>.IsNormal(short value);
+        static bool INumberBase<short>.IsPositiveInfinity(short value);
+        static bool INumberBase<short>.IsRealNumber(short value);
+        static bool INumberBase<short>.IsSubnormal(short value);
+        static bool INumberBase<short>.IsZero(short value);
+        static short INumberBase<short>.MaxMagnitudeNumber(short x, short y);
+        static short INumberBase<short>.MinMagnitudeNumber(short x, short y);
+        static bool INumberBase<short>.TryConvertFromChecked<TOther>(TOther value, out short result);
+        static bool INumberBase<short>.TryConvertFromSaturating<TOther>(TOther value, out short result);
+        static bool INumberBase<short>.TryConvertFromTruncating<TOther>(TOther value, out short result);
+        static bool INumberBase<short>.TryConvertToChecked<TOther>(short value, out TOther result);
+        static bool INumberBase<short>.TryConvertToSaturating<TOther>(short value, out TOther result);
+        static bool INumberBase<short>.TryConvertToTruncating<TOther>(short value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out short result) where TOther : INumber<TOther>;
     }
     public readonly struct Int32 : IAdditionOperators<int, int, int>, IAdditiveIdentity<int, int>, IBinaryInteger<int>, IBinaryNumber<int>, IBitwiseOperators<int, int, int>, IComparable, IComparable<int>, IComparisonOperators<int, int>, IConvertible, IDecrementOperators<int>, IDivisionOperators<int, int, int>, IEqualityOperators<int, int>, IEquatable<int>, IFormattable, IIncrementOperators<int>, IMinMaxValue<int>, IModulusOperators<int, int, int>, IMultiplicativeIdentity<int, int>, IMultiplyOperators<int, int, int>, INumber<int>, INumberBase<int>, IParsable<int>, IShiftOperators<int, int>, ISignedNumber<int>, ISpanFormattable, ISpanParsable<int>, ISubtractionOperators<int, int, int>, IUnaryNegationOperators<int, int>, IUnaryPlusOperators<int, int> {
+        static int System.Numerics.INumberBase<System.Int32>.Radix { get; }
-        public static int CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static int CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static int CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(int value);
+        public static bool IsOddInteger(int value);
+        public static bool IsPositive(int value);
-        long IBinaryInteger<int>.GetShortestBitLength();
+        int IBinaryInteger<int>.GetShortestBitLength();
+        bool IBinaryInteger<int>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        static int INumber<int>.MaxNumber(int x, int y);
+        static int INumber<int>.MinNumber(int x, int y);
+        static bool INumberBase<int>.IsCanonical(int value);
+        static bool INumberBase<int>.IsComplexNumber(int value);
+        static bool INumberBase<int>.IsFinite(int value);
+        static bool INumberBase<int>.IsImaginaryNumber(int value);
+        static bool INumberBase<int>.IsInfinity(int value);
+        static bool INumberBase<int>.IsInteger(int value);
+        static bool INumberBase<int>.IsNaN(int value);
+        static bool INumberBase<int>.IsNegativeInfinity(int value);
+        static bool INumberBase<int>.IsNormal(int value);
+        static bool INumberBase<int>.IsPositiveInfinity(int value);
+        static bool INumberBase<int>.IsRealNumber(int value);
+        static bool INumberBase<int>.IsSubnormal(int value);
+        static bool INumberBase<int>.IsZero(int value);
+        static int INumberBase<int>.MaxMagnitudeNumber(int x, int y);
+        static int INumberBase<int>.MinMagnitudeNumber(int x, int y);
+        static bool INumberBase<int>.TryConvertFromChecked<TOther>(TOther value, out int result);
+        static bool INumberBase<int>.TryConvertFromSaturating<TOther>(TOther value, out int result);
+        static bool INumberBase<int>.TryConvertFromTruncating<TOther>(TOther value, out int result);
+        static bool INumberBase<int>.TryConvertToChecked<TOther>(int value, out TOther result);
+        static bool INumberBase<int>.TryConvertToSaturating<TOther>(int value, out TOther result);
+        static bool INumberBase<int>.TryConvertToTruncating<TOther>(int value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out int result) where TOther : INumber<TOther>;
     }
     public readonly struct Int64 : IAdditionOperators<long, long, long>, IAdditiveIdentity<long, long>, IBinaryInteger<long>, IBinaryNumber<long>, IBitwiseOperators<long, long, long>, IComparable, IComparable<long>, IComparisonOperators<long, long>, IConvertible, IDecrementOperators<long>, IDivisionOperators<long, long, long>, IEqualityOperators<long, long>, IEquatable<long>, IFormattable, IIncrementOperators<long>, IMinMaxValue<long>, IModulusOperators<long, long, long>, IMultiplicativeIdentity<long, long>, IMultiplyOperators<long, long, long>, INumber<long>, INumberBase<long>, IParsable<long>, IShiftOperators<long, long>, ISignedNumber<long>, ISpanFormattable, ISpanParsable<long>, ISubtractionOperators<long, long, long>, IUnaryNegationOperators<long, long>, IUnaryPlusOperators<long, long> {
+        static int System.Numerics.INumberBase<System.Int64>.Radix { get; }
-        public static long CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static long CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static long CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(long value);
+        public static bool IsOddInteger(long value);
+        public static bool IsPositive(long value);
-        long IBinaryInteger<long>.GetShortestBitLength();
+        int IBinaryInteger<long>.GetShortestBitLength();
+        bool IBinaryInteger<long>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        static long INumber<long>.MaxNumber(long x, long y);
+        static long INumber<long>.MinNumber(long x, long y);
+        static bool INumberBase<long>.IsCanonical(long value);
+        static bool INumberBase<long>.IsComplexNumber(long value);
+        static bool INumberBase<long>.IsFinite(long value);
+        static bool INumberBase<long>.IsImaginaryNumber(long value);
+        static bool INumberBase<long>.IsInfinity(long value);
+        static bool INumberBase<long>.IsInteger(long value);
+        static bool INumberBase<long>.IsNaN(long value);
+        static bool INumberBase<long>.IsNegativeInfinity(long value);
+        static bool INumberBase<long>.IsNormal(long value);
+        static bool INumberBase<long>.IsPositiveInfinity(long value);
+        static bool INumberBase<long>.IsRealNumber(long value);
+        static bool INumberBase<long>.IsSubnormal(long value);
+        static bool INumberBase<long>.IsZero(long value);
+        static long INumberBase<long>.MaxMagnitudeNumber(long x, long y);
+        static long INumberBase<long>.MinMagnitudeNumber(long x, long y);
+        static bool INumberBase<long>.TryConvertFromChecked<TOther>(TOther value, out long result);
+        static bool INumberBase<long>.TryConvertFromSaturating<TOther>(TOther value, out long result);
+        static bool INumberBase<long>.TryConvertFromTruncating<TOther>(TOther value, out long result);
+        static bool INumberBase<long>.TryConvertToChecked<TOther>(long value, out TOther result);
+        static bool INumberBase<long>.TryConvertToSaturating<TOther>(long value, out TOther result);
+        static bool INumberBase<long>.TryConvertToTruncating<TOther>(long value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out long result) where TOther : INumber<TOther>;
     }
     public readonly struct IntPtr : IAdditionOperators<IntPtr, IntPtr, IntPtr>, IAdditiveIdentity<IntPtr, IntPtr>, IBinaryInteger<IntPtr>, IBinaryNumber<IntPtr>, IBitwiseOperators<IntPtr, IntPtr, IntPtr>, IComparable, IComparable<IntPtr>, IComparisonOperators<IntPtr, IntPtr>, IDecrementOperators<IntPtr>, IDivisionOperators<IntPtr, IntPtr, IntPtr>, IEqualityOperators<IntPtr, IntPtr>, IEquatable<IntPtr>, IFormattable, IIncrementOperators<IntPtr>, IMinMaxValue<IntPtr>, IModulusOperators<IntPtr, IntPtr, IntPtr>, IMultiplicativeIdentity<IntPtr, IntPtr>, IMultiplyOperators<IntPtr, IntPtr, IntPtr>, INumber<IntPtr>, INumberBase<IntPtr>, IParsable<IntPtr>, ISerializable, IShiftOperators<IntPtr, IntPtr>, ISignedNumber<IntPtr>, ISpanFormattable, ISpanParsable<IntPtr>, ISubtractionOperators<IntPtr, IntPtr, IntPtr>, IUnaryNegationOperators<IntPtr, IntPtr>, IUnaryPlusOperators<IntPtr, IntPtr> {
+        static int System.Numerics.INumberBase<nint>.Radix { get; }
+        public static IntPtr Abs(IntPtr value);
+        public static IntPtr Clamp(IntPtr value, IntPtr min, IntPtr max);
+        public static IntPtr CopySign(IntPtr value, IntPtr sign);
+        public static (IntPtr Quotient, IntPtr Remainder) DivRem(IntPtr left, IntPtr right);
+        public static bool IsEvenInteger(IntPtr value);
+        public static bool IsNegative(IntPtr value);
+        public static bool IsOddInteger(IntPtr value);
+        public static bool IsPositive(IntPtr value);
+        public static bool IsPow2(IntPtr value);
+        public static IntPtr LeadingZeroCount(IntPtr value);
+        public static IntPtr Log2(IntPtr value);
+        public static IntPtr Max(IntPtr x, IntPtr y);
+        public static IntPtr MaxMagnitude(IntPtr x, IntPtr y);
+        public static IntPtr Min(IntPtr x, IntPtr y);
+        public static IntPtr MinMagnitude(IntPtr x, IntPtr y);
+        public static IntPtr PopCount(IntPtr value);
+        public static IntPtr RotateLeft(IntPtr value, int rotateAmount);
+        public static IntPtr RotateRight(IntPtr value, int rotateAmount);
+        public static int Sign(IntPtr value);
-        static (IntPtr Quotient, IntPtr Remainder) IBinaryInteger<IntPtr>.DivRem(IntPtr left, IntPtr right);
-        long IBinaryInteger<IntPtr>.GetShortestBitLength();
+        int IBinaryInteger<IntPtr>.GetShortestBitLength();
-        static IntPtr IBinaryInteger<IntPtr>.LeadingZeroCount(IntPtr value);
-        static IntPtr IBinaryInteger<IntPtr>.PopCount(IntPtr value);
-        static IntPtr IBinaryInteger<IntPtr>.RotateLeft(IntPtr value, int rotateAmount);
-        static IntPtr IBinaryInteger<IntPtr>.RotateRight(IntPtr value, int rotateAmount);
-        static IntPtr IBinaryInteger<IntPtr>.TrailingZeroCount(IntPtr value);
+        bool IBinaryInteger<IntPtr>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
-        static bool IBinaryNumber<IntPtr>.IsPow2(IntPtr value);
-        static IntPtr IBinaryNumber<IntPtr>.Log2(IntPtr value);
-        static IntPtr INumber<IntPtr>.Abs(IntPtr value);
-        static IntPtr INumber<IntPtr>.Clamp(IntPtr value, IntPtr min, IntPtr max);
-        static IntPtr INumber<IntPtr>.CopySign(IntPtr value, IntPtr sign);
-        static IntPtr INumber<IntPtr>.CreateChecked<TOther>(TOther value);
-        static IntPtr INumber<IntPtr>.CreateSaturating<TOther>(TOther value);
-        static IntPtr INumber<IntPtr>.CreateTruncating<TOther>(TOther value);
-        static bool INumber<IntPtr>.IsNegative(IntPtr value);
-        static IntPtr INumber<IntPtr>.Max(IntPtr x, IntPtr y);
-        static IntPtr INumber<IntPtr>.MaxMagnitude(IntPtr x, IntPtr y);
+        static IntPtr INumber<IntPtr>.MaxNumber(IntPtr x, IntPtr y);
-        static IntPtr INumber<IntPtr>.Min(IntPtr x, IntPtr y);
-        static IntPtr INumber<IntPtr>.MinMagnitude(IntPtr x, IntPtr y);
+        static IntPtr INumber<IntPtr>.MinNumber(IntPtr x, IntPtr y);
-        static int INumber<IntPtr>.Sign(IntPtr value);
-        static bool INumber<IntPtr>.TryCreate<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.IsCanonical(IntPtr value);
+        static bool INumberBase<IntPtr>.IsComplexNumber(IntPtr value);
+        static bool INumberBase<IntPtr>.IsFinite(IntPtr value);
+        static bool INumberBase<IntPtr>.IsImaginaryNumber(IntPtr value);
+        static bool INumberBase<IntPtr>.IsInfinity(IntPtr value);
+        static bool INumberBase<IntPtr>.IsInteger(IntPtr value);
+        static bool INumberBase<IntPtr>.IsNaN(IntPtr value);
+        static bool INumberBase<IntPtr>.IsNegativeInfinity(IntPtr value);
+        static bool INumberBase<IntPtr>.IsNormal(IntPtr value);
+        static bool INumberBase<IntPtr>.IsPositiveInfinity(IntPtr value);
+        static bool INumberBase<IntPtr>.IsRealNumber(IntPtr value);
+        static bool INumberBase<IntPtr>.IsSubnormal(IntPtr value);
+        static bool INumberBase<IntPtr>.IsZero(IntPtr value);
+        static IntPtr INumberBase<IntPtr>.MaxMagnitudeNumber(IntPtr x, IntPtr y);
+        static IntPtr INumberBase<IntPtr>.MinMagnitudeNumber(IntPtr x, IntPtr y);
+        static bool INumberBase<IntPtr>.TryConvertFromChecked<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.TryConvertFromSaturating<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.TryConvertFromTruncating<TOther>(TOther value, out IntPtr result);
+        static bool INumberBase<IntPtr>.TryConvertToChecked<TOther>(IntPtr value, out TOther result);
+        static bool INumberBase<IntPtr>.TryConvertToSaturating<TOther>(IntPtr value, out TOther result);
+        static bool INumberBase<IntPtr>.TryConvertToTruncating<TOther>(IntPtr value, out TOther result);
+        public static IntPtr TrailingZeroCount(IntPtr value);
     }
     public struct RuntimeFieldHandle : IEquatable<RuntimeFieldHandle>, ISerializable {
+        public static RuntimeFieldHandle FromIntPtr(IntPtr value);
+        public static IntPtr ToIntPtr(RuntimeFieldHandle value);
     }
     public struct RuntimeMethodHandle : IEquatable<RuntimeMethodHandle>, ISerializable {
+        public static RuntimeMethodHandle FromIntPtr(IntPtr value);
+        public static IntPtr ToIntPtr(RuntimeMethodHandle value);
     }
     public struct RuntimeTypeHandle : IEquatable<RuntimeTypeHandle>, ISerializable {
+        public static RuntimeTypeHandle FromIntPtr(IntPtr value);
+        public static IntPtr ToIntPtr(RuntimeTypeHandle value);
     }
     public readonly struct SByte : IAdditionOperators<sbyte, sbyte, sbyte>, IAdditiveIdentity<sbyte, sbyte>, IBinaryInteger<sbyte>, IBinaryNumber<sbyte>, IBitwiseOperators<sbyte, sbyte, sbyte>, IComparable, IComparable<sbyte>, IComparisonOperators<sbyte, sbyte>, IConvertible, IDecrementOperators<sbyte>, IDivisionOperators<sbyte, sbyte, sbyte>, IEqualityOperators<sbyte, sbyte>, IEquatable<sbyte>, IFormattable, IIncrementOperators<sbyte>, IMinMaxValue<sbyte>, IModulusOperators<sbyte, sbyte, sbyte>, IMultiplicativeIdentity<sbyte, sbyte>, IMultiplyOperators<sbyte, sbyte, sbyte>, INumber<sbyte>, INumberBase<sbyte>, IParsable<sbyte>, IShiftOperators<sbyte, sbyte>, ISignedNumber<sbyte>, ISpanFormattable, ISpanParsable<sbyte>, ISubtractionOperators<sbyte, sbyte, sbyte>, IUnaryNegationOperators<sbyte, sbyte>, IUnaryPlusOperators<sbyte, sbyte> {
+        static int System.Numerics.INumberBase<System.SByte>.Radix { get; }
-        public static sbyte CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static sbyte CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static sbyte CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(sbyte value);
+        public static bool IsOddInteger(sbyte value);
+        public static bool IsPositive(sbyte value);
-        long IBinaryInteger<sbyte>.GetShortestBitLength();
+        int IBinaryInteger<sbyte>.GetShortestBitLength();
+        bool IBinaryInteger<sbyte>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        static sbyte INumber<sbyte>.MaxNumber(sbyte x, sbyte y);
+        static sbyte INumber<sbyte>.MinNumber(sbyte x, sbyte y);
+        static bool INumberBase<sbyte>.IsCanonical(sbyte value);
+        static bool INumberBase<sbyte>.IsComplexNumber(sbyte value);
+        static bool INumberBase<sbyte>.IsFinite(sbyte value);
+        static bool INumberBase<sbyte>.IsImaginaryNumber(sbyte value);
+        static bool INumberBase<sbyte>.IsInfinity(sbyte value);
+        static bool INumberBase<sbyte>.IsInteger(sbyte value);
+        static bool INumberBase<sbyte>.IsNaN(sbyte value);
+        static bool INumberBase<sbyte>.IsNegativeInfinity(sbyte value);
+        static bool INumberBase<sbyte>.IsNormal(sbyte value);
+        static bool INumberBase<sbyte>.IsPositiveInfinity(sbyte value);
+        static bool INumberBase<sbyte>.IsRealNumber(sbyte value);
+        static bool INumberBase<sbyte>.IsSubnormal(sbyte value);
+        static bool INumberBase<sbyte>.IsZero(sbyte value);
+        static sbyte INumberBase<sbyte>.MaxMagnitudeNumber(sbyte x, sbyte y);
+        static sbyte INumberBase<sbyte>.MinMagnitudeNumber(sbyte x, sbyte y);
+        static bool INumberBase<sbyte>.TryConvertFromChecked<TOther>(TOther value, out sbyte result);
+        static bool INumberBase<sbyte>.TryConvertFromSaturating<TOther>(TOther value, out sbyte result);
+        static bool INumberBase<sbyte>.TryConvertFromTruncating<TOther>(TOther value, out sbyte result);
+        static bool INumberBase<sbyte>.TryConvertToChecked<TOther>(sbyte value, out TOther result);
+        static bool INumberBase<sbyte>.TryConvertToSaturating<TOther>(sbyte value, out TOther result);
+        static bool INumberBase<sbyte>.TryConvertToTruncating<TOther>(sbyte value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out sbyte result) where TOther : INumber<TOther>;
     }
     public readonly struct Single : IAdditionOperators<float, float, float>, IAdditiveIdentity<float, float>, IBinaryFloatingPointIeee754<float>, IBinaryNumber<float>, IBitwiseOperators<float, float, float>, IComparable, IComparable<float>, IComparisonOperators<float, float>, IConvertible, IDecrementOperators<float>, IDivisionOperators<float, float, float>, IEqualityOperators<float, float>, IEquatable<float>, IExponentialFunctions<float>, IFloatingPoint<float>, IFloatingPointIeee754<float>, IFormattable, IHyperbolicFunctions<float>, IIncrementOperators<float>, ILogarithmicFunctions<float>, IMinMaxValue<float>, IModulusOperators<float, float, float>, IMultiplicativeIdentity<float, float>, IMultiplyOperators<float, float, float>, INumber<float>, INumberBase<float>, IParsable<float>, IPowerFunctions<float>, IRootFunctions<float>, ISignedNumber<float>, ISpanFormattable, ISpanParsable<float>, ISubtractionOperators<float, float, float>, ITrigonometricFunctions<float>, IUnaryNegationOperators<float, float>, IUnaryPlusOperators<float, float> {
+        static int System.Numerics.INumberBase<System.Single>.Radix { get; }
-        public static float CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static float CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static float CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static float Exp10(float x);
+        public static float Exp10M1(float x);
+        public static float Exp2(float x);
+        public static float Exp2M1(float x);
+        public static float ExpM1(float x);
+        public static bool IsEvenInteger(float value);
+        public static bool IsInteger(float value);
+        public static bool IsOddInteger(float value);
+        public static bool IsPositive(float value);
+        public static bool IsRealNumber(float value);
+        public static float Log10P1(float x);
+        public static float Log2P1(float x);
+        public static float LogP1(float x);
+        public static float MaxMagnitudeNumber(float x, float y);
+        public static float MaxNumber(float x, float y);
+        public static float MinMagnitudeNumber(float x, float y);
+        public static float MinNumber(float x, float y);
-        long IFloatingPoint<float>.GetExponentShortestBitLength();
+        int IFloatingPoint<float>.GetExponentShortestBitLength();
-        long IFloatingPoint<float>.GetSignificandBitLength();
+        int IFloatingPoint<float>.GetSignificandBitLength();
+        bool IFloatingPoint<float>.TryWriteExponentBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IFloatingPoint<float>.TryWriteSignificandBigEndian(Span<byte> destination, out int bytesWritten);
+        static bool INumberBase<float>.IsCanonical(float value);
+        static bool INumberBase<float>.IsComplexNumber(float value);
+        static bool INumberBase<float>.IsImaginaryNumber(float value);
+        static bool INumberBase<float>.IsZero(float value);
+        static bool INumberBase<float>.TryConvertFromChecked<TOther>(TOther value, out float result);
+        static bool INumberBase<float>.TryConvertFromSaturating<TOther>(TOther value, out float result);
+        static bool INumberBase<float>.TryConvertFromTruncating<TOther>(TOther value, out float result);
+        static bool INumberBase<float>.TryConvertToChecked<TOther>(float value, out TOther result);
+        static bool INumberBase<float>.TryConvertToSaturating<TOther>(float value, out TOther result);
+        static bool INumberBase<float>.TryConvertToTruncating<TOther>(float value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out float result) where TOther : INumber<TOther>;
     }
-    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IComparisonOperators<TimeOnly, TimeOnly>, IEqualityOperators<TimeOnly, TimeOnly>, IEquatable<TimeOnly>, IFormattable, IMinMaxValue<TimeOnly>, IParsable<TimeOnly>, ISpanFormattable, ISpanParsable<TimeOnly>, ISubtractionOperators<TimeOnly, TimeOnly, TimeSpan> {
+    public readonly struct TimeOnly : IComparable, IComparable<TimeOnly>, IEquatable<TimeOnly>, IFormattable, IParsable<TimeOnly>, ISpanFormattable, ISpanParsable<TimeOnly> {
-        static TimeSpan ISubtractionOperators<TimeOnly, TimeOnly, TimeSpan>.operator checked -(TimeOnly left, TimeOnly right);
     }
-    public readonly struct TimeSpan : IAdditionOperators<TimeSpan, TimeSpan, TimeSpan>, IAdditiveIdentity<TimeSpan, TimeSpan>, IComparable, IComparable<TimeSpan>, IComparisonOperators<TimeSpan, TimeSpan>, IDivisionOperators<TimeSpan, double, TimeSpan>, IDivisionOperators<TimeSpan, TimeSpan, double>, IEqualityOperators<TimeSpan, TimeSpan>, IEquatable<TimeSpan>, IFormattable, IMinMaxValue<TimeSpan>, IMultiplicativeIdentity<TimeSpan, double>, IMultiplyOperators<TimeSpan, double, TimeSpan>, IParsable<TimeSpan>, ISpanFormattable, ISpanParsable<TimeSpan>, ISubtractionOperators<TimeSpan, TimeSpan, TimeSpan>, IUnaryNegationOperators<TimeSpan, TimeSpan>, IUnaryPlusOperators<TimeSpan, TimeSpan> {
+    public readonly struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable, IParsable<TimeSpan>, ISpanFormattable, ISpanParsable<TimeSpan> {
-        static TimeSpan System.Numerics.IAdditiveIdentity<System.TimeSpan,System.TimeSpan>.AdditiveIdentity { get; }
-        static TimeSpan System.Numerics.IMinMaxValue<System.TimeSpan>.MaxValue { get; }
-        static TimeSpan System.Numerics.IMinMaxValue<System.TimeSpan>.MinValue { get; }
-        static double System.Numerics.IMultiplicativeIdentity<System.TimeSpan,System.Double>.MultiplicativeIdentity { get; }
-        static TimeSpan IAdditionOperators<TimeSpan, TimeSpan, TimeSpan>.operator checked +(TimeSpan left, TimeSpan right);
-        static TimeSpan IDivisionOperators<TimeSpan, double, TimeSpan>.operator checked /(TimeSpan left, double right);
-        static double IDivisionOperators<TimeSpan, TimeSpan, double>.operator checked /(TimeSpan left, TimeSpan right);
-        static TimeSpan IMultiplyOperators<TimeSpan, double, TimeSpan>.operator checked *(TimeSpan left, double right);
-        static TimeSpan ISubtractionOperators<TimeSpan, TimeSpan, TimeSpan>.operator checked -(TimeSpan left, TimeSpan right);
-        static TimeSpan IUnaryNegationOperators<TimeSpan, TimeSpan>.operator checked -(TimeSpan value);
     }
+    public readonly struct UInt128 : IAdditionOperators<UInt128, UInt128, UInt128>, IAdditiveIdentity<UInt128, UInt128>, IBinaryInteger<UInt128>, IBinaryNumber<UInt128>, IBitwiseOperators<UInt128, UInt128, UInt128>, IComparable, IComparable<UInt128>, IComparisonOperators<UInt128, UInt128>, IDecrementOperators<UInt128>, IDivisionOperators<UInt128, UInt128, UInt128>, IEqualityOperators<UInt128, UInt128>, IEquatable<UInt128>, IFormattable, IIncrementOperators<UInt128>, IMinMaxValue<UInt128>, IModulusOperators<UInt128, UInt128, UInt128>, IMultiplicativeIdentity<UInt128, UInt128>, IMultiplyOperators<UInt128, UInt128, UInt128>, INumber<UInt128>, INumberBase<UInt128>, IParsable<UInt128>, IShiftOperators<UInt128, UInt128>, ISpanFormattable, ISpanParsable<UInt128>, ISubtractionOperators<UInt128, UInt128, UInt128>, IUnaryNegationOperators<UInt128, UInt128>, IUnaryPlusOperators<UInt128, UInt128>, IUnsignedNumber<UInt128> {
+        public UInt128(ulong upper, ulong lower);
+        public static UInt128 MaxValue { get; }
+        public static UInt128 MinValue { get; }
+        public static UInt128 One { get; }
+        static UInt128 System.Numerics.IAdditiveIdentity<System.UInt128,System.UInt128>.AdditiveIdentity { get; }
+        static UInt128 System.Numerics.IMultiplicativeIdentity<System.UInt128,System.UInt128>.MultiplicativeIdentity { get; }
+        static int System.Numerics.INumberBase<System.UInt128>.Radix { get; }
+        public static UInt128 Zero { get; }
+        public static UInt128 Clamp(UInt128 value, UInt128 min, UInt128 max);
+        public int CompareTo(object? value);
+        public int CompareTo(UInt128 value);
+        public static (UInt128 Quotient, UInt128 Remainder) DivRem(UInt128 left, UInt128 right);
+        public override bool Equals(object? obj);
+        public bool Equals(UInt128 other);
+        public override int GetHashCode();
+        public static bool IsEvenInteger(UInt128 value);
+        public static bool IsOddInteger(UInt128 value);
+        public static bool IsPow2(UInt128 value);
+        public static UInt128 LeadingZeroCount(UInt128 value);
+        public static UInt128 Log2(UInt128 value);
+        public static UInt128 Max(UInt128 x, UInt128 y);
+        public static UInt128 Min(UInt128 x, UInt128 y);
+        public static UInt128 operator +(UInt128 left, UInt128 right);
+        public static UInt128 operator &(UInt128 left, UInt128 right);
+        public static UInt128 operator |(UInt128 left, UInt128 right);
+        public static UInt128 operator checked +(UInt128 left, UInt128 right);
+        public static UInt128 operator checked --(UInt128 value);
+        public static UInt128 operator checked /(UInt128 left, UInt128 right);
+        public static explicit operator checked UInt128 (double value);
+        public static explicit operator checked UInt128 (short value);
+        public static explicit operator checked UInt128 (int value);
+        public static explicit operator checked UInt128 (long value);
+        public static explicit operator checked UInt128 (nint value);
+        public static explicit operator checked UInt128 (sbyte value);
+        public static explicit operator checked UInt128 (float value);
+        public static explicit operator checked byte (UInt128 value);
+        public static explicit operator checked char (UInt128 value);
+        public static explicit operator checked short (UInt128 value);
+        public static explicit operator checked int (UInt128 value);
+        public static explicit operator checked long (UInt128 value);
+        public static explicit operator checked Int128 (UInt128 value);
+        public static explicit operator checked nint (UInt128 value);
+        public static explicit operator checked sbyte (UInt128 value);
+        public static explicit operator checked ushort (UInt128 value);
+        public static explicit operator checked uint (UInt128 value);
+        public static explicit operator checked ulong (UInt128 value);
+        public static explicit operator checked nuint (UInt128 value);
+        public static UInt128 operator checked ++(UInt128 value);
+        public static UInt128 operator checked *(UInt128 left, UInt128 right);
+        public static UInt128 operator checked -(UInt128 left, UInt128 right);
+        public static UInt128 operator checked -(UInt128 value);
+        public static UInt128 operator --(UInt128 value);
+        public static UInt128 operator /(UInt128 left, UInt128 right);
+        public static bool operator ==(UInt128 left, UInt128 right);
+        public static UInt128 operator ^(UInt128 left, UInt128 right);
+        public static explicit operator UInt128 (decimal value);
+        public static explicit operator UInt128 (double value);
+        public static explicit operator UInt128 (short value);
+        public static explicit operator UInt128 (int value);
+        public static explicit operator UInt128 (long value);
+        public static explicit operator UInt128 (nint value);
+        public static explicit operator UInt128 (sbyte value);
+        public static explicit operator UInt128 (float value);
+        public static explicit operator byte (UInt128 value);
+        public static explicit operator char (UInt128 value);
+        public static explicit operator decimal (UInt128 value);
+        public static explicit operator double (UInt128 value);
+        public static explicit operator Half (UInt128 value);
+        public static explicit operator Int128 (UInt128 value);
+        public static explicit operator short (UInt128 value);
+        public static explicit operator int (UInt128 value);
+        public static explicit operator long (UInt128 value);
+        public static explicit operator nint (UInt128 value);
+        public static explicit operator sbyte (UInt128 value);
+        public static explicit operator float (UInt128 value);
+        public static explicit operator ushort (UInt128 value);
+        public static explicit operator uint (UInt128 value);
+        public static explicit operator ulong (UInt128 value);
+        public static explicit operator nuint (UInt128 value);
+        public static bool operator >(UInt128 left, UInt128 right);
+        public static bool operator >=(UInt128 left, UInt128 right);
+        public static implicit operator UInt128 (byte value);
+        public static implicit operator UInt128 (char value);
+        public static implicit operator UInt128 (ushort value);
+        public static implicit operator UInt128 (uint value);
+        public static implicit operator UInt128 (ulong value);
+        public static implicit operator UInt128 (nuint value);
+        public static UInt128 operator ++(UInt128 value);
+        public static bool operator !=(UInt128 left, UInt128 right);
+        public static UInt128 operator <<(UInt128 value, int shiftAmount);
+        public static bool operator <(UInt128 left, UInt128 right);
+        public static bool operator <=(UInt128 left, UInt128 right);
+        public static UInt128 operator %(UInt128 left, UInt128 right);
+        public static UInt128 operator *(UInt128 left, UInt128 right);
+        public static UInt128 operator ~(UInt128 value);
+        public static UInt128 operator >>(UInt128 value, int shiftAmount);
+        public static UInt128 operator -(UInt128 left, UInt128 right);
+        public static UInt128 operator -(UInt128 value);
+        public static UInt128 operator +(UInt128 value);
+        public static UInt128 operator >>>(UInt128 value, int shiftAmount);
+        public static UInt128 Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.Integer, IFormatProvider? provider = null);
+        public static UInt128 Parse(ReadOnlySpan<char> s, IFormatProvider? provider);
+        public static UInt128 Parse(string s);
+        public static UInt128 Parse(string s, NumberStyles style);
+        public static UInt128 Parse(string s, NumberStyles style, IFormatProvider? provider);
+        public static UInt128 Parse(string s, IFormatProvider? provider);
+        public static UInt128 PopCount(UInt128 value);
+        public static UInt128 RotateLeft(UInt128 value, int rotateAmount);
+        public static UInt128 RotateRight(UInt128 value, int rotateAmount);
+        public static int Sign(UInt128 value);
+        int IBinaryInteger<UInt128>.GetByteCount();
+        int IBinaryInteger<UInt128>.GetShortestBitLength();
+        bool IBinaryInteger<UInt128>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
+        bool IBinaryInteger<UInt128>.TryWriteLittleEndian(Span<byte> destination, out int bytesWritten);
+        static UInt128 INumber<UInt128>.CopySign(UInt128 value, UInt128 sign);
+        static UInt128 INumber<UInt128>.MaxNumber(UInt128 x, UInt128 y);
+        static UInt128 INumber<UInt128>.MinNumber(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.Abs(UInt128 value);
+        static bool INumberBase<UInt128>.IsCanonical(UInt128 value);
+        static bool INumberBase<UInt128>.IsComplexNumber(UInt128 value);
+        static bool INumberBase<UInt128>.IsFinite(UInt128 value);
+        static bool INumberBase<UInt128>.IsImaginaryNumber(UInt128 value);
+        static bool INumberBase<UInt128>.IsInfinity(UInt128 value);
+        static bool INumberBase<UInt128>.IsInteger(UInt128 value);
+        static bool INumberBase<UInt128>.IsNaN(UInt128 value);
+        static bool INumberBase<UInt128>.IsNegative(UInt128 value);
+        static bool INumberBase<UInt128>.IsNegativeInfinity(UInt128 value);
+        static bool INumberBase<UInt128>.IsNormal(UInt128 value);
+        static bool INumberBase<UInt128>.IsPositive(UInt128 value);
+        static bool INumberBase<UInt128>.IsPositiveInfinity(UInt128 value);
+        static bool INumberBase<UInt128>.IsRealNumber(UInt128 value);
+        static bool INumberBase<UInt128>.IsSubnormal(UInt128 value);
+        static bool INumberBase<UInt128>.IsZero(UInt128 value);
+        static UInt128 INumberBase<UInt128>.MaxMagnitude(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.MaxMagnitudeNumber(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.MinMagnitude(UInt128 x, UInt128 y);
+        static UInt128 INumberBase<UInt128>.MinMagnitudeNumber(UInt128 x, UInt128 y);
+        static bool INumberBase<UInt128>.TryConvertFromChecked<TOther>(TOther value, out UInt128 result);
+        static bool INumberBase<UInt128>.TryConvertFromSaturating<TOther>(TOther value, out UInt128 result);
+        static bool INumberBase<UInt128>.TryConvertFromTruncating<TOther>(TOther value, out UInt128 result);
+        static bool INumberBase<UInt128>.TryConvertToChecked<TOther>(UInt128 value, out TOther result);
+        static bool INumberBase<UInt128>.TryConvertToSaturating<TOther>(UInt128 value, out TOther result);
+        static bool INumberBase<UInt128>.TryConvertToTruncating<TOther>(UInt128 value, out TOther result);
+        public override string ToString();
+        public string ToString(IFormatProvider? provider);
+        public string ToString(string? format);
+        public string ToString(string? format, IFormatProvider? provider);
+        public static UInt128 TrailingZeroCount(UInt128 value);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse(ReadOnlySpan<char> s, out UInt128 result);
+        public static bool TryParse(string? s, NumberStyles style, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse(string? s, IFormatProvider? provider, out UInt128 result);
+        public static bool TryParse(string? s, out UInt128 result);
+    }
     public readonly struct UInt16 : IAdditionOperators<ushort, ushort, ushort>, IAdditiveIdentity<ushort, ushort>, IBinaryInteger<ushort>, IBinaryNumber<ushort>, IBitwiseOperators<ushort, ushort, ushort>, IComparable, IComparable<ushort>, IComparisonOperators<ushort, ushort>, IConvertible, IDecrementOperators<ushort>, IDivisionOperators<ushort, ushort, ushort>, IEqualityOperators<ushort, ushort>, IEquatable<ushort>, IFormattable, IIncrementOperators<ushort>, IMinMaxValue<ushort>, IModulusOperators<ushort, ushort, ushort>, IMultiplicativeIdentity<ushort, ushort>, IMultiplyOperators<ushort, ushort, ushort>, INumber<ushort>, INumberBase<ushort>, IParsable<ushort>, IShiftOperators<ushort, ushort>, ISpanFormattable, ISpanParsable<ushort>, ISubtractionOperators<ushort, ushort, ushort>, IUnaryNegationOperators<ushort, ushort>, IUnaryPlusOperators<ushort, ushort>, IUnsignedNumber<ushort> {
+        static int System.Numerics.INumberBase<System.UInt16>.Radix { get; }
-        public static ushort CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static ushort CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static ushort CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(ushort value);
+        public static bool IsOddInteger(ushort value);
-        long IBinaryInteger<ushort>.GetShortestBitLength();
+        int IBinaryInteger<ushort>.GetShortestBitLength();
+        bool IBinaryInteger<ushort>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
-        static ushort INumber<ushort>.Abs(ushort value);
-        static bool INumber<ushort>.IsNegative(ushort value);
-        static ushort INumber<ushort>.MaxMagnitude(ushort x, ushort y);
+        static ushort INumber<ushort>.MaxNumber(ushort x, ushort y);
-        static ushort INumber<ushort>.MinMagnitude(ushort x, ushort y);
+        static ushort INumber<ushort>.MinNumber(ushort x, ushort y);
+        static ushort INumberBase<ushort>.Abs(ushort value);
+        static bool INumberBase<ushort>.IsCanonical(ushort value);
+        static bool INumberBase<ushort>.IsComplexNumber(ushort value);
+        static bool INumberBase<ushort>.IsFinite(ushort value);
+        static bool INumberBase<ushort>.IsImaginaryNumber(ushort value);
+        static bool INumberBase<ushort>.IsInfinity(ushort value);
+        static bool INumberBase<ushort>.IsInteger(ushort value);
+        static bool INumberBase<ushort>.IsNaN(ushort value);
+        static bool INumberBase<ushort>.IsNegative(ushort value);
+        static bool INumberBase<ushort>.IsNegativeInfinity(ushort value);
+        static bool INumberBase<ushort>.IsNormal(ushort value);
+        static bool INumberBase<ushort>.IsPositive(ushort value);
+        static bool INumberBase<ushort>.IsPositiveInfinity(ushort value);
+        static bool INumberBase<ushort>.IsRealNumber(ushort value);
+        static bool INumberBase<ushort>.IsSubnormal(ushort value);
+        static bool INumberBase<ushort>.IsZero(ushort value);
+        static ushort INumberBase<ushort>.MaxMagnitude(ushort x, ushort y);
+        static ushort INumberBase<ushort>.MaxMagnitudeNumber(ushort x, ushort y);
+        static ushort INumberBase<ushort>.MinMagnitude(ushort x, ushort y);
+        static ushort INumberBase<ushort>.MinMagnitudeNumber(ushort x, ushort y);
+        static bool INumberBase<ushort>.TryConvertFromChecked<TOther>(TOther value, out ushort result);
+        static bool INumberBase<ushort>.TryConvertFromSaturating<TOther>(TOther value, out ushort result);
+        static bool INumberBase<ushort>.TryConvertFromTruncating<TOther>(TOther value, out ushort result);
+        static bool INumberBase<ushort>.TryConvertToChecked<TOther>(ushort value, out TOther result);
+        static bool INumberBase<ushort>.TryConvertToSaturating<TOther>(ushort value, out TOther result);
+        static bool INumberBase<ushort>.TryConvertToTruncating<TOther>(ushort value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out ushort result) where TOther : INumber<TOther>;
     }
     public readonly struct UInt32 : IAdditionOperators<uint, uint, uint>, IAdditiveIdentity<uint, uint>, IBinaryInteger<uint>, IBinaryNumber<uint>, IBitwiseOperators<uint, uint, uint>, IComparable, IComparable<uint>, IComparisonOperators<uint, uint>, IConvertible, IDecrementOperators<uint>, IDivisionOperators<uint, uint, uint>, IEqualityOperators<uint, uint>, IEquatable<uint>, IFormattable, IIncrementOperators<uint>, IMinMaxValue<uint>, IModulusOperators<uint, uint, uint>, IMultiplicativeIdentity<uint, uint>, IMultiplyOperators<uint, uint, uint>, INumber<uint>, INumberBase<uint>, IParsable<uint>, IShiftOperators<uint, uint>, ISpanFormattable, ISpanParsable<uint>, ISubtractionOperators<uint, uint, uint>, IUnaryNegationOperators<uint, uint>, IUnaryPlusOperators<uint, uint>, IUnsignedNumber<uint> {
+        static int System.Numerics.INumberBase<System.UInt32>.Radix { get; }
-        public static uint CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static uint CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static uint CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(uint value);
+        public static bool IsOddInteger(uint value);
-        long IBinaryInteger<uint>.GetShortestBitLength();
+        int IBinaryInteger<uint>.GetShortestBitLength();
+        bool IBinaryInteger<uint>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
-        static uint INumber<uint>.Abs(uint value);
-        static bool INumber<uint>.IsNegative(uint value);
-        static uint INumber<uint>.MaxMagnitude(uint x, uint y);
+        static uint INumber<uint>.MaxNumber(uint x, uint y);
-        static uint INumber<uint>.MinMagnitude(uint x, uint y);
+        static uint INumber<uint>.MinNumber(uint x, uint y);
+        static uint INumberBase<uint>.Abs(uint value);
+        static bool INumberBase<uint>.IsCanonical(uint value);
+        static bool INumberBase<uint>.IsComplexNumber(uint value);
+        static bool INumberBase<uint>.IsFinite(uint value);
+        static bool INumberBase<uint>.IsImaginaryNumber(uint value);
+        static bool INumberBase<uint>.IsInfinity(uint value);
+        static bool INumberBase<uint>.IsInteger(uint value);
+        static bool INumberBase<uint>.IsNaN(uint value);
+        static bool INumberBase<uint>.IsNegative(uint value);
+        static bool INumberBase<uint>.IsNegativeInfinity(uint value);
+        static bool INumberBase<uint>.IsNormal(uint value);
+        static bool INumberBase<uint>.IsPositive(uint value);
+        static bool INumberBase<uint>.IsPositiveInfinity(uint value);
+        static bool INumberBase<uint>.IsRealNumber(uint value);
+        static bool INumberBase<uint>.IsSubnormal(uint value);
+        static bool INumberBase<uint>.IsZero(uint value);
+        static uint INumberBase<uint>.MaxMagnitude(uint x, uint y);
+        static uint INumberBase<uint>.MaxMagnitudeNumber(uint x, uint y);
+        static uint INumberBase<uint>.MinMagnitude(uint x, uint y);
+        static uint INumberBase<uint>.MinMagnitudeNumber(uint x, uint y);
+        static bool INumberBase<uint>.TryConvertFromChecked<TOther>(TOther value, out uint result);
+        static bool INumberBase<uint>.TryConvertFromSaturating<TOther>(TOther value, out uint result);
+        static bool INumberBase<uint>.TryConvertFromTruncating<TOther>(TOther value, out uint result);
+        static bool INumberBase<uint>.TryConvertToChecked<TOther>(uint value, out TOther result);
+        static bool INumberBase<uint>.TryConvertToSaturating<TOther>(uint value, out TOther result);
+        static bool INumberBase<uint>.TryConvertToTruncating<TOther>(uint value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out uint result) where TOther : INumber<TOther>;
     }
     public readonly struct UInt64 : IAdditionOperators<ulong, ulong, ulong>, IAdditiveIdentity<ulong, ulong>, IBinaryInteger<ulong>, IBinaryNumber<ulong>, IBitwiseOperators<ulong, ulong, ulong>, IComparable, IComparable<ulong>, IComparisonOperators<ulong, ulong>, IConvertible, IDecrementOperators<ulong>, IDivisionOperators<ulong, ulong, ulong>, IEqualityOperators<ulong, ulong>, IEquatable<ulong>, IFormattable, IIncrementOperators<ulong>, IMinMaxValue<ulong>, IModulusOperators<ulong, ulong, ulong>, IMultiplicativeIdentity<ulong, ulong>, IMultiplyOperators<ulong, ulong, ulong>, INumber<ulong>, INumberBase<ulong>, IParsable<ulong>, IShiftOperators<ulong, ulong>, ISpanFormattable, ISpanParsable<ulong>, ISubtractionOperators<ulong, ulong, ulong>, IUnaryNegationOperators<ulong, ulong>, IUnaryPlusOperators<ulong, ulong>, IUnsignedNumber<ulong> {
+        static int System.Numerics.INumberBase<System.UInt64>.Radix { get; }
-        public static ulong CreateChecked<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static ulong CreateSaturating<TOther>(TOther value) where TOther : INumber<TOther>;
-        public static ulong CreateTruncating<TOther>(TOther value) where TOther : INumber<TOther>;
+        public static bool IsEvenInteger(ulong value);
+        public static bool IsOddInteger(ulong value);
-        long IBinaryInteger<ulong>.GetShortestBitLength();
+        int IBinaryInteger<ulong>.GetShortestBitLength();
+        bool IBinaryInteger<ulong>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
-        static ulong INumber<ulong>.Abs(ulong value);
-        static bool INumber<ulong>.IsNegative(ulong value);
-        static ulong INumber<ulong>.MaxMagnitude(ulong x, ulong y);
+        static ulong INumber<ulong>.MaxNumber(ulong x, ulong y);
-        static ulong INumber<ulong>.MinMagnitude(ulong x, ulong y);
+        static ulong INumber<ulong>.MinNumber(ulong x, ulong y);
+        static ulong INumberBase<ulong>.Abs(ulong value);
+        static bool INumberBase<ulong>.IsCanonical(ulong value);
+        static bool INumberBase<ulong>.IsComplexNumber(ulong value);
+        static bool INumberBase<ulong>.IsFinite(ulong value);
+        static bool INumberBase<ulong>.IsImaginaryNumber(ulong value);
+        static bool INumberBase<ulong>.IsInfinity(ulong value);
+        static bool INumberBase<ulong>.IsInteger(ulong value);
+        static bool INumberBase<ulong>.IsNaN(ulong value);
+        static bool INumberBase<ulong>.IsNegative(ulong value);
+        static bool INumberBase<ulong>.IsNegativeInfinity(ulong value);
+        static bool INumberBase<ulong>.IsNormal(ulong value);
+        static bool INumberBase<ulong>.IsPositive(ulong value);
+        static bool INumberBase<ulong>.IsPositiveInfinity(ulong value);
+        static bool INumberBase<ulong>.IsRealNumber(ulong value);
+        static bool INumberBase<ulong>.IsSubnormal(ulong value);
+        static bool INumberBase<ulong>.IsZero(ulong value);
+        static ulong INumberBase<ulong>.MaxMagnitude(ulong x, ulong y);
+        static ulong INumberBase<ulong>.MaxMagnitudeNumber(ulong x, ulong y);
+        static ulong INumberBase<ulong>.MinMagnitude(ulong x, ulong y);
+        static ulong INumberBase<ulong>.MinMagnitudeNumber(ulong x, ulong y);
+        static bool INumberBase<ulong>.TryConvertFromChecked<TOther>(TOther value, out ulong result);
+        static bool INumberBase<ulong>.TryConvertFromSaturating<TOther>(TOther value, out ulong result);
+        static bool INumberBase<ulong>.TryConvertFromTruncating<TOther>(TOther value, out ulong result);
+        static bool INumberBase<ulong>.TryConvertToChecked<TOther>(ulong value, out TOther result);
+        static bool INumberBase<ulong>.TryConvertToSaturating<TOther>(ulong value, out TOther result);
+        static bool INumberBase<ulong>.TryConvertToTruncating<TOther>(ulong value, out TOther result);
-        public static bool TryCreate<TOther>(TOther value, out ulong result) where TOther : INumber<TOther>;
     }
     public readonly struct UIntPtr : IAdditionOperators<UIntPtr, UIntPtr, UIntPtr>, IAdditiveIdentity<UIntPtr, UIntPtr>, IBinaryInteger<UIntPtr>, IBinaryNumber<UIntPtr>, IBitwiseOperators<UIntPtr, UIntPtr, UIntPtr>, IComparable, IComparable<UIntPtr>, IComparisonOperators<UIntPtr, UIntPtr>, IDecrementOperators<UIntPtr>, IDivisionOperators<UIntPtr, UIntPtr, UIntPtr>, IEqualityOperators<UIntPtr, UIntPtr>, IEquatable<UIntPtr>, IFormattable, IIncrementOperators<UIntPtr>, IMinMaxValue<UIntPtr>, IModulusOperators<UIntPtr, UIntPtr, UIntPtr>, IMultiplicativeIdentity<UIntPtr, UIntPtr>, IMultiplyOperators<UIntPtr, UIntPtr, UIntPtr>, INumber<UIntPtr>, INumberBase<UIntPtr>, IParsable<UIntPtr>, ISerializable, IShiftOperators<UIntPtr, UIntPtr>, ISpanFormattable, ISpanParsable<UIntPtr>, ISubtractionOperators<UIntPtr, UIntPtr, UIntPtr>, IUnaryNegationOperators<UIntPtr, UIntPtr>, IUnaryPlusOperators<UIntPtr, UIntPtr>, IUnsignedNumber<UIntPtr> {
+        static int System.Numerics.INumberBase<nuint>.Radix { get; }
+        public static UIntPtr Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
+        public static (UIntPtr Quotient, UIntPtr Remainder) DivRem(UIntPtr left, UIntPtr right);
+        public static bool IsEvenInteger(UIntPtr value);
+        public static bool IsOddInteger(UIntPtr value);
+        public static bool IsPow2(UIntPtr value);
+        public static UIntPtr LeadingZeroCount(UIntPtr value);
+        public static UIntPtr Log2(UIntPtr value);
+        public static UIntPtr Max(UIntPtr x, UIntPtr y);
+        public static UIntPtr Min(UIntPtr x, UIntPtr y);
+        public static UIntPtr PopCount(UIntPtr value);
+        public static UIntPtr RotateLeft(UIntPtr value, int rotateAmount);
+        public static UIntPtr RotateRight(UIntPtr value, int rotateAmount);
+        public static int Sign(UIntPtr value);
-        static (UIntPtr Quotient, UIntPtr Remainder) IBinaryInteger<UIntPtr>.DivRem(UIntPtr left, UIntPtr right);
-        long IBinaryInteger<UIntPtr>.GetShortestBitLength();
+        int IBinaryInteger<UIntPtr>.GetShortestBitLength();
-        static UIntPtr IBinaryInteger<UIntPtr>.LeadingZeroCount(UIntPtr value);
-        static UIntPtr IBinaryInteger<UIntPtr>.PopCount(UIntPtr value);
-        static UIntPtr IBinaryInteger<UIntPtr>.RotateLeft(UIntPtr value, int rotateAmount);
-        static UIntPtr IBinaryInteger<UIntPtr>.RotateRight(UIntPtr value, int rotateAmount);
-        static UIntPtr IBinaryInteger<UIntPtr>.TrailingZeroCount(UIntPtr value);
+        bool IBinaryInteger<UIntPtr>.TryWriteBigEndian(Span<byte> destination, out int bytesWritten);
-        static bool IBinaryNumber<UIntPtr>.IsPow2(UIntPtr value);
-        static UIntPtr IBinaryNumber<UIntPtr>.Log2(UIntPtr value);
-        static UIntPtr INumber<UIntPtr>.Abs(UIntPtr value);
-        static UIntPtr INumber<UIntPtr>.Clamp(UIntPtr value, UIntPtr min, UIntPtr max);
-        static UIntPtr INumber<UIntPtr>.CreateChecked<TOther>(TOther value);
-        static UIntPtr INumber<UIntPtr>.CreateSaturating<TOther>(TOther value);
-        static UIntPtr INumber<UIntPtr>.CreateTruncating<TOther>(TOther value);
-        static bool INumber<UIntPtr>.IsNegative(UIntPtr value);
-        static UIntPtr INumber<UIntPtr>.Max(UIntPtr x, UIntPtr y);
-        static UIntPtr INumber<UIntPtr>.MaxMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumber<UIntPtr>.MaxNumber(UIntPtr x, UIntPtr y);
-        static UIntPtr INumber<UIntPtr>.Min(UIntPtr x, UIntPtr y);
-        static UIntPtr INumber<UIntPtr>.MinMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumber<UIntPtr>.MinNumber(UIntPtr x, UIntPtr y);
-        static int INumber<UIntPtr>.Sign(UIntPtr value);
-        static bool INumber<UIntPtr>.TryCreate<TOther>(TOther value, out UIntPtr result);
+        static UIntPtr INumberBase<UIntPtr>.Abs(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsCanonical(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsComplexNumber(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsFinite(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsImaginaryNumber(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsInfinity(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsInteger(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNaN(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNegative(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNegativeInfinity(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsNormal(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsPositive(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsPositiveInfinity(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsRealNumber(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsSubnormal(UIntPtr value);
+        static bool INumberBase<UIntPtr>.IsZero(UIntPtr value);
+        static UIntPtr INumberBase<UIntPtr>.MaxMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.MaxMagnitudeNumber(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.MinMagnitude(UIntPtr x, UIntPtr y);
+        static UIntPtr INumberBase<UIntPtr>.MinMagnitudeNumber(UIntPtr x, UIntPtr y);
+        static bool INumberBase<UIntPtr>.TryConvertFromChecked<TOther>(TOther value, out UIntPtr result);
+        static bool INumberBase<UIntPtr>.TryConvertFromSaturating<TOther>(TOther value, out UIntPtr result);
+        static bool INumberBase<UIntPtr>.TryConvertFromTruncating<TOther>(TOther value, out UIntPtr result);
+        static bool INumberBase<UIntPtr>.TryConvertToChecked<TOther>(UIntPtr value, out TOther result);
+        static bool INumberBase<UIntPtr>.TryConvertToSaturating<TOther>(UIntPtr value, out TOther result);
+        static bool INumberBase<UIntPtr>.TryConvertToTruncating<TOther>(UIntPtr value, out TOther result);
+        public static UIntPtr TrailingZeroCount(UIntPtr value);
     }
 }
```

