# System.IO

``` diff
 namespace System.IO {
     public static class Directory {
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static DirectoryInfo CreateDirectory(string path, UnixFileMode unixCreateMode);
     }
     public static class File {
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static UnixFileMode GetUnixFileMode(SafeFileHandle fileHandle);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static UnixFileMode GetUnixFileMode(string path);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static void SetUnixFileMode(SafeFileHandle fileHandle, UnixFileMode mode);
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static void SetUnixFileMode(string path, UnixFileMode mode);
     }
     public sealed class FileStreamOptions {
+        public UnixFileMode? UnixCreateMode { get; [UnsupportedOSPlatformAttribute("windows")] set; }
     }
     public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
+        public UnixFileMode UnixFileMode { get; [UnsupportedOSPlatformAttribute("windows")] set; }
     }
+    [FlagsAttribute]
+    public enum UnixFileMode {
+        GroupExecute = 8,
+        GroupRead = 32,
+        GroupWrite = 16,
+        None = 0,
+        OtherExecute = 1,
+        OtherRead = 4,
+        OtherWrite = 2,
+        SetGroup = 1024,
+        SetUser = 2048,
+        StickyBit = 512,
+        UserExecute = 64,
+        UserRead = 256,
+        UserWrite = 128,
+    }
 }
```

