# System.Numerics

``` diff
 namespace System.Numerics {
     public readonly struct BigInteger : IAdditionOperators<BigInteger, BigInteger, BigInteger>, IAdditiveIdentity<BigInteger, BigInteger>, IBinaryInteger<BigInteger>, IBinaryNumber<BigInteger>, IBitwiseOperators<BigInteger, BigInteger, BigInteger>, IComparable, IComparable<BigInteger>, IComparisonOperators<BigInteger, BigInteger>, IDecrementOperators<BigInteger>, IDivisionOperators<BigInteger, BigInteger, BigInteger>, IEqualityOperators<BigInteger, BigInteger>, IEquatable<BigInteger>, IFormattable, IIncrementOperators<BigInteger>, IModulusOperators<BigInteger, BigInteger, BigInteger>, IMultiplicativeIdentity<BigInteger, BigInteger>, IMultiplyOperators<BigInteger, BigInteger, BigInteger>, INumber<BigInteger>, INumberBase<BigInteger>, IParsable<BigInteger>, IShiftOperators<BigInteger, BigInteger>, ISignedNumber<BigInteger>, ISpanFormattable, ISpanParsable<BigInteger>, ISubtractionOperators<BigInteger, BigInteger, BigInteger>, IUnaryNegationOperators<BigInteger, BigInteger>, IUnaryPlusOperators<BigInteger, BigInteger> {
-        static BigInteger IAdditionOperators<BigInteger, BigInteger, BigInteger>.operator checked +(BigInteger left, BigInteger right);
-        static BigInteger IDecrementOperators<BigInteger>.operator checked --(BigInteger value);
-        static BigInteger IDivisionOperators<BigInteger, BigInteger, BigInteger>.operator checked /(BigInteger left, BigInteger right);
-        static BigInteger IIncrementOperators<BigInteger>.operator checked ++(BigInteger value);
-        static BigInteger IMultiplyOperators<BigInteger, BigInteger, BigInteger>.operator checked *(BigInteger left, BigInteger right);
-        static BigInteger ISubtractionOperators<BigInteger, BigInteger, BigInteger>.operator checked -(BigInteger left, BigInteger right);
-        static BigInteger IUnaryNegationOperators<BigInteger, BigInteger>.operator checked -(BigInteger value);
     }
     public readonly struct Complex : IAdditionOperators<Complex, Complex, Complex>, IAdditiveIdentity<Complex, Complex>, IDecrementOperators<Complex>, IDivisionOperators<Complex, Complex, Complex>, IEqualityOperators<Complex, Complex>, IEquatable<Complex>, IFormattable, IIncrementOperators<Complex>, IMultiplicativeIdentity<Complex, Complex>, IMultiplyOperators<Complex, Complex, Complex>, INumberBase<Complex>, IParsable<Complex>, ISignedNumber<Complex>, ISpanFormattable, ISpanParsable<Complex>, ISubtractionOperators<Complex, Complex, Complex>, IUnaryNegationOperators<Complex, Complex>, IUnaryPlusOperators<Complex, Complex> {
-        static Complex IAdditionOperators<Complex, Complex, Complex>.operator checked +(Complex left, Complex right);
-        static Complex IDecrementOperators<Complex>.operator checked --(Complex value);
-        static Complex IDivisionOperators<Complex, Complex, Complex>.operator checked /(Complex left, Complex right);
-        static Complex IIncrementOperators<Complex>.operator checked ++(Complex value);
-        static Complex IMultiplyOperators<Complex, Complex, Complex>.operator checked *(Complex left, Complex right);
-        static Complex ISubtractionOperators<Complex, Complex, Complex>.operator checked -(Complex left, Complex right);
-        static Complex IUnaryNegationOperators<Complex, Complex>.operator checked -(Complex value);
     }
     public interface IAdditionOperators<TSelf, TOther, TResult> where TSelf : IAdditionOperators<TSelf, TOther, TResult> {
-        static abstract TResult operator checked +(TSelf left, TOther right);
+        static TResult operator checked +(TSelf left, TOther right);
     }
     public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IShiftOperators<TSelf, TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf> {
-        static abstract (TSelf Quotient, TSelf Remainder) DivRem(TSelf left, TSelf right);
+        static (TSelf Quotient, TSelf Remainder) DivRem(TSelf left, TSelf right);
-        static abstract TSelf LeadingZeroCount(TSelf value);
+        static TSelf LeadingZeroCount(TSelf value);
-        static abstract TSelf RotateLeft(TSelf value, int rotateAmount);
+        static TSelf RotateLeft(TSelf value, int rotateAmount);
-        static abstract TSelf RotateRight(TSelf value, int rotateAmount);
+        static TSelf RotateRight(TSelf value, int rotateAmount);
     }
     public interface IDecrementOperators<TSelf> where TSelf : IDecrementOperators<TSelf> {
-        static abstract TSelf operator checked --(TSelf value);
+        static TSelf operator checked --(TSelf value);
     }
     public interface IDivisionOperators<TSelf, TOther, TResult> where TSelf : IDivisionOperators<TSelf, TOther, TResult> {
-        static abstract TResult operator checked /(TSelf left, TOther right);
+        static TResult operator checked /(TSelf left, TOther right);
     }
-    public interface IExponentialFunctions<TSelf> where TSelf : IExponentialFunctions<TSelf> {
+    public interface IExponentialFunctions<TSelf> where TSelf : IExponentialFunctions<TSelf>, INumberBase<TSelf> {
-        static abstract TSelf Exp10M1(TSelf x);
+        static TSelf Exp10M1(TSelf x);
-        static abstract TSelf Exp2M1(TSelf x);
+        static TSelf Exp2M1(TSelf x);
-        static abstract TSelf ExpM1(TSelf x);
+        static TSelf ExpM1(TSelf x);
     }
     public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf> {
-        static abstract TSelf Ceiling(TSelf x);
+        static TSelf Ceiling(TSelf x);
-        static abstract TSelf Floor(TSelf x);
+        static TSelf Floor(TSelf x);
-        static abstract TSelf Round(TSelf x);
+        static TSelf Round(TSelf x);
-        static abstract TSelf Round(TSelf x, int digits);
+        static TSelf Round(TSelf x, int digits);
-        static abstract TSelf Round(TSelf x, MidpointRounding mode);
+        static TSelf Round(TSelf x, MidpointRounding mode);
-        static abstract TSelf Truncate(TSelf x);
+        static TSelf Truncate(TSelf x);
     }
     public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointIeee754<TSelf> {
-        static abstract TSelf ReciprocalEstimate(TSelf x);
+        static TSelf ReciprocalEstimate(TSelf x);
-        static abstract TSelf ReciprocalSqrtEstimate(TSelf x);
+        static TSelf ReciprocalSqrtEstimate(TSelf x);
     }
-    public interface IHyperbolicFunctions<TSelf> where TSelf : IHyperbolicFunctions<TSelf>
+    public interface IHyperbolicFunctions<TSelf> where TSelf : IHyperbolicFunctions<TSelf>, INumberBase<TSelf>
     public interface IIncrementOperators<TSelf> where TSelf : IIncrementOperators<TSelf> {
-        static abstract TSelf operator checked ++(TSelf value);
+        static TSelf operator checked ++(TSelf value);
     }
-    public interface ILogarithmicFunctions<TSelf> where TSelf : ILogarithmicFunctions<TSelf> {
+    public interface ILogarithmicFunctions<TSelf> where TSelf : ILogarithmicFunctions<TSelf>, INumberBase<TSelf> {
-        static abstract TSelf Log10P1(TSelf x);
+        static TSelf Log10P1(TSelf x);
-        static abstract TSelf Log2P1(TSelf x);
+        static TSelf Log2P1(TSelf x);
-        static abstract TSelf LogP1(TSelf x);
+        static TSelf LogP1(TSelf x);
     }
     public interface IMultiplyOperators<TSelf, TOther, TResult> where TSelf : IMultiplyOperators<TSelf, TOther, TResult> {
-        static abstract TResult operator checked *(TSelf left, TOther right);
+        static TResult operator checked *(TSelf left, TOther right);
     }
     public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf> {
-        static abstract TSelf Clamp(TSelf value, TSelf min, TSelf max);
+        static TSelf Clamp(TSelf value, TSelf min, TSelf max);
-        static abstract TSelf CopySign(TSelf value, TSelf sign);
+        static TSelf CopySign(TSelf value, TSelf sign);
-        static abstract TSelf Max(TSelf x, TSelf y);
+        static TSelf Max(TSelf x, TSelf y);
-        static abstract TSelf MaxNumber(TSelf x, TSelf y);
+        static TSelf MaxNumber(TSelf x, TSelf y);
-        static abstract TSelf Min(TSelf x, TSelf y);
+        static TSelf Min(TSelf x, TSelf y);
-        static abstract TSelf MinNumber(TSelf x, TSelf y);
+        static TSelf MinNumber(TSelf x, TSelf y);
-        static abstract int Sign(TSelf value);
+        static int Sign(TSelf value);
     }
-    public interface IPowerFunctions<TSelf> where TSelf : IPowerFunctions<TSelf>
+    public interface IPowerFunctions<TSelf> where TSelf : IPowerFunctions<TSelf>, INumberBase<TSelf>
-    public interface IRootFunctions<TSelf> where TSelf : IRootFunctions<TSelf> {
+    public interface IRootFunctions<TSelf> where TSelf : IRootFunctions<TSelf>, INumberBase<TSelf> {
+        static abstract TSelf Hypot(TSelf x, TSelf y);
+        static abstract TSelf Root(TSelf x, int n);
     }
     public interface ISubtractionOperators<TSelf, TOther, TResult> where TSelf : ISubtractionOperators<TSelf, TOther, TResult> {
-        static abstract TResult operator checked -(TSelf left, TOther right);
+        static TResult operator checked -(TSelf left, TOther right);
     }
-    public interface ITrigonometricFunctions<TSelf> where TSelf : ITrigonometricFunctions<TSelf> {
+    public interface ITrigonometricFunctions<TSelf> where TSelf : ITrigonometricFunctions<TSelf>, INumberBase<TSelf> {
+        static abstract TSelf AcosPi(TSelf x);
+        static abstract TSelf AsinPi(TSelf x);
+        static abstract TSelf Atan2Pi(TSelf y, TSelf x);
+        static abstract TSelf AtanPi(TSelf x);
+        static abstract TSelf CosPi(TSelf x);
+        static abstract TSelf SinPi(TSelf x);
+        static abstract TSelf TanPi(TSelf x);
     }
     public interface IUnaryNegationOperators<TSelf, TResult> where TSelf : IUnaryNegationOperators<TSelf, TResult> {
-        static abstract TResult operator checked -(TSelf value);
+        static TResult operator checked -(TSelf value);
     }
 }
```

