# .NET Core 2.0.0 Preview 2

.NET Core 2.0.0 Preview 2 comprises:

* .NET Core Runtime 2.0.0 Preview 2 build 25407-01
* .NET Core SDK 2.0.0 Preview 2 build 006497

|                         | SDK Installer                                        | SDK Binaries                                        | Runtime Installer | Runtime Binaries |
| ----------------------- | :----------------------------------------------: | :----------------------------------------------:| :--: | :--: |
| Windows                 | [32-bit](https://download.microsoft.com/download/6/1/B/61B3E81F-5509-48D2-BB4F-5189E23CD29A/dotnet-sdk-2.0.0-preview2-006497-win-x86.exe) / [64-bit](https://download.microsoft.com/download/6/1/B/61B3E81F-5509-48D2-BB4F-5189E23CD29A/dotnet-sdk-2.0.0-preview2-006497-win-x64.exe)  | [32-bit](https://download.microsoft.com/download/F/A/A/FAAE9280-F410-458E-8819-279C5A68EDCF/dotnet-sdk-2.0.0-preview2-006497-win-x86.zip) / [64-bit](https://download.microsoft.com/download/F/A/A/FAAE9280-F410-458E-8819-279C5A68EDCF/dotnet-sdk-2.0.0-preview2-006497-win-x64.zip) | [32-bit](https://download.microsoft.com/download/7/C/3/7C310A63-13AC-49A4-9666-4CB26388F852/dotnet-runtime-2.0.0-preview2-25407-01-win-x86.exe) / [64-bit](https://download.microsoft.com/download/7/C/3/7C310A63-13AC-49A4-9666-4CB26388F852/dotnet-runtime-2.0.0-preview2-25407-01-win-x64.exe) | [32-bit](https://download.microsoft.com/download/8/5/8/85896F6E-C7F5-4ECA-ADF7-CCE8EFAD9AA6/dotnet-runtime-2.0.0-preview2-25407-01-win-x86.zip) / [64-bit](https://download.microsoft.com/download/8/5/8/85896F6E-C7F5-4ECA-ADF7-CCE8EFAD9AA6/dotnet-runtime-2.0.0-preview2-25407-01-win-x64.zip) |
| macOS                   | [64-bit](https://download.microsoft.com/download/6/1/B/61B3E81F-5509-48D2-BB4F-5189E23CD29A/dotnet-sdk-2.0.0-preview2-006497-osx-x64.pkg)  | [64-bit](https://download.microsoft.com/download/F/A/A/FAAE9280-F410-458E-8819-279C5A68EDCF/dotnet-sdk-2.0.0-preview2-006497-osx-x64.tar.gz)                          | [64-bit](https://download.microsoft.com/download/7/C/3/7C310A63-13AC-49A4-9666-4CB26388F852/dotnet-runtime-2.0.0-preview2-25407-01-osx-x64.pkg) | [64-bit](https://download.microsoft.com/download/8/5/8/85896F6E-C7F5-4ECA-ADF7-CCE8EFAD9AA6/dotnet-runtime-2.0.0-preview2-25407-01-osx-x64.tar.gz) |
| Linux *                 | -                                                         | [64-bit](https://download.microsoft.com/download/F/A/A/FAAE9280-F410-458E-8819-279C5A68EDCF/dotnet-sdk-2.0.0-preview2-006497-linux-x64.tar.gz)                          | - | [64-bit](https://download.microsoft.com/download/8/5/8/85896F6E-C7F5-4ECA-ADF7-CCE8EFAD9AA6/dotnet-runtime-2.0.0-preview2-25407-01-linux-x64.tar.gz) |
| Ubuntu           | See installations steps below | [64-bit](https://download.microsoft.com/download/F/A/A/FAAE9280-F410-458E-8819-279C5A68EDCF/dotnet-sdk-2.0.0-preview2-006497-linux-x64.tar.gz)                          | See installation steps below | [64-bit](https://download.microsoft.com/download/8/5/8/85896F6E-C7F5-4ECA-ADF7-CCE8EFAD9AA6/dotnet-runtime-2.0.0-preview2-25407-01-linux-x64.tar.gz) |

**Note:** The 'Linux' binary archives are new for the 2.0 release. This package contains binaries which are compatible with [Linux distros and versions supported by .NET Core](https://github.com/dotnet/core/blob/main/roadmap.md).

**Checksum** files to verify downloads are available as follows:
* [Checksums_Runtime](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.0-preview2-runtime-sha.txt)
* [Checksums_SDK](https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.0.0-preview2-sdk-sha.txt)

**Debug Symbols**
* [Shared Framework](https://download.microsoft.com/download/3/C/D/3CD49295-F203-4FD6-87BA-516371EB7B17/corefx-2.0-preview2-symbols.zip)
* [Runtime](https://download.microsoft.com/download/3/C/D/3CD49295-F203-4FD6-87BA-516371EB7B17/coreclr-2.0-preview2-symbols.zip)

## Docker

Images for .NET Core 2.0.0 Preview 2 are available on [Docker](https://hub.docker.com/r/microsoft/dotnet/).

## Installation from a binary archive

When using binary archives to install, we recommend the contents be extracted to `/opt/dotnet` and a symbolic link created for `dotnet`. If an earlier release of .NET Core is already installed, the directory and symbolic link may already exist. Ubuntu and Mint users should follow the instructions in the Ubuntu Installation section below.

```bash
sudo mkdir -p /opt/dotnet
sudo tar zxf [tar.gz filename] -C /opt/dotnet
sudo ln -s /opt/dotnet/dotnet /usr/local/bin
```

## Ubuntu installation

### Uninstall Preview 1

If you have .NET Core Preview 1 installed, it will need to be removed before attempting to install Preview 2. This can be done by running the following command. 

`sudo apt remove dotnet-dev-2.0.0-preview1-005977`

### Add the dotnet apt-get feed

The first step is to establish the source feed for the package manager. This is only needed if you have not previously set up the source or if you are installing for the first time.

#### Ubuntu 14.04 and Linux Mint 17

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ trusty main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
```

#### Ubuntu 16.04 and Linux Mint 18

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ xenial main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
```

#### Ubuntu 16.10

```bash
sudo sh -c 'echo "deb [arch=amd64] https://apt-mo.trafficmanager.net/repos/dotnet-release/ yakkety main" > /etc/apt/sources.list.d/dotnetdev.list'
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys 417A0893
```

### Install .NET Core 2.0 Preview 2

To install .NET Core 2.0 Preview on Ubuntu or Linux Mint, simply use apt-get.

```bash
sudo apt-get update
sudo apt-get install dotnet-sdk-2.0.0-preview2-006497
```

## Windows Server Hosting
If you are looking to host stand-alone apps on Windows Servers, the ASP.NET Core Module for IIS can be installed separately on servers without installing .NET Core runtime. You can download the Windows (Server Hosting) installer and run the following command from an Administrator command prompt:

[```DotNetCore.2.0.0-Preview2-WindowsHosting.exe```](https://download.microsoft.com/download/1/4/2/142388B4-2840-446C-8D10-7622EE88465D/DotNetCore.2.0.0-Preview2-WindowsHosting.exe)

### ASP.NET Core Package Store

The Runtime Package Store is installed by the .NET Core SDK and the Windows Server Hosting installer. If you need to install the Runtime Package Store separately, the following can be used.

* [AspNetCore.2.0.0-Preview2.RuntimePackageStore_x64.exe](https://download.microsoft.com/download/1/4/2/142388B4-2840-446C-8D10-7622EE88465D/AspNetCore.2.0.0-Preview2.RuntimePackageStore_x64.exe)
* [AspNetCore.2.0.0-Preview2.RuntimePackageStore_x86.exe](https://download.microsoft.com/download/1/4/2/142388B4-2840-446C-8D10-7622EE88465D/AspNetCore.2.0.0-Preview2.RuntimePackageStore_x86.exe)
