# 1.1 Known Issues

This document lists known issues for *.NET Core 1.1* and *.NET Core SDK 1.0.0 Preview 2.1 build 3177* which may be encountered during usage.

## Wrong SDK version used by dotnet

Part of resolving an issue called out in [Preview 1 Known Issues](1.1.0-preview1-known-issues.md) was to slightly modify the SDK directory naming scheme. The Preview 1 SDK directory was `1.0.0-preview2.1-003155` and this release it is `1.0.0-preview2-1-003177`. dotnet.exe has rules which determine the latest version of the tools to launch which will typically load the latest version so you don't have to worry about having several versions installed. Those rules are in part based on sort order which in this case results in loading from '2.1-003155' rather than '2-1-003177'.

The work around is to either remove the `sdk/1.0.0-preview2.1-003155` directory or rename it to `sdk/1.0.0-preview2-1-003155`.

## C++ Math libraries can behave differently across platforms

This is expected behavior. See discussion in [coreclr issue #4318](https://github.com/dotnet/coreclr/issues/4318)

## .NET Core SDK Preview 3

We're releasing an update to the .NET Core SDK which is available directly in Visual Studio 2017 RC. Please see the [CLI Known Issues](https://github.com/dotnet/core/blob/main/cli/known-issues.md) document for important information about this release.

Have a look at [Project Json To CSProj](https://github.com/dotnet/cli/blob/rel/1.0.0/Documentation/ProjectJsonToCSProj.md) for details on working with project.json and csproj-based projects.

## System.ExecutionEngineException in System.Security.Cryptography.X509Cerificates.dll on Windows

Workaround: Set environment variable `COMPlus_ReadyToRunExcludeList=System.Security.Cryptography.X509Certificates`

Fix expected in 1.1.1 release.

For details see [coreclr issue #8148](https://github.com/dotnet/coreclr/issues/8148) and its duplicates.
