# .NET Core 2.1.813

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.1.813
* .NET Core Runtime 2.1.25
* ASP.NET Core 2.1.25

See the [Release Notes](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.25/2.1.25.md) for details about what is included in this update.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-setup]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup>
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |


1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.521](2.1.25.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 2.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it won't conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [Linux Setup](https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The following commands don't specifically include package managers to help with readability. Here are the package managers typically used by the distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP.NET Core Runtime and .NET Core Runtime.

## Windows Server Hosting

If you're looking to host standalone apps on servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.25-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.25/2.1.25.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.25-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.25-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux


[//]: # ( Runtime 2.1.25)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8f4ad57-229c-4204-973e-d9adc71accea/8507cbdbae5d88aa78e5f477790c3032/dotnet-runtime-2.1.25-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7d4ebac-5634-494b-ad88-c102a4cc4bdd/6db19514d887a971a85f53425a6ad2fb/dotnet-runtime-2.1.25-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/917b68aa-0307-4250-894e-a36495872241/8ef5422486a813a0a3387e1feb30cfce/dotnet-runtime-2.1.25-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19203a52-0453-4c37-b964-05ab5ca0e67c/0db9cc5de1de804740734ddb39cedb0a/dotnet-runtime-2.1.25-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0e82b6c0-7791-4ebd-8e87-c09c9c5ec8a3/37b0ccc801d5bde7999982529d385e08/dotnet-runtime-2.1.25-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f3c6ad91-a67a-4020-bd22-516d8691c438/001740f092dff348c4e0b06acfd83eba/dotnet-runtime-2.1.25-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ce9bdda9-9bd3-4e80-9ca1-7cc2c4965636/05d725a7f74025cbf922f23c34c00478/dotnet-runtime-2.1.25-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0bb7128a-594b-4d6d-9e9e-1b83de2f004e/c7fc42c42b84ef4f856b8e25b001f5a6/dotnet-runtime-2.1.25-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/017feb75-60d8-4a90-9907-7f1cdaeaf11a/4a21019df08a0a6d84cc14511e202a93/dotnet-runtime-2.1.25-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/caa22019-110f-4631-a046-9b4c7b19b871/f5a0d5c8dfac46778e6f8ff4eced623e/dotnet-runtime-2.1.25-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/420e3a1d-4edd-4b01-bc42-101a95084966/6324c21c7445e0d90441f49631588b21/dotnet-runtime-2.1.25-win-x86.zip

[//]: # ( ASP 2.1.25)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/222ca907-5ffe-41e1-b221-91cb68d36909/02a203ff862bce166c579bafd47d9ac7/aspnetcore-runtime-2.1.25-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/129921c2-a0db-4869-8c3f-7de738830529/3efa531979a4d21d4c071eb80b689bd4/aspnetcore-runtime-2.1.25-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b8d8ee1-0670-46d5-ae77-e824e716993e/cb4a0f5d98ff86578ee0cb95f6e34c8f/aspnetcore-runtime-2.1.25-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27814802-8ed9-455c-997a-613ae9cc5eb7/1e54e6e9f52277075cc5b0877eecd1e4/aspnetcore-runtime-2.1.25-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0e36b9e0-ca99-4418-a934-2bdd75174284/2c8230b36c2a94ad4500dfa5d8da14be/aspnetcore-runtime-2.1.25-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5d96a0b6-db21-48b0-a363-c90bac0f52b1/cae46c7f5d98221cbb5893dc27a90f31/aspnetcore-runtime-2.1.25-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6a761e4a-87bd-4404-a04a-19b31e70ae5d/1675575f20362801f958585e2e58ad4c/aspnetcore-runtime-2.1.25-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1146a1cb-c2b2-4500-917f-5aaccc2e607d/ff8ab9af6eaa1c775bd75f8d545a7140/aspnetcore-runtime-2.1.25-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1378fab5-20e6-4481-a4c9-174d77a5f1df/da00bc27cc5cceac3d845b6e0332ce5a/dotnet-hosting-2.1.25-win.exe

[//]: # ( SDK 2.1.813 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44eecfb8-9e68-47dd-a114-fae139f5529c/665ac18f282a5f8554523de3f8dae1f3/dotnet-sdk-2.1.813-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c96a1ac-ea01-42bf-b889-f07566ffe031/2b74d411c54506f9913ca21f5df5f9a8/dotnet-sdk-2.1.813-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/466cdee6-8b59-4f4c-832a-3f568c357549/408bcb3abf7d834e3f8dd207e756032d/dotnet-sdk-2.1.813-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e1883c23-aad6-4658-a0bf-cdfb3d430d26/a2b8bdd775b9f5b1ff3424463955001c/dotnet-sdk-2.1.813-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1c7f880e-9cfb-46f9-9e6c-1ead2d713d37/54efd298bd08ff1c52d6c9362335da48/dotnet-sdk-2.1.813-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fafc1fda-8aa2-4b5d-9f04-fa2290127f25/bd76c13a6fafd3b41495a4d04a6ca13f/dotnet-sdk-2.1.813-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/acdded59-c1e8-4a72-be90-5c44d934d3d3/168bb056bdb021182199bb6b5e16154f/dotnet-sdk-2.1.813-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/33cd4e7b-8342-4a69-b421-d5e48c7c83cf/f6f087ae8e75e1fab8ddddd49eb25e07/dotnet-sdk-2.1.813-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/887daf17-8196-4a10-b93e-f39042b226f5/a42b9df32df7c4c548871ab1aee64a5e/dotnet-sdk-2.1.813-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/398308a9-9e9a-4de5-a3b0-5741de05be37/8d3c65f3bcc65353017a8aa47752a3db/dotnet-sdk-2.1.813-win-x86.zip

