# System.Diagnostics.Tracing

``` diff
 namespace System.Diagnostics.Tracing {
+    public abstract class DiagnosticCounter : IDisposable {
+        public string DisplayName { get; set; }
+        public string DisplayUnits { get; set; }
+        public EventSource EventSource { get; }
+        public string Name { get; }
+        public void AddMetadata(string key, string value);
+        public void Dispose();
+    }
-    public class EventCounter : IDisposable {
+    public class EventCounter : DiagnosticCounter {
-        public void Dispose();

+        public override string ToString();
+        public void WriteMetric(double value);
     }
+    public class IncrementingEventCounter : DiagnosticCounter {
+        public IncrementingEventCounter(string name, EventSource eventSource);
+        public TimeSpan DisplayRateTimeScale { get; set; }
+        public void Increment(double increment = 1);
+        public override string ToString();
+    }
+    public class IncrementingPollingCounter : DiagnosticCounter {
+        public IncrementingPollingCounter(string name, EventSource eventSource, Func<double> totalValueProvider);
+        public TimeSpan DisplayRateTimeScale { get; set; }
+        public override string ToString();
+    }
+    public class PollingCounter : DiagnosticCounter {
+        public PollingCounter(string name, EventSource eventSource, Func<double> metricProvider);
+        public override string ToString();
+    }
 }
```

