# System.Runtime.Loader

``` diff
 namespace System.Runtime.Loader {
+    public sealed class AssemblyDependencyResolver {
+        public AssemblyDependencyResolver(string componentAssemblyPath);
+        public string ResolveAssemblyToPath(AssemblyName assemblyName);
+        public string ResolveUnmanagedDllToPath(string unmanagedDllName);
+    }
-    public abstract class AssemblyLoadContext {
+    public class AssemblyLoadContext {
+        protected AssemblyLoadContext(bool isCollectible);
+        public AssemblyLoadContext(string name, bool isCollectible = false);
+        public static IEnumerable<AssemblyLoadContext> All { get; }
+        public IEnumerable<Assembly> Assemblies { get; }
+        public static AssemblyLoadContext CurrentContextualReflectionContext { get; }
+        public bool IsCollectible { get; }
+        public string Name { get; }
+        public event Func<Assembly, string, IntPtr> ResolvingUnmanagedDll;
+        public AssemblyLoadContext.ContextualReflectionScope EnterContextualReflection();
+        public static AssemblyLoadContext.ContextualReflectionScope EnterContextualReflection(Assembly activating);
+        ~AssemblyLoadContext();
-        protected abstract Assembly Load(AssemblyName assemblyName);
+        protected virtual Assembly Load(AssemblyName assemblyName);
+        public override string ToString();
+        public void Unload();
+        public struct ContextualReflectionScope : IDisposable {
+            public void Dispose();
+        }
     }
 }
```

