# System.IO.Pipelines

``` diff
 namespace System.IO.Pipelines {
     public class PipeOptions {
-        public PipeOptions(MemoryPool<byte> pool = null, PipeScheduler readerScheduler = null, PipeScheduler writerScheduler = null, long pauseWriterThreshold = (long)32768, long resumeWriterThreshold = (long)16384, int minimumSegmentSize = 2048, bool useSynchronizationContext = true);
+        public PipeOptions(MemoryPool<byte> pool = null, PipeScheduler readerScheduler = null, PipeScheduler writerScheduler = null, long pauseWriterThreshold = (long)-1, long resumeWriterThreshold = (long)-1, int minimumSegmentSize = -1, bool useSynchronizationContext = true);
     }
     public abstract class PipeReader {
+        public virtual Stream AsStream(bool leaveOpen = false);
+        public virtual ValueTask CompleteAsync(Exception exception = null);
+        public virtual Task CopyToAsync(PipeWriter destination, CancellationToken cancellationToken = default(CancellationToken));
+        public virtual Task CopyToAsync(Stream destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static PipeReader Create(Stream stream, StreamPipeReaderOptions readerOptions = null);
-        public abstract void OnWriterCompleted(Action<Exception, object> callback, object state);
+        public virtual void OnWriterCompleted(Action<Exception, object> callback, object state);
     }
     public abstract class PipeWriter : IBufferWriter<byte> {
+        public virtual Stream AsStream(bool leaveOpen = false);
+        public virtual ValueTask CompleteAsync(Exception exception = null);
+        protected internal virtual Task CopyFromAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static PipeWriter Create(Stream stream, StreamPipeWriterOptions writerOptions = null);
-        public abstract void OnReaderCompleted(Action<Exception, object> callback, object state);
+        public virtual void OnReaderCompleted(Action<Exception, object> callback, object state);
     }
-    public struct ReadResult
+    public readonly struct ReadResult
+    public static class StreamPipeExtensions {
+        public static Task CopyToAsync(this Stream source, PipeWriter destination, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public class StreamPipeReaderOptions {
+        public StreamPipeReaderOptions(MemoryPool<byte> pool = null, int bufferSize = -1, int minimumReadSize = -1, bool leaveOpen = false);
+        public int BufferSize { get; }
+        public bool LeaveOpen { get; }
+        public int MinimumReadSize { get; }
+        public MemoryPool<byte> Pool { get; }
+    }
+    public class StreamPipeWriterOptions {
+        public StreamPipeWriterOptions(MemoryPool<byte> pool = null, int minimumBufferSize = -1, bool leaveOpen = false);
+        public bool LeaveOpen { get; }
+        public int MinimumBufferSize { get; }
+        public MemoryPool<byte> Pool { get; }
+    }
 }
```

