# Microsoft.AspNetCore.Connections.Abstractions

``` diff
 {
     namespace Microsoft.AspNetCore.Connections {
-        public abstract class ConnectionContext {
+        public abstract class ConnectionContext : IAsyncDisposable {
+            public virtual CancellationToken ConnectionClosed { get; set; }
+            public virtual EndPoint LocalEndPoint { get; set; }
+            public virtual EndPoint RemoteEndPoint { get; set; }
+            public virtual ValueTask DisposeAsync();
         }
-        public class DefaultConnectionContext : ConnectionContext, IConnectionIdFeature, IConnectionItemsFeature, IConnectionLifetimeFeature, IConnectionTransportFeature, IConnectionUserFeature, IDisposable {
+        public class DefaultConnectionContext : ConnectionContext, IConnectionEndPointFeature, IConnectionIdFeature, IConnectionItemsFeature, IConnectionLifetimeFeature, IConnectionTransportFeature, IConnectionUserFeature {
-            public CancellationToken ConnectionClosed { get; set; }
+            public override CancellationToken ConnectionClosed { get; set; }
+            public override EndPoint LocalEndPoint { get; set; }
+            public override EndPoint RemoteEndPoint { get; set; }
-            public void Dispose();

+            public override ValueTask DisposeAsync();
         }
+        public class FileHandleEndPoint : EndPoint {
+            public FileHandleEndPoint(ulong fileHandle, FileHandleType fileHandleType);
+            public ulong FileHandle { get; }
+            public FileHandleType FileHandleType { get; }
+        }
+        public enum FileHandleType {
+            Auto = 0,
+            Pipe = 2,
+            Tcp = 1,
+        }
+        public interface IConnectionFactory {
+            ValueTask<ConnectionContext> ConnectAsync(EndPoint endpoint, CancellationToken cancellationToken = default(CancellationToken));
+        }
+        public interface IConnectionListener : IAsyncDisposable {
+            EndPoint EndPoint { get; }
+            ValueTask<ConnectionContext> AcceptAsync(CancellationToken cancellationToken = default(CancellationToken));
+            ValueTask UnbindAsync(CancellationToken cancellationToken = default(CancellationToken));
+        }
+        public interface IConnectionListenerFactory {
+            ValueTask<IConnectionListener> BindAsync(EndPoint endpoint, CancellationToken cancellationToken = default(CancellationToken));
+        }
+        public class UriEndPoint : EndPoint {
+            public UriEndPoint(Uri uri);
+            public Uri Uri { get; }
+        }
     }
     namespace Microsoft.AspNetCore.Connections.Features {
+        public interface IConnectionCompleteFeature {
+            void OnCompleted(Func<object, Task> callback, object state);
+        }
+        public interface IConnectionEndPointFeature {
+            EndPoint LocalEndPoint { get; set; }
+            EndPoint RemoteEndPoint { get; set; }
+        }
     }
 }
```

