# Microsoft.AspNetCore.Mvc.NewtonsoftJson

``` diff
 {
+    namespace Microsoft.AspNetCore.Mvc {
+        public static class JsonPatchExtensions {
+            public static void ApplyTo<T>(this JsonPatchDocument<T> patchDoc, T objectToApplyTo, ModelStateDictionary modelState) where T : class;
+            public static void ApplyTo<T>(this JsonPatchDocument<T> patchDoc, T objectToApplyTo, ModelStateDictionary modelState, string prefix) where T : class;
+        }
+        public class MvcNewtonsoftJsonOptions : IEnumerable, IEnumerable<ICompatibilitySwitch> {
+            public MvcNewtonsoftJsonOptions();
+            public bool AllowInputFormatterExceptionMessages { get; set; }
+            public JsonSerializerSettings SerializerSettings { get; }
+            IEnumerator<ICompatibilitySwitch> System.Collections.Generic.IEnumerable<Microsoft.AspNetCore.Mvc.Infrastructure.ICompatibilitySwitch>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        }
+    }
+    namespace Microsoft.AspNetCore.Mvc.Formatters {
+        public class NewtonsoftJsonInputFormatter : TextInputFormatter, IInputFormatterExceptionPolicy {
+            public NewtonsoftJsonInputFormatter(ILogger logger, JsonSerializerSettings serializerSettings, ArrayPool<char> charPool, ObjectPoolProvider objectPoolProvider, MvcOptions options, MvcNewtonsoftJsonOptions jsonOptions);
+            public virtual InputFormatterExceptionPolicy ExceptionPolicy { get; }
+            protected JsonSerializerSettings SerializerSettings { get; }
+            protected virtual JsonSerializer CreateJsonSerializer();
+            protected virtual JsonSerializer CreateJsonSerializer(InputFormatterContext context);
+            public override Task<InputFormatterResult> ReadRequestBodyAsync(InputFormatterContext context, Encoding encoding);
+            protected virtual void ReleaseJsonSerializer(JsonSerializer serializer);
+        }
+        public class NewtonsoftJsonOutputFormatter : TextOutputFormatter {
+            public NewtonsoftJsonOutputFormatter(JsonSerializerSettings serializerSettings, ArrayPool<char> charPool, MvcOptions mvcOptions);
+            protected JsonSerializerSettings SerializerSettings { get; }
+            protected virtual JsonSerializer CreateJsonSerializer();
+            protected virtual JsonSerializer CreateJsonSerializer(OutputFormatterWriteContext context);
+            protected virtual JsonWriter CreateJsonWriter(TextWriter writer);
+            public override Task WriteResponseBodyAsync(OutputFormatterWriteContext context, Encoding selectedEncoding);
+        }
+        public class NewtonsoftJsonPatchInputFormatter : NewtonsoftJsonInputFormatter {
+            public NewtonsoftJsonPatchInputFormatter(ILogger logger, JsonSerializerSettings serializerSettings, ArrayPool<char> charPool, ObjectPoolProvider objectPoolProvider, MvcOptions options, MvcNewtonsoftJsonOptions jsonOptions);
+            public override InputFormatterExceptionPolicy ExceptionPolicy { get; }
+            public override bool CanRead(InputFormatterContext context);
+            public override Task<InputFormatterResult> ReadRequestBodyAsync(InputFormatterContext context, Encoding encoding);
+        }
+    }
+    namespace Microsoft.AspNetCore.Mvc.NewtonsoftJson {
+        public static class JsonSerializerSettingsProvider {
+            public static JsonSerializerSettings CreateSerializerSettings();
+        }
+        public sealed class ProblemDetailsConverter : JsonConverter {
+            public ProblemDetailsConverter();
+            public override bool CanConvert(Type objectType);
+            public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer);
+            public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer);
+        }
+        public sealed class ValidationProblemDetailsConverter : JsonConverter {
+            public ValidationProblemDetailsConverter();
+            public override bool CanConvert(Type objectType);
+            public override object ReadJson(JsonReader reader, Type objectType, object existingValue, JsonSerializer serializer);
+            public override void WriteJson(JsonWriter writer, object value, JsonSerializer serializer);
+        }
+    }
+    namespace Microsoft.AspNetCore.Mvc.Rendering {
+        public static class JsonHelperExtensions {
+            public static IHtmlContent Serialize(this IJsonHelper jsonHelper, object value, JsonSerializerSettings serializerSettings);
+        }
+    }
+    namespace Microsoft.Extensions.DependencyInjection {
+        public static class MvcNewtonsoftJsonOptionsExtensions {
+            public static MvcNewtonsoftJsonOptions UseCamelCasing(this MvcNewtonsoftJsonOptions options, bool processDictionaryKeys);
+            public static MvcNewtonsoftJsonOptions UseMemberCasing(this MvcNewtonsoftJsonOptions options);
+        }
+        public static class NewtonsoftJsonMvcBuilderExtensions {
+            public static IMvcBuilder AddNewtonsoftJson(this IMvcBuilder builder);
+            public static IMvcBuilder AddNewtonsoftJson(this IMvcBuilder builder, Action<MvcNewtonsoftJsonOptions> setupAction);
+        }
+        public static class NewtonsoftJsonMvcCoreBuilderExtensions {
+            public static IMvcCoreBuilder AddNewtonsoftJson(this IMvcCoreBuilder builder);
+            public static IMvcCoreBuilder AddNewtonsoftJson(this IMvcCoreBuilder builder, Action<MvcNewtonsoftJsonOptions> setupAction);
+        }
+    }
+}
```

