# Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv

``` diff
 {
     namespace Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv {
         public class LibuvTransportOptions {
+            public long? MaxReadBufferSize { get; set; }
+            public long? MaxWriteBufferSize { get; set; }
+            public bool NoDelay { get; set; }
         }
     }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv.Internal {
 {
-        public interface ILibuvTrace : ILogger {
 {
-            void ConnectionError(string connectionId, Exception ex);

-            void ConnectionPause(string connectionId);

-            void ConnectionRead(string connectionId, int count);

-            void ConnectionReadFin(string connectionId);

-            void ConnectionReset(string connectionId);

-            void ConnectionResume(string connectionId);

-            void ConnectionWrite(string connectionId, int count);

-            void ConnectionWriteCallback(string connectionId, int status);

-            void ConnectionWriteFin(string connectionId, string reason);

-        }
-        public class LibuvAwaitable<TRequest> : ICriticalNotifyCompletion, INotifyCompletion where TRequest : UvRequest {
 {
-            public static readonly Action<TRequest, int, UvException, object> Callback;

-            public LibuvAwaitable();

-            public bool IsCompleted { get; }

-            public LibuvAwaitable<TRequest> GetAwaiter();

-            public UvWriteResult GetResult();

-            public void OnCompleted(Action continuation);

-            public void UnsafeOnCompleted(Action continuation);

-        }
-        public class LibuvConnection : TransportConnection, IDisposable {
 {
-            public LibuvConnection(UvStreamHandle socket, ILibuvTrace log, LibuvThread thread, IPEndPoint remoteEndPoint, IPEndPoint localEndPoint);

-            public override PipeScheduler InputWriterScheduler { get; }

-            public override MemoryPool<byte> MemoryPool { get; }

-            public LibuvOutputConsumer OutputConsumer { get; set; }

-            public override PipeScheduler OutputReaderScheduler { get; }

-            public override void Abort(ConnectionAbortedException abortReason);

-            public void Dispose();

-            public Task Start();

-        }
-        public class LibuvOutputConsumer {
 {
-            public LibuvOutputConsumer(PipeReader pipe, LibuvThread thread, UvStreamHandle socket, string connectionId, ILibuvTrace log);

-            public Task WriteOutputAsync();

-        }
-        public class LibuvThread : PipeScheduler {
 {
-            public LibuvThread(LibuvTransport transport);

-            public LibuvThread(LibuvTransport transport, int maxLoops);

-            public Exception FatalError { get; }

-            public UvLoopHandle Loop { get; }

-            public MemoryPool<byte> MemoryPool { get; }

-            public Action<Action<IntPtr>, IntPtr> QueueCloseHandle { get; }

-            public WriteReqPool WriteReqPool { get; }

-            public void Post<T>(Action<T> callback, T state);

-            public Task PostAsync<T>(Action<T> callback, T state);

-            public override void Schedule(Action<object> action, object state);

-            public Task StartAsync();

-            public Task StopAsync(TimeSpan timeout);

-            public void Walk(Action<IntPtr> callback);

-        }
-        public class LibuvTrace : ILibuvTrace, ILogger {
 {
-            public LibuvTrace(ILogger logger);

-            public IDisposable BeginScope<TState>(TState state);

-            public void ConnectionError(string connectionId, Exception ex);

-            public void ConnectionPause(string connectionId);

-            public void ConnectionRead(string connectionId, int count);

-            public void ConnectionReadFin(string connectionId);

-            public void ConnectionReset(string connectionId);

-            public void ConnectionResume(string connectionId);

-            public void ConnectionWrite(string connectionId, int count);

-            public void ConnectionWriteCallback(string connectionId, int status);

-            public void ConnectionWriteFin(string connectionId, string reason);

-            public bool IsEnabled(LogLevel logLevel);

-            public void Log<TState>(LogLevel logLevel, EventId eventId, TState state, Exception exception, Func<TState, Exception, string> formatter);

-        }
-        public class LibuvTransport : ITransport {
 {
-            public LibuvTransport(LibuvTransportContext context, IEndPointInformation endPointInformation);

-            public LibuvTransport(LibuvFunctions uv, LibuvTransportContext context, IEndPointInformation endPointInformation);

-            public IApplicationLifetime AppLifetime { get; }

-            public LibuvFunctions Libuv { get; }

-            public ILibuvTrace Log { get; }

-            public List<LibuvThread> Threads { get; }

-            public LibuvTransportContext TransportContext { get; }

-            public LibuvTransportOptions TransportOptions { get; }

-            public Task BindAsync();

-            public Task StopAsync();

-            public Task UnbindAsync();

-        }
-        public class LibuvTransportContext {
 {
-            public LibuvTransportContext();

-            public IApplicationLifetime AppLifetime { get; set; }

-            public IConnectionDispatcher ConnectionDispatcher { get; set; }

-            public ILibuvTrace Log { get; set; }

-            public LibuvTransportOptions Options { get; set; }

-        }
-        public class LibuvTransportFactory : ITransportFactory {
 {
-            public LibuvTransportFactory(IOptions<LibuvTransportOptions> options, IApplicationLifetime applicationLifetime, ILoggerFactory loggerFactory);

-            public ITransport Create(IEndPointInformation endPointInformation, IConnectionDispatcher dispatcher);

-        }
-        public class Listener : ListenerContext, IAsyncDisposable {
 {
-            public Listener(LibuvTransportContext transportContext);

-            protected UvStreamHandle ListenSocket { get; private set; }

-            public ILibuvTrace Log { get; }

-            protected virtual void DispatchConnection(UvStreamHandle socket);

-            public virtual Task DisposeAsync();

-            public Task StartAsync(IEndPointInformation endPointInformation, LibuvThread thread);

-        }
-        public class ListenerContext {
 {
-            public ListenerContext(LibuvTransportContext transportContext);

-            public IEndPointInformation EndPointInformation { get; set; }

-            public LibuvThread Thread { get; set; }

-            public LibuvTransportContext TransportContext { get; set; }

-            protected UvStreamHandle CreateAcceptSocket();

-            protected Task HandleConnectionAsync(UvStreamHandle socket);

-        }
-        public class ListenerPrimary : Listener {
 {
-            public ListenerPrimary(LibuvTransportContext transportContext);

-            public int UvPipeCount { get; }

-            protected override void DispatchConnection(UvStreamHandle socket);

-            public override Task DisposeAsync();

-            public Task StartAsync(string pipeName, byte[] pipeMessage, IEndPointInformation endPointInformation, LibuvThread thread);

-        }
-        public class ListenerSecondary : ListenerContext, IAsyncDisposable {
 {
-            public ListenerSecondary(LibuvTransportContext transportContext);

-            public ILibuvTrace Log { get; }

-            public Task DisposeAsync();

-            public Task StartAsync(string pipeName, byte[] pipeMessage, IEndPointInformation endPointInformation, LibuvThread thread);

-        }
-        public struct UvWriteResult {
 {
-            public UvWriteResult(int status, UvException error);

-            public UvException Error { get; }

-            public int Status { get; }

-        }
-        public class WriteReqPool {
 {
-            public WriteReqPool(LibuvThread thread, ILibuvTrace log);

-            public UvWriteReq Allocate();

-            public void Dispose();

-            public void Return(UvWriteReq req);

-        }
-    }
-    namespace Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv.Internal.Networking {
 {
-        public class LibuvFunctions {
 {
-            protected Action<UvConnectRequest, UvPipeHandle, string, LibuvFunctions.uv_connect_cb> _uv_pipe_connect;

-            protected Action<UvHandle> _uv_ref;

-            protected Action<UvHandle> _uv_unref;

-            protected Action<UvLoopHandle> _uv_stop;

-            protected Action<IntPtr, LibuvFunctions.uv_close_cb> _uv_close;

-            public readonly bool IsWindows;

-            protected Func<LibuvFunctions.HandleType, int> _uv_handle_size;

-            protected Func<UvAsyncHandle, int> _uv_async_send;

-            protected Func<UvLoopHandle, UvAsyncHandle, LibuvFunctions.uv_async_cb, int> _uv_async_init;

-            protected Func<UvLoopHandle, UvPipeHandle, int, int> _uv_pipe_init;

-            protected Func<UvLoopHandle, UvTcpHandle, int> _uv_tcp_init;

-            protected Func<UvLoopHandle, UvTimerHandle, int> _uv_timer_init;

-            protected Func<UvLoopHandle, int, int> _uv_run;

-            protected Func<UvLoopHandle, int> _uv_loop_init;

-            protected Func<UvLoopHandle, long> _uv_now;

-            protected Func<UvLoopHandle, LibuvFunctions.uv_walk_cb, IntPtr, int> _uv_walk;

-            protected Func<UvPipeHandle, int> _uv_pipe_pending_count;

-            protected Func<UvPipeHandle, IntPtr, int> _uv_pipe_open;

-            protected Func<UvPipeHandle, string, int> _uv_pipe_bind;

-            protected Func<UvStreamHandle, UvStreamHandle, int> _uv_accept;

-            protected Func<UvStreamHandle, int, LibuvFunctions.uv_connection_cb, int> _uv_listen;

-            protected Func<UvStreamHandle, int> _uv_read_stop;

-            protected Func<UvStreamHandle, LibuvFunctions.uv_alloc_cb, LibuvFunctions.uv_read_cb, int> _uv_read_start;

-            protected Func<UvStreamHandle, LibuvFunctions.uv_buf_t[], int, int> _uv_try_write;

-            protected Func<UvTcpHandle, int, int> _uv_tcp_nodelay;

-            protected Func<UvTcpHandle, IntPtr, int> _uv_tcp_open;

-            protected Func<UvTimerHandle, int> _uv_timer_stop;

-            protected Func<UvTimerHandle, LibuvFunctions.uv_timer_cb, long, long, int> _uv_timer_start;

-            protected Func<LibuvFunctions.RequestType, int> _uv_req_size;

-            protected Func<int, IntPtr> _uv_err_name;

-            protected Func<int, IntPtr> _uv_strerror;

-            protected Func<int> _uv_loop_size;

-            protected Func<IntPtr, int> _uv_loop_close;

-            protected Func<IntPtr, int> _uv_unsafe_async_send;

-            protected LibuvFunctions.uv_fileno_func _uv_fileno;

-            protected LibuvFunctions.uv_ip4_addr_func _uv_ip4_addr;

-            protected LibuvFunctions.uv_ip6_addr_func _uv_ip6_addr;

-            protected LibuvFunctions.uv_tcp_bind_func _uv_tcp_bind;

-            protected LibuvFunctions.uv_tcp_getpeername_func _uv_tcp_getpeername;

-            protected LibuvFunctions.uv_tcp_getsockname_func _uv_tcp_getsockname;

-            protected LibuvFunctions.uv_write2_func _uv_write2;

-            protected LibuvFunctions.uv_write_func _uv_write;

-            public LibuvFunctions();

-            public LibuvFunctions(bool onlyForTesting);

-            public void accept(UvStreamHandle server, UvStreamHandle client);

-            public void async_init(UvLoopHandle loop, UvAsyncHandle handle, LibuvFunctions.uv_async_cb cb);

-            public void async_send(UvAsyncHandle handle);

-            public LibuvFunctions.uv_buf_t buf_init(IntPtr memory, int len);

-            public void Check(int statusCode, out UvException error);

-            public void close(UvHandle handle, LibuvFunctions.uv_close_cb close_cb);

-            public void close(IntPtr handle, LibuvFunctions.uv_close_cb close_cb);

-            public string err_name(int err);

-            public int handle_size(LibuvFunctions.HandleType handleType);

-            public void ip4_addr(string ip, int port, out SockAddr addr, out UvException error);

-            public void ip6_addr(string ip, int port, out SockAddr addr, out UvException error);

-            public void listen(UvStreamHandle handle, int backlog, LibuvFunctions.uv_connection_cb cb);

-            public void loop_close(UvLoopHandle handle);

-            public void loop_init(UvLoopHandle handle);

-            public int loop_size();

-            public long now(UvLoopHandle loop);

-            public void pipe_bind(UvPipeHandle handle, string name);

-            public void pipe_connect(UvConnectRequest req, UvPipeHandle handle, string name, LibuvFunctions.uv_connect_cb cb);

-            public void pipe_init(UvLoopHandle loop, UvPipeHandle handle, bool ipc);

-            public void pipe_open(UvPipeHandle handle, IntPtr hSocket);

-            public int pipe_pending_count(UvPipeHandle handle);

-            public void read_start(UvStreamHandle handle, LibuvFunctions.uv_alloc_cb alloc_cb, LibuvFunctions.uv_read_cb read_cb);

-            public void read_stop(UvStreamHandle handle);

-            public void @ref(UvHandle handle);

-            public int req_size(LibuvFunctions.RequestType reqType);

-            public void run(UvLoopHandle handle, int mode);

-            public void stop(UvLoopHandle handle);

-            public string strerror(int err);

-            public void tcp_bind(UvTcpHandle handle, ref SockAddr addr, int flags);

-            public void tcp_getpeername(UvTcpHandle handle, out SockAddr addr, ref int namelen);

-            public void tcp_getsockname(UvTcpHandle handle, out SockAddr addr, ref int namelen);

-            public void tcp_init(UvLoopHandle loop, UvTcpHandle handle);

-            public void tcp_nodelay(UvTcpHandle handle, bool enable);

-            public void tcp_open(UvTcpHandle handle, IntPtr hSocket);

-            public void ThrowIfErrored(int statusCode);

-            public void timer_init(UvLoopHandle loop, UvTimerHandle handle);

-            public void timer_start(UvTimerHandle handle, LibuvFunctions.uv_timer_cb cb, long timeout, long repeat);

-            public void timer_stop(UvTimerHandle handle);

-            public int try_write(UvStreamHandle handle, LibuvFunctions.uv_buf_t[] bufs, int nbufs);

-            public void unref(UvHandle handle);

-            public void unsafe_async_send(IntPtr handle);

-            public void uv_fileno(UvHandle handle, ref IntPtr socket);

-            public void walk(UvLoopHandle loop, LibuvFunctions.uv_walk_cb walk_cb, IntPtr arg);

-            public unsafe void write(UvRequest req, UvStreamHandle handle, LibuvFunctions.uv_buf_t* bufs, int nbufs, LibuvFunctions.uv_write_cb cb);

-            public unsafe void write2(UvRequest req, UvStreamHandle handle, LibuvFunctions.uv_buf_t* bufs, int nbufs, UvStreamHandle sendHandle, LibuvFunctions.uv_write_cb cb);

-            public enum HandleType {
 {
-                ASYNC = 1,

-                CHECK = 2,

-                FS_EVENT = 3,

-                FS_POLL = 4,

-                HANDLE = 5,

-                IDLE = 6,

-                NAMED_PIPE = 7,

-                POLL = 8,

-                PREPARE = 9,

-                PROCESS = 10,

-                SIGNAL = 16,

-                STREAM = 11,

-                TCP = 12,

-                TIMER = 13,

-                TTY = 14,

-                UDP = 15,

-                Unknown = 0,

-            }
-            public enum RequestType {
 {
-                CONNECT = 2,

-                FS = 6,

-                GETADDRINFO = 8,

-                GETNAMEINFO = 9,

-                REQ = 1,

-                SHUTDOWN = 4,

-                UDP_SEND = 5,

-                Unknown = 0,

-                WORK = 7,

-                WRITE = 3,

-            }
-            public delegate void uv_alloc_cb(IntPtr server, int suggested_size, out LibuvFunctions.uv_buf_t buf);

-            public delegate void uv_async_cb(IntPtr handle);

-            public struct uv_buf_t {
 {
-                public uv_buf_t(IntPtr memory, int len, bool IsWindows);

-            }
-            public delegate void uv_close_cb(IntPtr handle);

-            public delegate void uv_connect_cb(IntPtr req, int status);

-            public delegate void uv_connection_cb(IntPtr server, int status);

-            protected delegate int uv_fileno_func(UvHandle handle, ref IntPtr socket);

-            protected delegate int uv_ip4_addr_func(string ip, int port, out SockAddr addr);

-            protected delegate int uv_ip6_addr_func(string ip, int port, out SockAddr addr);

-            public delegate void uv_read_cb(IntPtr server, int nread, ref LibuvFunctions.uv_buf_t buf);

-            protected delegate int uv_tcp_bind_func(UvTcpHandle handle, ref SockAddr addr, int flags);

-            public delegate int uv_tcp_getpeername_func(UvTcpHandle handle, out SockAddr addr, ref int namelen);

-            public delegate int uv_tcp_getsockname_func(UvTcpHandle handle, out SockAddr addr, ref int namelen);

-            public delegate void uv_timer_cb(IntPtr handle);

-            public delegate void uv_walk_cb(IntPtr handle, IntPtr arg);

-            public delegate void uv_write_cb(IntPtr req, int status);

-            protected unsafe delegate int uv_write_func(UvRequest req, UvStreamHandle handle, LibuvFunctions.uv_buf_t* bufs, int nbufs, LibuvFunctions.uv_write_cb cb);

-            protected unsafe delegate int uv_write2_func(UvRequest req, UvStreamHandle handle, LibuvFunctions.uv_buf_t* bufs, int nbufs, UvStreamHandle sendHandle, LibuvFunctions.uv_write_cb cb);

-        }
-        public static class PlatformApis {
 {
-            public static bool IsDarwin { get; }

-            public static bool IsWindows { get; }

-            public static long VolatileRead(ref long value);

-        }
-        public struct SockAddr {
 {
-            public SockAddr(long ignored);

-            public uint ScopeId { get; set; }

-            public IPEndPoint GetIPEndPoint();

-        }
-        public class UvAsyncHandle : UvHandle {
 {
-            public UvAsyncHandle(ILibuvTrace logger);

-            public void Init(UvLoopHandle loop, Action callback, Action<Action<IntPtr>, IntPtr> queueCloseHandle);

-            protected override bool ReleaseHandle();

-            public void Send();

-        }
-        public class UvConnectRequest : UvRequest {
 {
-            public UvConnectRequest(ILibuvTrace logger);

-            public void Connect(UvPipeHandle pipe, string name, Action<UvConnectRequest, int, UvException, object> callback, object state);

-            public void DangerousInit(UvLoopHandle loop);

-            public override void Init(LibuvThread thread);

-        }
-        public class UvException : Exception {
 {
-            public UvException(string message, int statusCode);

-            public int StatusCode { get; }

-        }
-        public abstract class UvHandle : UvMemory {
 {
-            protected UvHandle(ILibuvTrace logger);

-            protected void CreateHandle(LibuvFunctions uv, int threadId, int size, Action<Action<IntPtr>, IntPtr> queueCloseHandle);

-            public void Reference();

-            protected override bool ReleaseHandle();

-            public void Unreference();

-        }
-        public class UvLoopHandle : UvMemory {
 {
-            public UvLoopHandle(ILibuvTrace logger);

-            public void Init(LibuvFunctions uv);

-            public long Now();

-            protected override bool ReleaseHandle();

-            public void Run(int mode = 0);

-            public void Stop();

-        }
-        public abstract class UvMemory : SafeHandle {
 {
-            protected readonly ILibuvTrace _log;

-            protected LibuvFunctions _uv;

-            protected int _threadId;

-            protected UvMemory(ILibuvTrace logger, GCHandleType handleType = GCHandleType.Weak);

-            public override bool IsInvalid { get; }

-            public LibuvFunctions Libuv { get; }

-            public int ThreadId { get; private set; }

-            protected void CreateMemory(LibuvFunctions uv, int threadId, int size);

-            protected static void DestroyMemory(IntPtr memory);

-            protected static void DestroyMemory(IntPtr memory, IntPtr gcHandlePtr);

-            public static THandle FromIntPtr<THandle>(IntPtr handle);

-            public IntPtr InternalGetHandle();

-            public void Validate(bool closed = false);

-        }
-        public class UvPipeHandle : UvStreamHandle {
 {
-            public UvPipeHandle(ILibuvTrace logger);

-            public void Bind(string name);

-            public void Init(UvLoopHandle loop, Action<Action<IntPtr>, IntPtr> queueCloseHandle, bool ipc = false);

-            public void Open(IntPtr fileDescriptor);

-            public int PendingCount();

-        }
-        public class UvRequest : UvMemory {
 {
-            protected UvRequest(ILibuvTrace logger);

-            public virtual void Init(LibuvThread thread);

-            protected override bool ReleaseHandle();

-        }
-        public abstract class UvStreamHandle : UvHandle {
 {
-            protected UvStreamHandle(ILibuvTrace logger);

-            public void Accept(UvStreamHandle handle);

-            public void Listen(int backlog, Action<UvStreamHandle, int, UvException, object> callback, object state);

-            public void ReadStart(Func<UvStreamHandle, int, object, LibuvFunctions.uv_buf_t> allocCallback, Action<UvStreamHandle, int, object> readCallback, object state);

-            public void ReadStop();

-            protected override bool ReleaseHandle();

-            public int TryWrite(LibuvFunctions.uv_buf_t buf);

-        }
-        public class UvTcpHandle : UvStreamHandle {
 {
-            public UvTcpHandle(ILibuvTrace logger);

-            public void Bind(IPEndPoint endPoint);

-            public IPEndPoint GetPeerIPEndPoint();

-            public IPEndPoint GetSockIPEndPoint();

-            public void Init(UvLoopHandle loop, Action<Action<IntPtr>, IntPtr> queueCloseHandle);

-            public void NoDelay(bool enable);

-            public void Open(IntPtr fileDescriptor);

-        }
-        public class UvTimerHandle : UvHandle {
 {
-            public UvTimerHandle(ILibuvTrace logger);

-            public void Init(UvLoopHandle loop, Action<Action<IntPtr>, IntPtr> queueCloseHandle);

-            public void Start(Action<UvTimerHandle> callback, long timeout, long repeat);

-            public void Stop();

-        }
-        public class UvWriteReq : UvRequest {
 {
-            public UvWriteReq(ILibuvTrace logger);

-            public void DangerousInit(UvLoopHandle loop);

-            public override void Init(LibuvThread thread);

-            public void Write2(UvStreamHandle handle, ArraySegment<ArraySegment<byte>> bufs, UvStreamHandle sendHandle, Action<UvWriteReq, int, UvException, object> callback, object state);

-            public LibuvAwaitable<UvWriteReq> WriteAsync(UvStreamHandle handle, ArraySegment<ArraySegment<byte>> bufs);

-            public LibuvAwaitable<UvWriteReq> WriteAsync(UvStreamHandle handle, ReadOnlySequence<byte> buffer);

-        }
-    }
 }
```

