# System.Text.Json

``` diff
 namespace System.Text.Json {
     public sealed class JsonDocument : IDisposable {
+        public static JsonDocument ParseValue(ref Utf8JsonReader reader);
+        public static bool TryParseValue(ref Utf8JsonReader reader, out JsonDocument document);
     }
     public readonly struct JsonElement {
+        public DateTime GetDateTime();
+        public DateTimeOffset GetDateTimeOffset();
+        public Guid GetGuid();
+        public bool TryGetDateTime(out DateTime value);
+        public bool TryGetDateTimeOffset(out DateTimeOffset value);
+        public bool TryGetGuid(out Guid value);
+        public void WriteAsProperty(ReadOnlySpan<byte> utf8PropertyName, ref Utf8JsonWriter writer);
+        public void WriteAsProperty(ReadOnlySpan<char> propertyName, ref Utf8JsonWriter writer);
+        public void WriteAsValue(ref Utf8JsonWriter writer);
     }
     public struct JsonReaderOptions {
+        public bool AllowTrailingCommas { get; set; }
+        public int MaxDepth { get; set; }
     }
     public struct JsonReaderState {
-        public JsonReaderState(int maxDepth = 64, JsonReaderOptions options = default(JsonReaderOptions));

+        public JsonReaderState(JsonReaderOptions options = default(JsonReaderOptions));
-        public int MaxDepth { get; }

     }
     public ref struct Utf8JsonReader {
+        public DateTime GetDateTime();
+        public DateTimeOffset GetDateTimeOffset();
+        public Guid GetGuid();
+        public bool TextEquals(ReadOnlySpan<byte> otherUtf8Text);
+        public bool TextEquals(ReadOnlySpan<char> otherText);
+        public bool TryGetDateTime(out DateTime value);
+        public bool TryGetDateTimeOffset(out DateTimeOffset value);
+        public bool TryGetGuid(out Guid value);
     }
 }
```

