# System.Text.Json

``` diff
 namespace System.Text.Json {
     public readonly struct JsonElement {
+        public JsonElement Clone();
-        public void WriteAsProperty(ReadOnlySpan<byte> utf8PropertyName, ref Utf8JsonWriter writer);
+        public void WriteAsProperty(ReadOnlySpan<byte> utf8PropertyName, Utf8JsonWriter writer);
-        public void WriteAsProperty(ReadOnlySpan<char> propertyName, ref Utf8JsonWriter writer);
+        public void WriteAsProperty(ReadOnlySpan<char> propertyName, Utf8JsonWriter writer);
-        public void WriteAsValue(ref Utf8JsonWriter writer);
+        public void WriteAsValue(Utf8JsonWriter writer);
     }
-    public struct JsonWriterState {
 {
-        public JsonWriterState(JsonWriterOptions options = default(JsonWriterOptions));

-        public long BytesCommitted { get; }

-        public long BytesWritten { get; }

-        public JsonWriterOptions Options { get; }

-    }
-    public ref struct Utf8JsonWriter {
+    public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public Utf8JsonWriter(IBufferWriter<byte> bufferWriter, JsonWriterOptions options = default(JsonWriterOptions));
-        public Utf8JsonWriter(IBufferWriter<byte> bufferWriter, JsonWriterState state = default(JsonWriterState));

+        public Utf8JsonWriter(Stream utf8Json, JsonWriterOptions options = default(JsonWriterOptions));
+        public int BytesPending { get; }
-        public long BytesWritten { get; }

+        public JsonWriterOptions Options { get; }
+        public void Dispose();
+        public ValueTask DisposeAsync();
+        public void Flush();
-        public void Flush(bool isFinalBlock = true);

+        public Task FlushAsync(CancellationToken cancellationToken = default(CancellationToken));
-        public JsonWriterState GetCurrentState();

+        public void Reset();
+        public void Reset(IBufferWriter<byte> bufferWriter);
+        public void Reset(Stream utf8Json);
+        public void WriteBoolean(ReadOnlySpan<byte> utf8PropertyName, bool value);
-        public void WriteBoolean(ReadOnlySpan<byte> utf8PropertyName, bool value, bool escape = true);

+        public void WriteBoolean(ReadOnlySpan<char> propertyName, bool value);
-        public void WriteBoolean(ReadOnlySpan<char> propertyName, bool value, bool escape = true);

+        public void WriteBoolean(string propertyName, bool value);
-        public void WriteBoolean(string propertyName, bool value, bool escape = true);

+        public void WriteCommentValue(ReadOnlySpan<byte> utf8Value);
-        public void WriteCommentValue(ReadOnlySpan<byte> utf8Value, bool escape = true);

+        public void WriteCommentValue(ReadOnlySpan<char> value);
-        public void WriteCommentValue(ReadOnlySpan<char> value, bool escape = true);

+        public void WriteCommentValue(string value);
-        public void WriteCommentValue(string value, bool escape = true);

+        public void WriteNull(ReadOnlySpan<byte> utf8PropertyName);
-        public void WriteNull(ReadOnlySpan<byte> utf8PropertyName, bool escape = true);

+        public void WriteNull(ReadOnlySpan<char> propertyName);
-        public void WriteNull(ReadOnlySpan<char> propertyName, bool escape = true);

+        public void WriteNull(string propertyName);
-        public void WriteNull(string propertyName, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, decimal value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, decimal value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, double value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, double value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, int value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, int value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, long value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, long value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, float value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, float value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, uint value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, uint value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, ulong value);
-        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, ulong value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, decimal value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, decimal value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, double value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, double value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, int value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, int value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, long value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, long value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, float value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, float value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, uint value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, uint value, bool escape = true);

+        public void WriteNumber(ReadOnlySpan<char> propertyName, ulong value);
-        public void WriteNumber(ReadOnlySpan<char> propertyName, ulong value, bool escape = true);

+        public void WriteNumber(string propertyName, decimal value);
-        public void WriteNumber(string propertyName, decimal value, bool escape = true);

+        public void WriteNumber(string propertyName, double value);
-        public void WriteNumber(string propertyName, double value, bool escape = true);

+        public void WriteNumber(string propertyName, int value);
-        public void WriteNumber(string propertyName, int value, bool escape = true);

+        public void WriteNumber(string propertyName, long value);
-        public void WriteNumber(string propertyName, long value, bool escape = true);

+        public void WriteNumber(string propertyName, float value);
-        public void WriteNumber(string propertyName, float value, bool escape = true);

+        public void WriteNumber(string propertyName, uint value);
-        public void WriteNumber(string propertyName, uint value, bool escape = true);

+        public void WriteNumber(string propertyName, ulong value);
-        public void WriteNumber(string propertyName, ulong value, bool escape = true);

+        public void WriteStartArray(ReadOnlySpan<byte> utf8PropertyName);
-        public void WriteStartArray(ReadOnlySpan<byte> utf8PropertyName, bool escape = true);

+        public void WriteStartArray(ReadOnlySpan<char> propertyName);
-        public void WriteStartArray(ReadOnlySpan<char> propertyName, bool escape = true);

+        public void WriteStartArray(string propertyName);
-        public void WriteStartArray(string propertyName, bool escape = true);

+        public void WriteStartObject(ReadOnlySpan<byte> utf8PropertyName);
-        public void WriteStartObject(ReadOnlySpan<byte> utf8PropertyName, bool escape = true);

+        public void WriteStartObject(ReadOnlySpan<char> propertyName);
-        public void WriteStartObject(ReadOnlySpan<char> propertyName, bool escape = true);

+        public void WriteStartObject(string propertyName);
-        public void WriteStartObject(string propertyName, bool escape = true);

+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTime value);
-        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTime value, bool escape = true);

+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTimeOffset value);
-        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTimeOffset value, bool escape = true);

+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, Guid value);
-        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, Guid value, bool escape = true);

+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<byte> utf8Value);
-        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<byte> utf8Value, bool escape = true);

+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<char> value);
-        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<char> value, bool escape = true);

+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, string value);
-        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, string value, bool escape = true);

+        public void WriteString(ReadOnlySpan<char> propertyName, DateTime value);
-        public void WriteString(ReadOnlySpan<char> propertyName, DateTime value, bool escape = true);

+        public void WriteString(ReadOnlySpan<char> propertyName, DateTimeOffset value);
-        public void WriteString(ReadOnlySpan<char> propertyName, DateTimeOffset value, bool escape = true);

+        public void WriteString(ReadOnlySpan<char> propertyName, Guid value);
-        public void WriteString(ReadOnlySpan<char> propertyName, Guid value, bool escape = true);

+        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<byte> utf8Value);
-        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<byte> utf8Value, bool escape = true);

+        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<char> value);
-        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<char> value, bool escape = true);

+        public void WriteString(ReadOnlySpan<char> propertyName, string value);
-        public void WriteString(ReadOnlySpan<char> propertyName, string value, bool escape = true);

+        public void WriteString(string propertyName, DateTime value);
-        public void WriteString(string propertyName, DateTime value, bool escape = true);

+        public void WriteString(string propertyName, DateTimeOffset value);
-        public void WriteString(string propertyName, DateTimeOffset value, bool escape = true);

+        public void WriteString(string propertyName, Guid value);
-        public void WriteString(string propertyName, Guid value, bool escape = true);

+        public void WriteString(string propertyName, ReadOnlySpan<byte> utf8Value);
-        public void WriteString(string propertyName, ReadOnlySpan<byte> utf8Value, bool escape = true);

+        public void WriteString(string propertyName, ReadOnlySpan<char> value);
-        public void WriteString(string propertyName, ReadOnlySpan<char> value, bool escape = true);

+        public void WriteString(string propertyName, string value);
-        public void WriteString(string propertyName, string value, bool escape = true);

+        public void WriteStringValue(ReadOnlySpan<byte> utf8Value);
-        public void WriteStringValue(ReadOnlySpan<byte> utf8Value, bool escape = true);

+        public void WriteStringValue(ReadOnlySpan<char> value);
-        public void WriteStringValue(ReadOnlySpan<char> value, bool escape = true);

+        public void WriteStringValue(string value);
-        public void WriteStringValue(string value, bool escape = true);

     }
 }
```

