# Microsoft.AspNetCore.Components.Web

``` diff
 namespace Microsoft.AspNetCore.Components.Web {
+    public static class BindAttributes
+    public class ClipboardEventArgs : EventArgs {
+        public ClipboardEventArgs();
+        public string Type { get; set; }
+    }
+    public class DataTransfer {
+        public DataTransfer();
+        public string DropEffect { get; set; }
+        public string EffectAllowed { get; set; }
+        public string[] Files { get; set; }
+        public DataTransferItem[] Items { get; set; }
+        public string[] Types { get; set; }
+    }
+    public class DataTransferItem {
+        public DataTransferItem();
+        public string Kind { get; set; }
+        public string Type { get; set; }
+    }
+    public class DragEventArgs : MouseEventArgs {
+        public DragEventArgs();
+        public DataTransfer DataTransfer { get; set; }
+    }
+    public class ErrorEventArgs : EventArgs {
+        public ErrorEventArgs();
+        public int Colno { get; set; }
+        public string Filename { get; set; }
+        public int Lineno { get; set; }
+        public string Message { get; set; }
+        public string Type { get; set; }
+    }
+    public static class EventHandlers
+    public class FocusEventArgs : EventArgs {
+        public FocusEventArgs();
+        public string Type { get; set; }
+    }
+    public class KeyboardEventArgs : EventArgs {
+        public KeyboardEventArgs();
+        public bool AltKey { get; set; }
+        public string Code { get; set; }
+        public bool CtrlKey { get; set; }
+        public string Key { get; set; }
+        public float Location { get; set; }
+        public bool MetaKey { get; set; }
+        public bool Repeat { get; set; }
+        public bool ShiftKey { get; set; }
+        public string Type { get; set; }
+    }
+    public class MouseEventArgs : EventArgs {
+        public MouseEventArgs();
+        public bool AltKey { get; set; }
+        public long Button { get; set; }
+        public long Buttons { get; set; }
+        public double ClientX { get; set; }
+        public double ClientY { get; set; }
+        public bool CtrlKey { get; set; }
+        public long Detail { get; set; }
+        public bool MetaKey { get; set; }
+        public double ScreenX { get; set; }
+        public double ScreenY { get; set; }
+        public bool ShiftKey { get; set; }
+        public string Type { get; set; }
+    }
+    public class PointerEventArgs : MouseEventArgs {
+        public PointerEventArgs();
+        public float Height { get; set; }
+        public bool IsPrimary { get; set; }
+        public long PointerId { get; set; }
+        public string PointerType { get; set; }
+        public float Pressure { get; set; }
+        public float TiltX { get; set; }
+        public float TiltY { get; set; }
+        public float Width { get; set; }
+    }
+    public class ProgressEventArgs : EventArgs {
+        public ProgressEventArgs();
+        public bool LengthComputable { get; set; }
+        public long Loaded { get; set; }
+        public long Total { get; set; }
+        public string Type { get; set; }
+    }
-    public static class RendererRegistryEventDispatcher {
 {
-        public static Task DispatchEvent(RendererRegistryEventDispatcher.BrowserEventDescriptor eventDescriptor, string eventArgsJson);

-        public class BrowserEventDescriptor {
 {
-            public BrowserEventDescriptor();

-            public int BrowserRendererId { get; set; }

-            public string EventArgsType { get; set; }

-            public EventFieldInfo EventFieldInfo { get; set; }

-            public ulong EventHandlerId { get; set; }

-        }
-    }
+    public class TouchEventArgs : EventArgs {
+        public TouchEventArgs();
+        public bool AltKey { get; set; }
+        public TouchPoint[] ChangedTouches { get; set; }
+        public bool CtrlKey { get; set; }
+        public long Detail { get; set; }
+        public bool MetaKey { get; set; }
+        public bool ShiftKey { get; set; }
+        public TouchPoint[] TargetTouches { get; set; }
+        public TouchPoint[] Touches { get; set; }
+        public string Type { get; set; }
+    }
+    public class TouchPoint {
+        public TouchPoint();
+        public double ClientX { get; set; }
+        public double ClientY { get; set; }
+        public long Identifier { get; set; }
+        public double PageX { get; set; }
+        public double PageY { get; set; }
+        public double ScreenX { get; set; }
+        public double ScreenY { get; set; }
+    }
+    public static class WebEventCallbackFactoryEventArgsExtensions {
+        public static EventCallback<ClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ClipboardEventArgs> callback);
+        public static EventCallback<DragEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<DragEventArgs> callback);
+        public static EventCallback<ErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ErrorEventArgs> callback);
+        public static EventCallback<FocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<FocusEventArgs> callback);
+        public static EventCallback<KeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<KeyboardEventArgs> callback);
+        public static EventCallback<MouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<MouseEventArgs> callback);
+        public static EventCallback<PointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<PointerEventArgs> callback);
+        public static EventCallback<ProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<ProgressEventArgs> callback);
+        public static EventCallback<TouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<TouchEventArgs> callback);
+        public static EventCallback<WheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Action<WheelEventArgs> callback);
+        public static EventCallback<ClipboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ClipboardEventArgs, Task> callback);
+        public static EventCallback<DragEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<DragEventArgs, Task> callback);
+        public static EventCallback<ErrorEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ErrorEventArgs, Task> callback);
+        public static EventCallback<FocusEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<FocusEventArgs, Task> callback);
+        public static EventCallback<KeyboardEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<KeyboardEventArgs, Task> callback);
+        public static EventCallback<MouseEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<MouseEventArgs, Task> callback);
+        public static EventCallback<PointerEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<PointerEventArgs, Task> callback);
+        public static EventCallback<ProgressEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<ProgressEventArgs, Task> callback);
+        public static EventCallback<TouchEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<TouchEventArgs, Task> callback);
+        public static EventCallback<WheelEventArgs> Create(this EventCallbackFactory factory, object receiver, Func<WheelEventArgs, Task> callback);
+    }
+    public class WheelEventArgs : MouseEventArgs {
+        public WheelEventArgs();
+        public long DeltaMode { get; set; }
+        public double DeltaX { get; set; }
+        public double DeltaY { get; set; }
+        public double DeltaZ { get; set; }
+    }
 }
```

