# .NET Core 3.1.19 - September 14, 2021

The .NET Core Runtime 3.1.19, .NET Core SDK 3.1.413 and [.NET Core SDK 3.1.119](3.1.119.md) releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.413
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.19 is being deployed to Azure App Services and the deployment is expected to complete later in September 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.413](#downloads) |
| Windows | Visual Studio 2019 version 16.4 | [3.1.119](3.1.119.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.19 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release
* [corefx](https://github.com/dotnet/corefx/pull/43099)


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6687](https://github.com/dotnet/core/issues/6687) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.win-x86 | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.19.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.19.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.19.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.rhel.6-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.19.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.19.nupkg
Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.rhel.6-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.19.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.19.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.19.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.19.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.19.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.19.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.19.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.19.nupkg
System.Data.SqlClient | 4.8.3.nupkg
Microsoft.NETCore.Platforms | 3.1.8.nupkg
Microsoft.Windows.Compatibility | 3.1.2.nupkg
Microsoft.Extensions.Identity.Core | 3.1.19.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.19.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.19.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.19.nupkg
Microsoft.AspNetCore.TestHost | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.19.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.19.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.19.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.19.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.19.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.19.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.19.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.19.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.19.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.19.nupkg
dotnet-sql-cache | 3.1.19.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.19.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.19.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.19.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.19.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.19.nupkg
Microsoft.dotnet-openapi | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.19.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.19.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.19.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.19.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.19.nupkg
Microsoft.AspNetCore.Components | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.19.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.19.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.19.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.19.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.19.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.19.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.19.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.19.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.19.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.19.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.19.nupkg
Microsoft.AspNetCore.Owin | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.19.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.19.nupkg
Microsoft.AspNetCore.Authorization | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.19.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.19.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.19.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.19.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.19.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.19.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.19.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.19.nupkg
Microsoft.AspNetCore.Metadata | 3.1.19.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.19.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.19.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.19.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.19.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.19.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.19.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.19.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.19.nupkg
Microsoft.AspNetCore.Razor.Language | 3.1.19.nupkg
Microsoft.NET.Sdk.Razor | 3.1.19.nupkg
Microsoft.CodeAnalysis.Razor | 3.1.19.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.19.nupkg
Microsoft.Data.Sqlite | 3.1.19.nupkg
dotnet-ef | 3.1.19.nupkg
Microsoft.EntityFrameworkCore | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.19.nupkg
Microsoft.Data.Sqlite.Core | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.19.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.19.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.19.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.19.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.19.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.19.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.19.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.19.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.19.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.19.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.19.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.19.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.19.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.19.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.19.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.19.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.19.nupkg
Microsoft.Extensions.Http.Polly | 3.1.19.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.19.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.19.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.19.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.Configuration | 3.1.19.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.19.nupkg
Microsoft.Extensions.Primitives | 3.1.19.nupkg
Microsoft.Extensions.ObjectPool | 3.1.19.nupkg
Microsoft.Extensions.Logging.Console | 3.1.19.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.19.nupkg
Microsoft.JSInterop | 3.1.19.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.19.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.19.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.WebEncoders | 3.1.19.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.19.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.19.nupkg
Microsoft.Extensions.Localization | 3.1.19.nupkg
Microsoft.Extensions.Logging | 3.1.19.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.19.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.19.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.19.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.19.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.19.nupkg
Microsoft.Extensions.Options | 3.1.19.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.19.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.19.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.19.nupkg
Microsoft.Extensions.Hosting | 3.1.19.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.19.nupkg
Microsoft.Extensions.Http | 3.1.19.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.19.nupkg



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.19/3.1.19.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.19-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.19-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/september-2021-updates/



[//]: # ( Runtime 3.1.19)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8e1ca0b4-88fe-4267-b242-ff2a79ab5dc0/b488c8ad7f025ae090a40d5f6bef2a13/dotnet-runtime-3.1.19-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37373d1a-48c1-4f53-9456-a09b6b1ac622/f2f0b82797164e090b0b657d0d1029b6/dotnet-runtime-3.1.19-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90eb6b76-6d34-445c-8443-be0cf00ff95f/bf5f85201292700d65d52942db3f86ae/dotnet-runtime-3.1.19-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/509b0445-4f9e-4775-8de9-4385fa516970/d669141bab879a464b12453f5a940f4a/dotnet-runtime-3.1.19-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2600fa33-3746-4ab2-917f-f7dad2eb2e46/8b02443c004709e2ced7634f7ffae7ac/dotnet-runtime-3.1.19-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5a700564-f1a9-4593-ac5a-a62aa66b284d/000c8c713200ddd535e1ee9ba18abf95/dotnet-runtime-3.1.19-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a58994d-6b88-412b-b9e6-d69c1bdcff18/3134d8545935802addd2cd307c9a6ba9/dotnet-runtime-3.1.19-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/520f0dd2-9898-42de-bd43-754a6653e48d/be41ce797813c021c536a96978a6ebdd/dotnet-runtime-3.1.19-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/be3014b3-8294-4152-9700-a35a8722c45b/e846545cbe6d18578ad48ebd448e09f3/dotnet-runtime-3.1.19-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b94ae83-f888-46eb-8953-37477e682c32/90359347f81673d211ada139bd75e8d7/dotnet-runtime-3.1.19-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/97b99278-6781-4dc1-9b3c-e82623a37e90/171363528a15b611b284ba6c9020f5ec/dotnet-runtime-3.1.19-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/832135ee-2a85-484a-94cb-4e60178b013a/2384b7bc84ed5f20055d8329701a61cd/dotnet-runtime-3.1.19-win-x86.zip

[//]: # ( WindowsDesktop 3.1.19)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/411e36fb-e1c7-4158-9464-0a473ec12a90/9b564480c7e693f3a297e83e73c02586/windowsdesktop-runtime-3.1.19-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/99810b85-b4cf-4832-9d8e-c83fa4a9561f/b6bd6966b51d8b767dcf8cb3dc0b1854/windowsdesktop-runtime-3.1.19-win-x86.exe

[//]: # ( ASP 3.1.19)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/151dda42-4bbe-4a05-a3bf-ccb5803a2a28/8e0b0ae365850d455efbf2afcd7c6768/aspnetcore-runtime-3.1.19-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/05c0293f-fabb-4d0a-926b-34f28c3ae4f0/b6666e2c4838ff24fb27447ee8437291/aspnetcore-runtime-3.1.19-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8f4ab8f1-3377-4b44-9db4-9cf0c81680b9/fa4909431cf7856940d4542feddde23c/aspnetcore-runtime-3.1.19-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd2acf48-7ff8-42f0-bbdd-54503a65fc4f/6bfbd27b93d427837c1e13e9b57fa14c/aspnetcore-runtime-3.1.19-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7a050aa5-7842-4bfa-a1c9-67c6c5995ea9/5592f443610943d5ca738ae92309dfab/aspnetcore-runtime-3.1.19-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d8fc8a1f-8d5f-4ab9-b847-5a265231987f/f634e0332753e0a436d16c7a9e0614dc/aspnetcore-runtime-3.1.19-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/db611006-9e2e-4cc1-98e9-faae44f19078/20ccaa877e78f78a77d80700d933a6de/aspnetcore-runtime-3.1.19-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/59e458f4-37b9-4600-864b-b03a31914579/5466cd8d666d4fb277c534cfd2aea3bd/aspnetcore-runtime-3.1.19-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/931d585f-d14b-4714-93e7-b6c648b2aabd/8040f6c391002ae09b3e79662033eeb1/aspnetcore-runtime-3.1.19-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/30ed5447-b7e2-433c-8af0-aad77e125d9e/dbc3195404a6e98ed1a9a751b91846f3/aspnetcore-runtime-3.1.19-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/85a1e3cf-6aed-43b5-9e25-d09aa30612a9/c3efc480c2affc0adf73f2d7ab3efd7d/aspnetcore-runtime-3.1.19-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/c154f72b-dcaf-4852-8fbe-20f0f3c779a7/91c7e664a755fb3142740f14c5c96ea7/dotnet-hosting-3.1.19-win.exe

[//]: # ( SDK 3.1.413)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40edd52f-b1ca-4f0c-8d50-34433202ce9d/2b8f5b881c239a706f271f010e56159c/dotnet-sdk-3.1.413-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dfd0ad22-3e47-432f-9aa1-f65b11a2ced2/d096c5d1561732c1658543fa8fb7a31f/dotnet-sdk-3.1.413-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57d5859a-f302-408d-95b0-8ab2cbcdb431/db0a869ce50247ca92cdc03a52d4a8a7/dotnet-sdk-3.1.413-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/70d12135-d65f-4f4c-9d96-a6ac0251fb1b/57856b7654e338027cfb53552b2c4d46/dotnet-sdk-3.1.413-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7fb6a24f-9528-4db5-9145-a42b7c2fb1a9/a895ce082c7d27dc23e534d25b9d3e28/dotnet-sdk-3.1.413-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c11490f1-c850-44cb-9229-513fc444c47e/9e421a6823f833b04403fde27f77f97d/dotnet-sdk-3.1.413-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d2dc64b1-7416-4fc0-8e2b-be0d7d856326/28e16418fc2e760830bd22c730ccc88e/dotnet-sdk-3.1.413-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/62917420-49c6-415f-958e-82be09b291cb/ac6ca7b8ccfb4602280660a27e289c6f/dotnet-sdk-3.1.413-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/70062b11-491c-403c-91db-9d84462ee292/5db435e39128cbb608e76bf5111ab3dc/dotnet-sdk-3.1.413-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/587d67c3-393e-4915-b9c4-5dda816d4945/068c1fe53054c217290a8980f8c49b91/dotnet-sdk-3.1.413-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0ccbbe4c-a6cc-442d-b81d-26fdf0ad67e9/742749e5c907162356f5b9ab9edd8efa/dotnet-sdk-3.1.413-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dcc51735-2fb2-4361-8fe7-4413f2bcc897/ad7be77e83d3599a4233ac7ed2061f08/dotnet-sdk-3.1.413-win-x86.zip
