# .NET Core 3.1.21 - November 08 , 2021

The .NET Core 3.1.21 and .NET Core SDK 3.1.415 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.415
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

### Azure App Services

* .NET Core 3.1.21 is being deployed to Azure App Services and the deployment is expected to complete later in November 2021.

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.415](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |



## Notable Changes

.NET Core 3.1.21 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release
* [WPF](https://github.com/dotnet/wpf/issues?q=milestone%3A3.1.21++is%3Aclosed+label%3Aservicing-approved+)
* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A3.1.21++is%3Aclosed+label%3Aservicing-approved+)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6884](https://github.com/dotnet/core/issues/6884) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.NETCore.App.Host.win-x86 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.linux-x64 | 3.1.21.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
Microsoft.NETCore.App.Host.linux-arm64 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.win-x86 | 3.1.21.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
Microsoft.NETCore.App.Host.linux-arm | 3.1.21.nupkg
Microsoft.NETCore.App.Host.linux-x64 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.win-arm64 | 3.1.21.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 3.1.21.nupkg
Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64 | 3.1.21.nupkg
Microsoft.NETCore.App.Host.win-arm | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.win-arm | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.win-x64 | 3.1.21.nupkg
Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
Microsoft.NETCore.App.Host.osx-x64 | 3.1.21.nupkg
Microsoft.NETCore.App.Host.win-x64 | 3.1.21.nupkg
Microsoft.NETCore.App.Host.win-arm64 | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.linux-arm | 3.1.21.nupkg
Microsoft.NETCore.App.Runtime.osx-x64 | 3.1.21.nupkg
Microsoft.NETCore.DotNetHost | 3.1.21.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 3.1.21.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64 | 3.1.21.nupkg
Microsoft.NETCore.DotNetAppHost | 3.1.21.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 3.1.21.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 3.1.21.nupkg
Microsoft.AspNetCore.SpaServices.Extensions | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 3.1.21.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Common | 3.1.21.nupkg
Microsoft.AspNetCore.Owin | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection.Extensions | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86 | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 3.1.21.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices | 3.1.21.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 3.1.21.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.Facebook | 3.1.21.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 3.1.21.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 3.1.21.nupkg
AspNetCoreRuntime.3.1.x64 | 3.1.21.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis | 3.1.21.nupkg
Microsoft.AspNetCore.JsonPatch | 3.1.21.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests | 3.1.21.nupkg
Microsoft.AspNetCore.Mvc.Testing | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 3.1.21.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.Twitter | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection | 3.1.21.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter | 3.1.21.nupkg
Microsoft.AspNetCore.Components.Forms | 3.1.21.nupkg
Microsoft.DotNet.Web.ItemTemplates | 3.1.21.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm | 3.1.21.nupkg
Microsoft.AspNetCore.TestHost | 3.1.21.nupkg
dotnet-sql-cache | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64 | 3.1.21.nupkg
Microsoft.AspNetCore.Metadata | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions | 3.1.21.nupkg
Microsoft.AspNetCore.Components.Authorization | 3.1.21.nupkg
Microsoft.Extensions.ApiDescription.Server | 3.1.21.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1 | 3.1.21.nupkg
AspNetCoreRuntime.3.1.x86 | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 3.1.21.nupkg
Microsoft.AspNetCore.Identity.UI | 3.1.21.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 3.1.21.nupkg
Microsoft.AspNetCore.Http.Connections.Common | 3.1.21.nupkg
Microsoft.AspNetCore.HeaderPropagation | 3.1.21.nupkg
Microsoft.AspNetCore.Http.Features | 3.1.21.nupkg
Microsoft.AspNetCore.SpaServices | 3.1.21.nupkg
Microsoft.AspNetCore.NodeServices | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.WsFederation | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.Certificate | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault | 3.1.21.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 3.1.21.nupkg
Microsoft.AspNetCore.Components.Analyzers | 3.1.21.nupkg
Microsoft.AspNetCore.Components | 3.1.21.nupkg
Microsoft.Extensions.Identity.Stores | 3.1.21.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1 | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64 | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64 | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm | 3.1.21.nupkg
Microsoft.AspNetCore.Http.Connections.Client | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Client | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.Google | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI | 3.1.21.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation | 3.1.21.nupkg
Microsoft.AspNetCore.Connections.Abstractions | 3.1.21.nupkg
Microsoft.AspNetCore.Cryptography.Internal | 3.1.21.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration | 3.1.21.nupkg
Microsoft.Extensions.Identity.Core | 3.1.21.nupkg
Microsoft.Extensions.ApiDescription.Client | 3.1.21.nupkg
Microsoft.dotnet-openapi | 3.1.21.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json | 3.1.21.nupkg
Microsoft.AspNetCore.SignalR.Client.Core | 3.1.21.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 3.1.21.nupkg
Microsoft.AspNetCore.Authentication.Negotiate | 3.1.21.nupkg
Microsoft.AspNetCore.Authorization | 3.1.21.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64 | 3.1.21.nupkg
Microsoft.AspNetCore.Components.Web | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.21.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.21.nupkg
Microsoft.DotNet.Common.ItemTemplates | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0 | 3.1.21.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0 | 3.1.21.nupkg
System.Drawing.Common | 4.7.3.nupkg
Microsoft.EntityFrameworkCore.Relational | 3.1.21.nupkg
dotnet-ef | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Abstractions | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Design | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Proxies | 3.1.21.nupkg
Microsoft.Data.Sqlite | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Cosmos | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Tools | 3.1.21.nupkg
Microsoft.Data.Sqlite.Core | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Analyzers | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.SqlServer | 3.1.21.nupkg
Microsoft.EntityFrameworkCore | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.InMemory | 3.1.21.nupkg
Microsoft.EntityFrameworkCore.Sqlite | 3.1.21.nupkg
Microsoft.Extensions.FileProviders.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.DependencyInjection | 3.1.21.nupkg
Microsoft.Extensions.Configuration.UserSecrets | 3.1.21.nupkg
Microsoft.Extensions.Configuration.FileExtensions | 3.1.21.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis | 3.1.21.nupkg
Microsoft.Extensions.Configuration.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.FileProviders.Embedded | 3.1.21.nupkg
Microsoft.Extensions.DiagnosticAdapter | 3.1.21.nupkg
Microsoft.Extensions.Configuration.Xml | 3.1.21.nupkg
Microsoft.Extensions.Configuration.KeyPerFile | 3.1.21.nupkg
Microsoft.Extensions.Configuration.Ini | 3.1.21.nupkg
Microsoft.Extensions.Caching.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.WebEncoders | 3.1.21.nupkg
Microsoft.Extensions.FileSystemGlobbing | 3.1.21.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions | 3.1.21.nupkg
Microsoft.Extensions.Logging.EventSource | 3.1.21.nupkg
Microsoft.Extensions.Logging.Console | 3.1.21.nupkg
Microsoft.JSInterop | 3.1.21.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks | 3.1.21.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson | 3.1.21.nupkg
Microsoft.Extensions.Configuration.Json | 3.1.21.nupkg
Microsoft.Extensions.Primitives | 3.1.21.nupkg
Microsoft.Extensions.Logging.TraceSource | 3.1.21.nupkg
Microsoft.Extensions.Hosting.Systemd | 3.1.21.nupkg
Microsoft.Extensions.Http.Polly | 3.1.21.nupkg
Microsoft.Extensions.Localization.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables | 3.1.21.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault | 3.1.21.nupkg
Microsoft.Extensions.Logging.AzureAppServices | 3.1.21.nupkg
Microsoft.Extensions.Localization | 3.1.21.nupkg
Microsoft.Extensions.Hosting.WindowsServices | 3.1.21.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests | 3.1.21.nupkg
Microsoft.Extensions.Configuration.CommandLine | 3.1.21.nupkg
Microsoft.Extensions.Configuration | 3.1.21.nupkg
Microsoft.Extensions.Options | 3.1.21.nupkg
Microsoft.Extensions.ObjectPool | 3.1.21.nupkg
Microsoft.Extensions.Logging.EventLog | 3.1.21.nupkg
Microsoft.Extensions.Logging.Debug | 3.1.21.nupkg
Microsoft.Extensions.Hosting | 3.1.21.nupkg
Microsoft.Extensions.Hosting.Abstractions | 3.1.21.nupkg
Microsoft.Extensions.Http | 3.1.21.nupkg
Microsoft.Extensions.Logging | 3.1.21.nupkg
Microsoft.Extensions.Configuration.Binder | 3.1.21.nupkg
Microsoft.Extensions.FileProviders.Composite | 3.1.21.nupkg
Microsoft.Extensions.Caching.SqlServer | 3.1.21.nupkg
Microsoft.Extensions.Caching.Memory | 3.1.21.nupkg
Microsoft.Extensions.Options.DataAnnotations | 3.1.21.nupkg
Microsoft.Extensions.FileProviders.Physical | 3.1.21.nupkg
Microsoft.Extensions.Logging.Configuration | 3.1.21.nupkg
Microsoft.Extensions.Logging.Abstractions | 3.1.21.nupkg





[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.21/3.1.21.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.21-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.21-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/november-2021-updates/


[//]: # ( Runtime 3.1.21)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/283d08e5-e71b-404d-869c-e6ad820ade07/b46930dd45fd4d898c7f904fe33e566e/dotnet-runtime-3.1.21-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45b3ad17-6ce6-4cd6-a975-d4f152203750/c6df44d802c52e65ad5d9c783ccd46ab/dotnet-runtime-3.1.21-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4814aefe-00b9-4f5c-b71b-2f89114f8651/a3a73610ab69ac50d73a8766fd098e09/dotnet-runtime-3.1.21-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/75ccece0-e943-4564-837f-ce2dc2daa2b8/f35237bcdb87c74cae4c50b84fd11907/dotnet-runtime-3.1.21-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/286e526e-282b-47e5-afeb-4f99ee481972/495908d6a6019e47249bd05f8346aeb5/dotnet-runtime-3.1.21-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/517d8599-fcad-4cfc-b8b6-e82231e40006/e71454fe391ac353d72ddab6ff427294/dotnet-runtime-3.1.21-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3896eba4-4ef4-47a7-846c-8acb44b15feb/4920ee69b26772423edc686e499da061/dotnet-runtime-3.1.21-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/1340a54c-a2c7-493c-8d02-b720571e7d18/b72dce215842bafe54bfbaa64fbfcad7/dotnet-runtime-3.1.21-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7d4d91b4-fcdf-437f-9c03-92e098af2a5b/443004dc4756fa13035c38c0f12deb84/dotnet-runtime-3.1.21-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9162b33a-f585-4db6-bf9b-45046e75602f/d5620cb1c7afc16f9a8b01fe7e3cf06a/dotnet-runtime-3.1.21-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/55ceb5cc-4c3f-4955-97f2-a58b7b14eeb1/a64dd45182ff17ad52d401ef73aa5ba1/dotnet-runtime-3.1.21-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e2268b43-0b5c-47c0-8d69-92d0e67a7b7f/c58259f05b61fd271ad99337a4793a24/dotnet-runtime-3.1.21-win-x86.zip

[//]: # ( WindowsDesktop 3.1.21)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/3f56df9d-6dc0-4897-a49b-ea891f9ad0f4/076e353a29908c70e24ba8b8d0daefb8/windowsdesktop-runtime-3.1.21-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/edd0e0f3-2f0f-4420-8864-a1d0f6c669b6/4936c974bfd6edc5c43566678bf00278/windowsdesktop-runtime-3.1.21-win-x86.exe

[//]: # ( ASP 3.1.21)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9092f467-8a52-482b-9295-6870e0e7fa73/a1474c461720fee5d82ba8efcd7ea3ce/aspnetcore-runtime-3.1.21-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d245f70-4e8f-457a-9c4f-d4140136e496/56193e7de38e0f4101eb6f3fd2c60c41/aspnetcore-runtime-3.1.21-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b1b20d2-685e-4104-b036-54b696bd325e/7b70274ace6255bb18264ba622d05a61/aspnetcore-runtime-3.1.21-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6cd499bc-1bce-4f80-9ca4-41bccaed89e9/e4d72c6ced6598b1cc005302b992214e/aspnetcore-runtime-3.1.21-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c4565012-97e8-4a5a-9edf-8d6c94f0ac5c/dd227c01d532bcb731b026243a51f55f/aspnetcore-runtime-3.1.21-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd423a05-c133-464d-a117-d2e73d6dfeb5/a2d7c629802b8a283819a445a3024944/aspnetcore-runtime-3.1.21-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/53955e4e-6810-4b24-b502-bc718170cd50/8db81183932d16fa56eaf804fc7b0d3d/aspnetcore-runtime-3.1.21-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/445c533d-e537-445a-bbfd-fc5e51bd745d/cda0dfb3612031b0ecdeb8e86e4f23ea/aspnetcore-runtime-3.1.21-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/98a8eea7-ed93-4663-94fc-be1462091726/b59db628165e816b5d057fe0b9585e89/aspnetcore-runtime-3.1.21-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/45b5d393-4d3b-4ded-9ecb-85dda1216e0d/636b0535cc900316a67ca825589ee970/aspnetcore-runtime-3.1.21-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/890444f4-e4bb-481f-a77b-cafaecc061f0/1a32a9a2a961cc07ef6a246c34eaf4a1/aspnetcore-runtime-3.1.21-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/4f5c5cdc-1354-415b-a3a2-b5c94d6ca6eb/73841934839d13ba91407f3259a8d1b4/dotnet-hosting-3.1.21-win.exe

[//]: # ( SDK 3.1.415)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e401b906-4681-437b-a1c5-21a2d7e0f83c/824371926ae334ac264b91d8234b350c/dotnet-sdk-3.1.415-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a78a923-e891-40fe-88d2-4bff2c90519f/126bee4399caeabde4f34f4ace7f44e3/dotnet-sdk-3.1.415-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/254b4820-7917-4248-b353-a6350020be96/19ceb70a7b825f866761c4e2ae0d6d3f/dotnet-sdk-3.1.415-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6425056e-bfd5-48be-8b00-223c03a4d0f3/08a801489b7f18e9e73a1378082fbe66/dotnet-sdk-3.1.415-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/27d3762d-02dc-4182-89f8-3e208e593a88/1e45544c3597f81c0504a47343875a96/dotnet-sdk-3.1.415-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e0fe8c99-e33c-4d75-bd4e-2478ed3ee35a/ff06e47afc7c13bdbbaa50a9713ac772/dotnet-sdk-3.1.415-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d663efa-2180-4562-8735-be11d8ba465d/605910e63a687d8c9e72ba108ffb1da4/dotnet-sdk-3.1.415-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/55b9a48c-26e2-4a9d-a8ac-487609a14667/f3d970f976e1a80b8afd2f90b048e368/dotnet-sdk-3.1.415-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a7555bf3-426c-499c-8431-ef3448c64da6/8d8f9cb4451564dcb86119c79ea3ee64/dotnet-sdk-3.1.415-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4065ce8d-ceaf-4465-929b-a8c0ca1594ea/53f72ba472e6c535579f1fba448cb538/dotnet-sdk-3.1.415-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a18e402d-2659-4587-be21-92bc2753e4db/ff18b94d7443c7e8e597e86e09da4185/dotnet-sdk-3.1.415-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/33e3dc3a-0c02-4f84-9f6a-e5f8f9000553/a7f7a10f22fb4c17c600439552c3e0aa/dotnet-sdk-3.1.415-win-x86.zip