# .NET Core 3.1.24 - April 12, 2022

.NET Core 3.1.24 and .NET Core SDK 3.1.418 releases are available for download. The latest 3.1 release is always listed at [.NET 3.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [Arm][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [Arm][aspnetcore-runtime-win-arm.zip] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz] \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] \|  [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] \| [Arm64 Alpine][aspnetcore-runtime-linux-musl-arm64.tar.gz] | - |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                          | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] | [Checksums][checksums-runtime] |

</br>
1. Includes the .NET Core and ASP.NET Core Runtimes.
</br>2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
3.1.418
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET Core SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Core Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Core Runtime Dependencies

## Visual Studio Compatibility

**Visual Studio compatibility:** .NET Core 3.1 requires Visual Studio 2019 16.4 or above to take full advantage of all its features. .NET Core 3.1 won't work properly in earlier versions of Visual Studio. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.7 | [3.1.418](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://docs.microsoft.com/visualstudio/mac/net-core-support) |


## Notable Changes
.NET Core 3.1.24 release carries non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../3.1-known-issues.md)

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/pulls?q=milestone%3A3.1.24+is%3Aclosed+label%3Aservicing-approved)
* [CoreFx](https://github.com/dotnet/corefx/pulls?q=milestone%3A3.1.24+is%3Aclosed+label%3Aservicing-approved)
* [Winforms](https://github.com/dotnet/winforms/pulls?q=milestone%3A3.1.24+is%3Aclosed+label%3Aservicing-approved)
* [WPF](https://github.com/dotnet/wpf/pulls?q=milestone%3A3.1.24+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7362](https://github.com/dotnet/core/issues/7362) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/3.1/3.1.24/3.1.24.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.24-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.1.24-sha.txt

[linux-setup]: https://docs.microsoft.com/dotnet/core/install/linux

[dotnet-blog]:   https://devblogs.microsoft.com/dotnet/april-2022-update/

## Packages updated in this release:

Package name | Version
:----------- | :------------------
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 3.1.24.nupkg
Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
Microsoft.NETCore.App.Host.win-arm| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 3.1.24.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
Microsoft.NETCore.App.Host.linux-arm| 3.1.24.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 3.1.24.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 3.1.24.nupkg
Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 3.1.24.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 3.1.24.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 3.1.24.nupkg
Microsoft.NETCore.App.Host.osx-x64| 3.1.24.nupkg
Microsoft.NETCore.App.Host.win-x64| 3.1.24.nupkg
Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 3.1.24.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 3.1.24.nupkg
Microsoft.NETCore.App.Host.linux-x64| 3.1.24.nupkg
Microsoft.NETCore.App.Host.win-arm64| 3.1.24.nupkg
Microsoft.NETCore.App.Host.win-x86| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 3.1.24.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 3.1.24.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 3.1.24.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 3.1.24.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 3.1.24.nupkg
Microsoft.Extensions.Identity.Stores| 3.1.24.nupkg
Microsoft.DotNet.Web.ProjectTemplates.3.1| 3.1.24.nupkg
Microsoft.Extensions.ApiDescription.Server| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 3.1.24.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 3.1.24.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 3.1.24.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 3.1.24.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 3.1.24.nupkg
AspNetCoreRuntime.3.1.x86| 3.1.24.nupkg
Microsoft.dotnet-openapi| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 3.1.24.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 3.1.24.nupkg
Microsoft.AspNetCore.Components.Analyzers| 3.1.24.nupkg
Microsoft.DotNet.Web.ItemTemplates| 3.1.24.nupkg
Microsoft.AspNetCore.TestHost| 3.1.24.nupkg
dotnet-sql-cache| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 3.1.24.nupkg
Microsoft.AspNetCore.Metadata| 3.1.24.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 3.1.24.nupkg
Microsoft.AspNetCore.Authorization| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 3.1.24.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 3.1.24.nupkg
Microsoft.AspNetCore.Components.Web| 3.1.24.nupkg
Microsoft.Extensions.Identity.Core| 3.1.24.nupkg
Microsoft.Extensions.ApiDescription.Client| 3.1.24.nupkg
Microsoft.AspNetCore.Identity.UI| 3.1.24.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 3.1.24.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 3.1.24.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 3.1.24.nupkg
Microsoft.AspNetCore.Owin| 3.1.24.nupkg
Microsoft.AspNetCore.HeaderPropagation| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection.AzureStorage| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 3.1.24.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 3.1.24.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 3.1.24.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 3.1.24.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.3.1| 3.1.24.nupkg
AspNetCoreRuntime.3.1.x64| 3.1.24.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests| 3.1.24.nupkg
Microsoft.AspNetCore.NodeServices| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 3.1.24.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 3.1.24.nupkg
Microsoft.AspNetCore.Components.Authorization| 3.1.24.nupkg
Microsoft.AspNetCore.Components| 3.1.24.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 3.1.24.nupkg
Microsoft.AspNetCore.JsonPatch| 3.1.24.nupkg
Microsoft.AspNetCore.Http.Features| 3.1.24.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 3.1.24.nupkg
Microsoft.AspNetCore.SpaServices| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 3.1.24.nupkg
Microsoft.AspNetCore.Mvc.Testing| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Client| 3.1.24.nupkg
Microsoft.AspNetCore.SignalR.Common| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 3.1.24.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 3.1.24.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 3.1.24.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 3.1.24.nupkg
Microsoft.AspNetCore.Authentication.Google| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection.AzureKeyVault| 3.1.24.nupkg
Microsoft.AspNetCore.DataProtection| 3.1.24.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 3.1.24.nupkg
Microsoft.AspNetCore.Components.Forms| 3.1.24.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 3.1.24.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.0| 3.1.24.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.1| 3.1.24.nupkg
Microsoft.DotNet.Common.ProjectTemplates.3.1| 3.1.24.nupkg
Microsoft.DotNet.Common.ProjectTemplates.1.x| 3.1.24.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.0| 3.1.24.nupkg
Microsoft.DotNet.Common.ProjectTemplates.2.2| 3.1.24.nupkg
Microsoft.DotNet.Common.ItemTemplates| 3.1.24.nupkg
Microsoft.AspNetCore.Razor.Language| 3.1.24.nupkg
Microsoft.CodeAnalysis.Razor| 3.1.24.nupkg
Microsoft.NET.Sdk.Razor| 3.1.24.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Tools| 3.1.24.nupkg
Microsoft.Data.Sqlite| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Design| 3.1.24.nupkg
Microsoft.Data.Sqlite.Core| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.InMemory| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 3.1.24.nupkg
dotnet-ef| 3.1.24.nupkg
Microsoft.EntityFrameworkCore| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Relational| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Proxies| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 3.1.24.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 3.1.24.nupkg
Microsoft.Extensions.DiagnosticAdapter| 3.1.24.nupkg
Microsoft.Extensions.DependencyInjection.Specification.Tests| 3.1.24.nupkg
Microsoft.Extensions.Configuration.NewtonsoftJson| 3.1.24.nupkg
Microsoft.Extensions.Configuration.FileExtensions| 3.1.24.nupkg
Microsoft.Extensions.Caching.SqlServer| 3.1.24.nupkg
Microsoft.Extensions.WebEncoders| 3.1.24.nupkg
Microsoft.Extensions.Logging.TraceSource| 3.1.24.nupkg
Microsoft.Extensions.Logging.EventLog| 3.1.24.nupkg
Microsoft.Extensions.Logging.Console| 3.1.24.nupkg
Microsoft.Extensions.Hosting| 3.1.24.nupkg
Microsoft.Extensions.Hosting.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.Logging.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.Configuration.EnvironmentVariables| 3.1.24.nupkg
Microsoft.Extensions.Configuration.CommandLine| 3.1.24.nupkg
Microsoft.Extensions.Caching.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.Configuration.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.FileProviders.Embedded| 3.1.24.nupkg
Microsoft.Extensions.Options.DataAnnotations| 3.1.24.nupkg
Microsoft.Extensions.Options| 3.1.24.nupkg
Microsoft.Extensions.Logging.Configuration| 3.1.24.nupkg
Microsoft.Extensions.Hosting.Systemd| 3.1.24.nupkg
Microsoft.Extensions.Localization| 3.1.24.nupkg
Microsoft.JSInterop| 3.1.24.nupkg
Microsoft.Extensions.FileProviders.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.DependencyInjection.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.Configuration.UserSecrets| 3.1.24.nupkg
Microsoft.Extensions.Configuration.Json| 3.1.24.nupkg
Microsoft.Extensions.Configuration.Binder| 3.1.24.nupkg
Microsoft.Extensions.FileProviders.Composite| 3.1.24.nupkg
Microsoft.Extensions.Configuration.AzureKeyVault| 3.1.24.nupkg
Microsoft.Extensions.FileSystemGlobbing| 3.1.24.nupkg
Microsoft.Extensions.Http| 3.1.24.nupkg
Microsoft.Extensions.Localization.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 3.1.24.nupkg
Microsoft.Extensions.Configuration.Xml| 3.1.24.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 3.1.24.nupkg
Microsoft.Extensions.Configuration| 3.1.24.nupkg
Microsoft.Extensions.Caching.Memory| 3.1.24.nupkg
Microsoft.Extensions.Options.ConfigurationExtensions| 3.1.24.nupkg
Microsoft.Extensions.Logging.EventSource| 3.1.24.nupkg
Microsoft.Extensions.FileProviders.Physical| 3.1.24.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 3.1.24.nupkg
Microsoft.Extensions.Http.Polly| 3.1.24.nupkg
Microsoft.Extensions.Logging| 3.1.24.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 3.1.24.nupkg
Microsoft.Extensions.DependencyInjection| 3.1.24.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 3.1.24.nupkg
Microsoft.Extensions.Configuration.Ini| 3.1.24.nupkg
Microsoft.Extensions.Primitives| 3.1.24.nupkg
Microsoft.Extensions.ObjectPool| 3.1.24.nupkg
Microsoft.Extensions.Logging.Debug| 3.1.24.nupkg
Microsoft.Extensions.Hosting.WindowsServices| 3.1.24.nupkg



[//]: # ( Runtime 3.1.24)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e0dabc5a-7333-4c21-9117-00c698ff41e4/bc9bd80f8212cd1085fc7445c3fb8151/dotnet-runtime-3.1.24-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/28ba3e33-7de8-4f6f-91d0-0933c7d7abde/55f897530345e84a510e6e6c4c01d2a9/dotnet-runtime-3.1.24-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a2e83c48-f769-4650-97f9-b2e46cd94e48/7f204fa03aead28d07e4cd8f78a0bfb4/dotnet-runtime-3.1.24-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/76f93738-f1c8-4c84-b77b-2e23911ec065/59a15bd3f1352b55840a2bd15093d1fc/dotnet-runtime-3.1.24-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b5b39bd-27f6-4788-9e24-1f3b5d2bd4d2/3c65d1d1c5a57a0a3dbfe80ee512981b/dotnet-runtime-3.1.24-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5fcf68d8-11ca-4161-a698-c8dfff279701/0fd6e66e3fc030ca38e63744e6c003a9/dotnet-runtime-3.1.24-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/817be755-f428-40ed-a645-d3c8e6b31f3d/17ecf54262c05edf5e41e5f98775d1c3/dotnet-runtime-3.1.24-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/e93d7f0d-f9d8-49ed-89b2-5ac3de0bf326/a44521b909bb86cd295cc521a9ff182a/dotnet-runtime-3.1.24-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2853878f-6a7b-472d-bd70-a6ef81babf55/16066a594cf3273d9cb004561e3fea5a/dotnet-runtime-3.1.24-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0d95a759-3b1c-419a-8af4-680ed902ef7e/83ec71a02556da0d0b4a37d6f8466fcf/dotnet-runtime-3.1.24-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ef6e674c-f33e-41db-90a1-af92a815d2e1/509285f9212cbbf6fde3d35b213bc80d/dotnet-runtime-3.1.24-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2f8b0086-66ba-48ff-928f-91272415aa6e/2ab80f432e60ed6a44608e160f2a1b8d/dotnet-runtime-3.1.24-win-x86.zip

[//]: # ( WindowsDesktop 3.1.24)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c561eb57-4bf5-4bf4-aa3c-bd6dd0342c6a/5257304cf597d41ac6369c02813412c6/windowsdesktop-runtime-3.1.24-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/510706ca-1040-4fb8-934b-f28af4fa522a/92919ca73e073d210a8b2e76c5172b25/windowsdesktop-runtime-3.1.24-win-x86.exe

[//]: # ( ASP 3.1.24)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b3ec74f2-38e7-4e91-8e95-692aba5db391/03399b889cb0c8f53740680b48628855/aspnetcore-runtime-3.1.24-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3196b061-a4aa-45f6-a68b-e6ddc0cca170/1072dbc1e493f057bb4c1a5ae14e0963/aspnetcore-runtime-3.1.24-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd6a91a1-cb76-4e18-a330-e2830e9a083a/cb5b3adacf1444a3dc10e5a6dc0ca7b9/aspnetcore-runtime-3.1.24-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c32d801e-e254-4c26-9fb1-8fa9b29cebad/0b0703466fe546fd7849aa2b310c75c2/aspnetcore-runtime-3.1.24-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cedf0bef-c6f9-4b4a-88e9-8c7835ddb834/5aa57e202f43c2a72b8760be4b2cd008/aspnetcore-runtime-3.1.24-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd6b9423-eb7e-4e73-bcd7-93ec9eaf86f2/3eaf9f9870f2e06bc21939b8fbd66e04/aspnetcore-runtime-3.1.24-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/054d722b-6cd8-4abb-8af4-2ca32139727e/8413314d9ad3a2cc070e13dcc3cbe1af/aspnetcore-runtime-3.1.24-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0a913779-e465-4dd6-a50d-be5cac4796dd/c9c134d00cab1f0b5e023ba7d21b679b/aspnetcore-runtime-3.1.24-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/50a730aa-20c4-4c2d-aefd-6fd9ab9948f9/a9fb29878a09d4f7a091d1ff4f6ece37/aspnetcore-runtime-3.1.24-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/aa8d760a-e307-47aa-9d32-426b9e0f5db3/17274f6226f451f3a79bd7b3d915fd1c/aspnetcore-runtime-3.1.24-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2dd1295c-9330-4262-b09a-2ea0769bd92a/c3e8b359e22dc72ea15e367ef9028666/aspnetcore-runtime-3.1.24-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/fcedc990-c89d-4c23-a5b3-8380433db590/2ccf44671fe78d1a20ddefa9ef977b80/dotnet-hosting-3.1.24-win.exe

[//]: # ( SDK 3.1.418)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2bd849e-394c-48b0-9955-0d625d0aca50/60549bead15b74667ffc76f18aa05641/dotnet-sdk-3.1.418-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1533613a-1a50-48d0-bffe-341276bf95b3/d20d99d497f07b40f655b888319de311/dotnet-sdk-3.1.418-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e6a749f0-53e0-4ee7-9183-784ef76df042/5d37a1174e903a9c3bc49bb5e1b6bee9/dotnet-sdk-3.1.418-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9be72f63-270d-4b1f-9725-4dab8973c69d/62681fb4630de36e15011fa543c90908/dotnet-sdk-3.1.418-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/09245c01-e242-4620-8521-f8ff9320bdb6/325b6a726653ca782fa3fb634ecdbb49/dotnet-sdk-3.1.418-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f17f207a-238e-4694-bb47-07390495be24/635ab97f7f0e24e444b6f2be58f616e8/dotnet-sdk-3.1.418-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d97fc5b2-0314-46a2-ab9d-686c9e89ab91/626f99656f0904a641652f7ccb413dab/dotnet-sdk-3.1.418-osx-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/0097ae5b-024d-4a03-8eaf-77ae8718fb6a/88c3114195bd9ff6b9ed95767fc98cd2/dotnet-sdk-3.1.418-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/42778b69-3b6f-4542-a9ec-4eb5b1954dd6/eb2cb78b2827d75d6d2a7ab694a97298/dotnet-sdk-3.1.418-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/016a7e46-e070-4b1c-85a1-8947de4f2deb/f50d2c7c119e0dcd41989aaf3754074a/dotnet-sdk-3.1.418-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/22de2547-de0b-43ee-b930-e92b0f8ebcb9/6168162dcc73272b2ae1ebb6701f9a04/dotnet-sdk-3.1.418-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/78f97e8e-c460-407f-93b8-3c31c7160b27/202ac559498ff93029c66615165ce740/dotnet-sdk-3.1.418-win-x86.zip
