# .NET 5.0.16 - April 12, 2022

The .NET 5.0.16, .NET 5.0.407 SDK  and [.NET SDK 5.0.213](5.0.213.md) releases are available for download. The latest 5.0 release is always listed at [.NET 5.0 Releases](../README.md).


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
5.0.407
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 5.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Windows SDK Updates

.NET SDK 5.0.213 and 5.0.407 include performance improvements and bug fixes to the Windows SDK packages that provide access to Windows Runtime APIs. For more details, see the [C#/WinRT 1.6.1 release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.6.1.220314.1).

## Visual Studio Compatibility

You need [Visual Studio 16.8](https://visualstudio.microsoft.com) or later to use .NET 5.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 5.0 and C# 9.

## Notable Changes
.NET 5.0.16 release carries non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../5.0-known-issues.md)

### Additional fixes in this release

* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A5.0.16+is%3Aclosed+label%3Aservicing-approved+)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7362](https://github.com/dotnet/core/issues/7362) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/5.0/preview/5.0.16.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.16-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/5.0.16-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/april-2022-updates/

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A5.0.16xx+is%3Aclosed

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86| 5.0.16.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 5.0.16.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 5.0.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 5.0.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.win-arm| 5.0.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 5.0.16.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 5.0.16.nupkg
Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.linux-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.win-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.win-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.browser-wasm| 5.0.16.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.linux-arm| 5.0.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm| 5.0.16.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.win-x86| 5.0.16.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.osx-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 5.0.16.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 5.0.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 5.0.16.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 5.0.16.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 5.0.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 5.0.16.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 5.0.16.nupkg
Microsoft.NETCore.DotNetHostPolicy| 5.0.16.nupkg
Microsoft.NETCore.DotNetHostResolver| 5.0.16.nupkg
dotnet-sql-cache| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 5.0.16.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 5.0.16.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 5.0.16.nupkg
Microsoft.Authentication.WebAssembly.Msal| 5.0.16.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 5.0.16.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 5.0.16.nupkg
Microsoft.AspNetCore.Components.Web| 5.0.16.nupkg
Microsoft.AspNetCore.Components| 5.0.16.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 5.0.16.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 5.0.16.nupkg
Microsoft.AspNetCore.DataProtection| 5.0.16.nupkg
Microsoft.AspNetCore.Mvc.Testing| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.Google| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 5.0.16.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 5.0.16.nupkg
Microsoft.JSInterop.WebAssembly| 5.0.16.nupkg
Microsoft.JSInterop| 5.0.16.nupkg
Microsoft.Extensions.ObjectPool| 5.0.16.nupkg
Microsoft.Extensions.ApiDescription.Server| 5.0.16.nupkg
Microsoft.Extensions.Localization.Abstractions| 5.0.16.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 5.0.16.nupkg
Microsoft.AspNetCore.Owin| 5.0.16.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server| 5.0.16.nupkg
Microsoft.AspNetCore.Authorization| 5.0.16.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 5.0.16.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 5.0.16.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 5.0.16.nupkg
Microsoft.AspNetCore.JsonPatch| 5.0.16.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 5.0.16.nupkg
Microsoft.AspNetCore.HeaderPropagation| 5.0.16.nupkg
AspNetCoreRuntime.5.0.x64| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Client| 5.0.16.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Experimental.Quic| 5.0.16.nupkg
Microsoft.Extensions.WebEncoders| 5.0.16.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 5.0.16.nupkg
Microsoft.Extensions.Localization| 5.0.16.nupkg
Microsoft.Extensions.Identity.Core| 5.0.16.nupkg
Microsoft.DotNet.Web.ProjectTemplates.5.0| 5.0.16.nupkg
Microsoft.Extensions.ApiDescription.Client| 5.0.16.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 5.0.16.nupkg
Microsoft.AspNetCore.Components.Forms| 5.0.16.nupkg
Microsoft.AspNetCore.Components.Analyzers| 5.0.16.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 5.0.16.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 5.0.16.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 5.0.16.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 5.0.16.nupkg
Microsoft.AspNetCore.Http.Features| 5.0.16.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 5.0.16.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 5.0.16.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 5.0.16.nupkg
Microsoft.AspNetCore.TestHost| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 5.0.16.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 5.0.16.nupkg
Microsoft.AspNetCore.Razor.Language| 5.0.16.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.5.0| 5.0.16.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 5.0.16.nupkg
Microsoft.DotNet.Web.ItemTemplates| 5.0.16.nupkg
Microsoft.Extensions.Identity.Stores| 5.0.16.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 5.0.16.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 5.0.16.nupkg
Microsoft.AspNetCore.Metadata| 5.0.16.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 5.0.16.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 5.0.16.nupkg
AspNetCoreRuntime.5.0.x86| 5.0.16.nupkg
Microsoft.CodeAnalysis.Razor| 5.0.16.nupkg
Microsoft.dotnet-openapi| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 5.0.16.nupkg
Microsoft.AspNetCore.SignalR.Common| 5.0.16.nupkg
Microsoft.Extensions.FileProviders.Embedded| 5.0.16.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 5.0.16.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 5.0.16.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 5.0.16.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 5.0.16.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 5.0.16.nupkg
Microsoft.AspNetCore.Components.WebAssembly| 5.0.16.nupkg
Microsoft.AspNetCore.Components.Authorization| 5.0.16.nupkg
Microsoft.AspNetCore.Identity.UI| 5.0.16.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 5.0.16.nupkg
Microsoft.AspNetCore.Identity.Specification.Tests| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Relational| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Proxies| 5.0.16.nupkg
dotnet-ef| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 5.0.16.nupkg
Microsoft.Data.Sqlite| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Tools| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Design| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.InMemory| 5.0.16.nupkg
Microsoft.EntityFrameworkCore| 5.0.16.nupkg
Microsoft.Data.Sqlite.Core| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 5.0.16.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 5.0.16.nupkg


[//]: # ( Runtime 5.0.16)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2519cc01-d9b5-49b3-8c8a-616dd5b1a26a/d12111c61a2f9dd5de92bcb3e9a796a2/dotnet-runtime-5.0.16-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd28f2e1-3465-471c-9cef-7454ac84045c/a92b8f92aa2226b82c0e3e017b9d998f/dotnet-runtime-5.0.16-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3db37b52-731d-4a3d-92de-4ed2df3f4417/3b223f1008c9c4c2e5f3d064a3216154/dotnet-runtime-5.0.16-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bfbaadfa-0b07-41e6-8ec6-cec603dcca75/f60a4066845a9e478e52290a5daffd31/dotnet-runtime-5.0.16-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2790cdf0-d66a-42dd-8782-1d6d796d1685/59f782d53e4848ff7b7a8900efe6e708/dotnet-runtime-5.0.16-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ca089696-3890-4d4f-a0c9-969464d98957/a00e3c8fe65ba7d04f5ba32b53e843e2/dotnet-runtime-5.0.16-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0927672b-dd80-4ea4-a822-830a11e7b318/586b0004898a28a17ea7b8e1eae961bf/dotnet-runtime-5.0.16-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d71ccad0-68be-451e-9a41-c3dec9e5e76e/cdb89adc78b11236a556d03e4853baa2/dotnet-runtime-5.0.16-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/4b15ff0f-97aa-4870-8a72-7e9f2223037c/e41e44bc94854019155ee84efdb3200e/dotnet-runtime-5.0.16-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/dfaef85b-1af8-4491-b73b-55479e2f2e32/1124913ad2ab47c461d2eb15497b20a4/dotnet-runtime-5.0.16-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/68b7e1d6-8d11-4d49-926a-23fadb7d1948/e754199aff44f4bb6740f2f75c550724/dotnet-runtime-5.0.16-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7c711787-247a-476f-bd1a-0073173f1993/906bd1f9b1ef6bb7484514239b62887f/dotnet-runtime-5.0.16-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/121789df-fe97-4466-ac9a-a301342c1320/33c6b1133ba60345898afef5339028c3/dotnet-runtime-5.0.16-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d77c274f-774b-4351-a020-2885b70a02f8/2a590371b803dd568fcdc4cf3a284c5b/dotnet-runtime-5.0.16-win-x86.zip

[//]: # ( WindowsDesktop 5.0.16)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/fd645c2a-048f-4ae3-93b3-1c4619c6b688/ab9774426dcb86ce73bb7b778a2ae101/windowsdesktop-runtime-5.0.16-win-arm64.exe
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0fafe9b-958d-4bce-8ba4-6c67bd621644/a30d69b829fa1ad2312c7a75c111d821/windowsdesktop-runtime-5.0.16-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/426c1ce7-52d0-4002-af0c-76274a9be4b8/4c84f606549482e43b390122f12b291b/windowsdesktop-runtime-5.0.16-win-x86.exe

[//]: # ( ASP 5.0.16)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44d38590-0690-4b13-8b4d-7dae444e531d/ff6fe16b344c8f91fd86bdaa2f5ed904/aspnetcore-runtime-5.0.16-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7647ac91-2b3e-468a-b79f-7e42de4e8780/da52863dc49b8b0bdcc19ae98828f0cc/aspnetcore-runtime-5.0.16-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ae82136-619c-47b0-973e-fd6739ec5497/ca73398b1973d96be1bc9881e0955ee0/aspnetcore-runtime-5.0.16-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9951c969-2008-4cee-a4e0-5da93d0826ea/17840772b6769b4d30add0b5bfcd3b2f/aspnetcore-runtime-5.0.16-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ebe7eda-d977-4b32-ae08-dd5105d91d8f/a97e7de099ee9443176e651aaa4e3137/aspnetcore-runtime-5.0.16-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa584e5c-68f4-49e0-9a3d-79a52045b509/bc9bb7c98cfc975358b931cd5c2bf7a6/aspnetcore-runtime-5.0.16-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2c0c94a-ebe9-43db-8e29-eb3494ed1396/fe983fe0081a6f99e7078827b0528a13/aspnetcore-runtime-5.0.16-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0bb14e86-f182-4192-9e34-36fe253fe7b5/e944050767486bc53d6137f04a30fd05/aspnetcore-runtime-5.0.16-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8f5b182b-0c64-4ef2-907f-2a24bb3f6396/0e7e685b271b1a8eb2e41816f7004c80/aspnetcore-runtime-5.0.16-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3148cc92-65c1-4c86-af42-5d8f4552d288/cf5c57b8eb7ab20c3bfb4b3dafbc359a/aspnetcore-runtime-5.0.16-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fc2264d8-b8e4-400e-892d-5ea35893e01a/2810f8be21bd8584a3b932419e6f52d5/aspnetcore-runtime-5.0.16-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4f6cc26d-54c7-462d-847e-130b11a7ec26/fdc4ab1f0b49a0eb12d83b3f21962d2b/aspnetcore-runtime-5.0.16-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0e0baacc-0402-4e05-b8e8-c7a50f6efbe5/760f2852ea15c7717668d29f28c7454c/dotnet-hosting-5.0.16-win.exe

[//]: # ( SDK 5.0.407)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17588888-bd97-41e6-a1ef-9f1da6b8bdf6/ab16a7b0b82297f76abc793b5d187952/dotnet-sdk-5.0.407-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8be77687-0931-40e4-8e50-b1b4cb367277/eef06721da36a9395dbaf8cb879ba820/dotnet-sdk-5.0.407-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ab2de885-3a84-4e65-8d74-0f6af8244907/c8eda15a2bb3a24b16e8396de4fe2470/dotnet-sdk-5.0.407-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8cd11820-5b46-4fc2-86de-40b5772079d3/02ce53ad035d346547f198a1616f8b65/dotnet-sdk-5.0.407-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/450ec7bb-fedc-4c75-accf-1f100cc6ec23/073ba6dba1644379121fe860c34f77f3/dotnet-sdk-5.0.407-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06628342-344d-4524-ba62-e4762c0322f2/49fc2867cf4cfde29c721ff3b03cdf1b/dotnet-sdk-5.0.407-linux-x64.tar.gz
[dotnet-sdk-linux-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/904be501-69bb-4208-95b1-c55ea7891cf2/ae4fb223e6c697faad5ac2bf751b4d38/dotnet-sdk-5.0.407-linux-x64.zip
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b5abafee-b221-4765-857f-06c60e99d9e9/29d8b1073f7da4e19606ff4f116450f6/dotnet-sdk-5.0.407-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1db08b3b-af46-4b42-980a-b94c7e5b99ad/190764fa4d6a49543adbee32b5a86254/dotnet-sdk-5.0.407-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/66d5c472-e5c1-42c9-8b12-d67fb2df044e/6652d4694e5375f1e4365ad020509bee/dotnet-sdk-5.0.407-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/d9c3a3d6-fcfd-4f89-93ca-3d6128bbc679/30be42ed6a0c08c2d6a9b562b8ab412f/dotnet-sdk-5.0.407-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cc9263cb-9764-4d34-a792-054bebe3abed/08c84422ab3dfdbf53f8cc03f84e06be/dotnet-sdk-5.0.407-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f04e0f05-77a1-4939-89c4-9db7629d6a8a/04b32ea656fbcd178c5485f21bb91f72/dotnet-sdk-5.0.407-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0d7bef8a-240f-4bb5-ba91-d8ed41c1f65e/3d0e9b306d724a75c5740904c81d9f48/dotnet-sdk-5.0.407-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/55347cdd-18cc-44fd-a0cb-c3bd22e6dab6/19de4fac3cbe044062335f2eb73b6f14/dotnet-sdk-5.0.407-win-x86.zip
