# System.Buffers.Binary

``` diff
 namespace System.Buffers.Binary {
     public static class BinaryPrimitives {
+        public static double ReadDoubleBigEndian(ReadOnlySpan<byte> source);
+        public static double ReadDoubleLittleEndian(ReadOnlySpan<byte> source);
+        public static float ReadSingleBigEndian(ReadOnlySpan<byte> source);
+        public static float ReadSingleLittleEndian(ReadOnlySpan<byte> source);
+        public static bool TryReadDoubleBigEndian(ReadOnlySpan<byte> source, out double value);
+        public static bool TryReadDoubleLittleEndian(ReadOnlySpan<byte> source, out double value);
+        public static bool TryReadSingleBigEndian(ReadOnlySpan<byte> source, out float value);
+        public static bool TryReadSingleLittleEndian(ReadOnlySpan<byte> source, out float value);
+        public static bool TryWriteDoubleBigEndian(Span<byte> destination, double value);
+        public static bool TryWriteDoubleLittleEndian(Span<byte> destination, double value);
+        public static bool TryWriteSingleBigEndian(Span<byte> destination, float value);
+        public static bool TryWriteSingleLittleEndian(Span<byte> destination, float value);
+        public static void WriteDoubleBigEndian(Span<byte> destination, double value);
+        public static void WriteDoubleLittleEndian(Span<byte> destination, double value);
+        public static void WriteSingleBigEndian(Span<byte> destination, float value);
+        public static void WriteSingleLittleEndian(Span<byte> destination, float value);
     }
 }
```

