# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public class NetworkStream : Stream {
-        protected Socket Socket { get; }
+        public Socket Socket { get; }
     }
     public class Socket : IDisposable {
+        public Socket(SafeSocketHandle handle);
+        public static bool OSSupportsUnixDomainSockets { get; }
+        public int GetRawSocketOption(int optionLevel, int optionName, Span<byte> optionValue);
+        public void Listen();
+        public void SetRawSocketOption(int optionLevel, int optionName, ReadOnlySpan<byte> optionValue);
     }
     public class SocketAsyncEventArgs : EventArgs, IDisposable {
+        public SocketAsyncEventArgs(bool unsafeSuppressExecutionContextFlow);
     }
     public static class SocketTaskExtensions {
+        public static ValueTask ConnectAsync(this Socket socket, EndPoint remoteEP, CancellationToken cancellationToken);
+        public static ValueTask ConnectAsync(this Socket socket, IPAddress address, int port, CancellationToken cancellationToken);
+        public static ValueTask ConnectAsync(this Socket socket, IPAddress[] addresses, int port, CancellationToken cancellationToken);
+        public static ValueTask ConnectAsync(this Socket socket, string host, int port, CancellationToken cancellationToken);
     }
     public class TcpClient : IDisposable {
+        public ValueTask ConnectAsync(IPAddress address, int port, CancellationToken cancellationToken);
+        public ValueTask ConnectAsync(IPAddress[] addresses, int port, CancellationToken cancellationToken);
+        public ValueTask ConnectAsync(string host, int port, CancellationToken cancellationToken);
     }
 }
```

