# Microsoft.JSInterop.Implementation

``` diff
+namespace Microsoft.JSInterop.Implementation {
+    public class JSInProcessObjectReference : JSObjectReference, IAsyncDisposable, IDisposable, IJSInProcessObjectReference, IJSObjectReference {
+        protected internal JSInProcessObjectReference(JSInProcessRuntime jsRuntime, long id);
+        public void Dispose();
+        public TValue Invoke<TValue>(string identifier, params object[] args);
+    }
+    public class JSObjectReference : IAsyncDisposable, IJSObjectReference {
+        protected internal JSObjectReference(JSRuntime jsRuntime, long id);
+        protected internal long Id { get; }
+        public ValueTask DisposeAsync();
+        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+        public ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
+        protected void ThrowIfDisposed();
+    }
+}
```

