# System

``` diff
 namespace System {
     public static class Activator {
+        public static ObjectHandle CreateInstance(string assemblyName, string typeName);
+        public static ObjectHandle CreateInstance(string assemblyName, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public static ObjectHandle CreateInstance(string assemblyName, string typeName, object[] activationAttributes);
+        public static ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName);
+        public static ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public static ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, object[] activationAttributes);
     }
     public sealed class AppDomain : MarshalByRefObject {
+        public PermissionSet PermissionSet { get; }
+        public AppDomainSetup SetupInformation { get; }
+        public ObjectHandle CreateInstance(string assemblyName, string typeName);
+        public ObjectHandle CreateInstance(string assemblyName, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public ObjectHandle CreateInstance(string assemblyName, string typeName, object[] activationAttributes);
+        public object CreateInstanceAndUnwrap(string assemblyName, string typeName);
+        public object CreateInstanceAndUnwrap(string assemblyName, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public object CreateInstanceAndUnwrap(string assemblyName, string typeName, object[] activationAttributes);
+        public ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName);
+        public ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public ObjectHandle CreateInstanceFrom(string assemblyFile, string typeName, object[] activationAttributes);
+        public object CreateInstanceFromAndUnwrap(string assemblyFile, string typeName);
+        public object CreateInstanceFromAndUnwrap(string assemblyFile, string typeName, bool ignoreCase, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
+        public object CreateInstanceFromAndUnwrap(string assemblyFile, string typeName, object[] activationAttributes);
     }
+    public sealed class AppDomainSetup {
+        public string ApplicationBase { get; }
+        public string TargetFrameworkName { get; }
+    }
+    public ref struct ArgIterator {
+        public ArgIterator(RuntimeArgumentHandle arglist);
+        public unsafe ArgIterator(RuntimeArgumentHandle arglist, void* ptr);
+        public void End();
+        public override bool Equals(object o);
+        public override int GetHashCode();
+        public TypedReference GetNextArg();
+        public TypedReference GetNextArg(RuntimeTypeHandle rth);
+        public RuntimeTypeHandle GetNextArgType();
+        public int GetRemainingCount();
+    }
     public static class Console {
+        public static (int Left, int Top) GetCursorPosition();
     }
-    public readonly struct ConsoleKeyInfo
+    public readonly struct ConsoleKeyInfo : IEquatable<ConsoleKeyInfo>
     public static class Convert {
+        public static byte[] FromHexString(ReadOnlySpan<char> chars);
+        public static byte[] FromHexString(string s);
+        public static string ToHexString(byte[] inArray);
+        public static string ToHexString(byte[] inArray, int offset, int length);
+        public static string ToHexString(ReadOnlySpan<byte> bytes);
     }
-    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
+    public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable, ISerializable {
+        public Decimal(ReadOnlySpan<int> bits);
+        public static int GetBits(Decimal d, Span<int> destination);
+        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
+        public static bool TryGetBits(Decimal d, Span<int> destination, out int valuesWritten);
     }
     public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
+        public static string GetName<TEnum>(TEnum value) where TEnum : struct, Enum;
+        public static string[] GetNames<TEnum>() where TEnum : struct, Enum;
+        public static TEnum[] GetValues<TEnum>() where TEnum : struct, Enum;
+        public static bool IsDefined<TEnum>(TEnum value) where TEnum : struct, Enum;
     }
     public static class Environment {
+        public static int ProcessId { get; }
+        public static long TickCount64 { get; }
     }
     public class Exception : ISerializable {
-        public int HResult { get; protected set; }
+        public int HResult { get; set; }
     }
     public abstract class FormattableString : IFormattable {
+        public static string CurrentCulture(FormattableString formattable);
     }
     public static class GC {
+        public static T[] AllocateArray<T>(int length, bool pinned = false);
+        public static T[] AllocateUninitializedArray<T>(int length, bool pinned = false);
+        public static GCMemoryInfo GetGCMemoryInfo();
+        public static GCMemoryInfo GetGCMemoryInfo(GCKind kind);
+        public static long GetTotalAllocatedBytes(bool precise = false);
     }
+    public readonly struct GCGenerationInfo {
+        public long FragmentationAfterBytes { get; }
+        public long FragmentationBeforeBytes { get; }
+        public long SizeAfterBytes { get; }
+        public long SizeBeforeBytes { get; }
+    }
+    public enum GCKind {
+        Any = 0,
+        Background = 3,
+        Ephemeral = 1,
+        FullBlocking = 2,
+    }
+    public readonly struct GCMemoryInfo {
+        public bool Compacted { get; }
+        public bool Concurrent { get; }
+        public long FinalizationPendingCount { get; }
+        public long FragmentedBytes { get; }
+        public int Generation { get; }
+        public ReadOnlySpan<GCGenerationInfo> GenerationInfo { get; }
+        public long HeapSizeBytes { get; }
+        public long HighMemoryLoadThresholdBytes { get; }
+        public long Index { get; }
+        public long MemoryLoadBytes { get; }
+        public ReadOnlySpan<TimeSpan> PauseDurations { get; }
+        public double PauseTimePercentage { get; }
+        public long PinnedObjectsCount { get; }
+        public long PromotedBytes { get; }
+        public long TotalAvailableMemoryBytes { get; }
+        public long TotalCommittedBytes { get; }
+    }
+    public readonly struct Half : IComparable, IComparable<Half>, IEquatable<Half>, IFormattable {
+        public static Half Epsilon { get; }
+        public static Half MaxValue { get; }
+        public static Half MinValue { get; }
+        public static Half NaN { get; }
+        public static Half NegativeInfinity { get; }
+        public static Half PositiveInfinity { get; }
+        public int CompareTo(Half other);
+        public int CompareTo(object obj);
+        public bool Equals(Half other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool IsFinite(Half value);
+        public static bool IsInfinity(Half value);
+        public static bool IsNaN(Half value);
+        public static bool IsNegative(Half value);
+        public static bool IsNegativeInfinity(Half value);
+        public static bool IsNormal(Half value);
+        public static bool IsPositiveInfinity(Half value);
+        public static bool IsSubnormal(Half value);
+        public static bool operator ==(Half left, Half right);
+        public static explicit operator Half (double value);
+        public static explicit operator double (Half value);
+        public static explicit operator float (Half value);
+        public static explicit operator Half (float value);
+        public static bool operator >(Half left, Half right);
+        public static bool operator >=(Half left, Half right);
+        public static bool operator !=(Half left, Half right);
+        public static bool operator <(Half left, Half right);
+        public static bool operator <=(Half left, Half right);
+        public static Half Parse(ReadOnlySpan<char> s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider provider = null);
+        public static Half Parse(string s);
+        public static Half Parse(string s, NumberStyles style);
+        public static Half Parse(string s, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider provider = null);
+        public static Half Parse(string s, IFormatProvider provider);
+        public override string ToString();
+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider provider = null);
+        public static bool TryParse(ReadOnlySpan<char> s, NumberStyles style, IFormatProvider provider, out Half result);
+        public static bool TryParse(ReadOnlySpan<char> s, out Half result);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Half result);
+        public static bool TryParse(string s, out Half result);
+    }
-    public readonly struct IntPtr : IEquatable<IntPtr>, ISerializable {
+    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable {
+        public static IntPtr MaxValue { get; }
+        public static IntPtr MinValue { get; }
+        public int CompareTo(IntPtr value);
+        public int CompareTo(object value);
+        public bool Equals(IntPtr other);
+        public static IntPtr Parse(string s);
+        public static IntPtr Parse(string s, NumberStyles style);
+        public static IntPtr Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static IntPtr Parse(string s, IFormatProvider provider);
-        bool System.IEquatable<System.IntPtr>.Equals(IntPtr other);

+        public string ToString(IFormatProvider provider);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out IntPtr result);
+        public static bool TryParse(string s, out IntPtr result);
     }
     public sealed class LocalDataStoreSlot {
+        ~LocalDataStoreSlot();
     }
     public static class Math {
+        public const double Tau = 6.2831853071795862;
+        public static long BigMul(long a, long b, out long low);
+        public static ulong BigMul(ulong a, ulong b, out ulong low);
+        public static double BitDecrement(double x);
+        public static double BitIncrement(double x);
+        public static double CopySign(double x, double y);
+        public static double FusedMultiplyAdd(double x, double y, double z);
+        public static int ILogB(double x);
+        public static double Log2(double x);
+        public static double MaxMagnitude(double x, double y);
+        public static double MinMagnitude(double x, double y);
+        public static double ScaleB(double x, int n);
     }
     public static class MathF {
+        public const float Tau = 6.28318548f;
+        public static float BitDecrement(float x);
+        public static float BitIncrement(float x);
+        public static float CopySign(float x, float y);
+        public static float FusedMultiplyAdd(float x, float y, float z);
+        public static int ILogB(float x);
+        public static float Log2(float x);
+        public static float MaxMagnitude(float x, float y);
+        public static float MinMagnitude(float x, float y);
+        public static float ScaleB(float x, int n);
     }
     public static class MemoryExtensions {
+        public static bool Contains<T>(this ReadOnlySpan<T> span, T value) where T : IEquatable<T>;
+        public static bool Contains<T>(this Span<T> span, T value) where T : IEquatable<T>;
+        public static SpanRuneEnumerator EnumerateRunes(this ReadOnlySpan<char> span);
+        public static SpanRuneEnumerator EnumerateRunes(this Span<char> span);
+        public static int LastIndexOf(this ReadOnlySpan<char> span, ReadOnlySpan<char> value, StringComparison comparisonType);
+        public static void Sort<T, TComparer>(this Span<T> span, TComparer comparer) where TComparer : IComparer<T>;
+        public static void Sort<T>(this Span<T> span);
+        public static void Sort<T>(this Span<T> span, Comparison<T> comparison);
+        public static void Sort<TKey, TValue, TComparer>(this Span<TKey> keys, Span<TValue> items, TComparer comparer) where TComparer : IComparer<TKey>;
+        public static void Sort<TKey, TValue>(this Span<TKey> keys, Span<TValue> items);
+        public static void Sort<TKey, TValue>(this Span<TKey> keys, Span<TValue> items, Comparison<TKey> comparison);
+        public static Memory<char> Trim(this Memory<char> memory);
+        public static ReadOnlyMemory<char> Trim(this ReadOnlyMemory<char> memory);
+        public static Span<char> Trim(this Span<char> span);
+        public static Memory<T> Trim<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> Trim<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> Trim<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> Trim<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> Trim<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Memory<char> TrimEnd(this Memory<char> memory);
+        public static ReadOnlyMemory<char> TrimEnd(this ReadOnlyMemory<char> memory);
+        public static Span<char> TrimEnd(this Span<char> span);
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimEnd<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimEnd<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimEnd<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimEnd<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
+        public static Memory<char> TrimStart(this Memory<char> memory);
+        public static ReadOnlyMemory<char> TrimStart(this ReadOnlyMemory<char> memory);
+        public static Span<char> TrimStart(this Span<char> span);
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Memory<T> TrimStart<T>(this Memory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlyMemory<T> TrimStart<T>(this ReadOnlyMemory<T> memory, T trimElement) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static ReadOnlySpan<T> TrimStart<T>(this ReadOnlySpan<T> span, T trimElement) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> span, ReadOnlySpan<T> trimElements) where T : IEquatable<T>;
+        public static Span<T> TrimStart<T>(this Span<T> span, T trimElement) where T : IEquatable<T>;
     }
     public enum MidpointRounding {
+        ToNegativeInfinity = 3,
+        ToPositiveInfinity = 4,
+        ToZero = 2,
     }
     public sealed class ObsoleteAttribute : Attribute {
+        public string DiagnosticId { get; set; }
+        public string UrlFormat { get; set; }
     }
     public sealed class OperatingSystem : ICloneable, ISerializable {
+        public static bool IsAndroid();
+        public static bool IsAndroidVersionAtLeast(int major, int minor = 0, int build = 0, int revision = 0);
+        public static bool IsBrowser();
+        public static bool IsFreeBSD();
+        public static bool IsFreeBSDVersionAtLeast(int major, int minor = 0, int build = 0, int revision = 0);
+        public static bool IsIOS();
+        public static bool IsIOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsLinux();
+        public static bool IsMacOS();
+        public static bool IsMacOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsOSPlatform(string platform);
+        public static bool IsOSPlatformVersionAtLeast(string platform, int major, int minor = 0, int build = 0, int revision = 0);
+        public static bool IsTvOS();
+        public static bool IsTvOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsWatchOS();
+        public static bool IsWatchOSVersionAtLeast(int major, int minor = 0, int build = 0);
+        public static bool IsWindows();
+        public static bool IsWindowsVersionAtLeast(int major, int minor = 0, int build = 0, int revision = 0);
     }
     public enum PlatformID {
+        Other = 7,
     }
     public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
+        public static String Concat(ReadOnlySpan<char> str0, ReadOnlySpan<char> str1);
+        public static String Concat(ReadOnlySpan<char> str0, ReadOnlySpan<char> str1, ReadOnlySpan<char> str2);
+        public static String Concat(ReadOnlySpan<char> str0, ReadOnlySpan<char> str1, ReadOnlySpan<char> str2, ReadOnlySpan<char> str3);
+        public StringRuneEnumerator EnumerateRunes();
+        public static int GetHashCode(ReadOnlySpan<char> value);
+        public static int GetHashCode(ReadOnlySpan<char> value, StringComparison comparisonType);
+        public ref readonly char GetPinnableReference();
     }
     public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
-        bool System.Collections.IEqualityComparer.Equals(object x, object y);

-        int System.Collections.IEqualityComparer.GetHashCode(object obj);

     }
     public static class StringNormalizationExtensions {
-        public static bool IsNormalized(this string value);
+        public static bool IsNormalized(this string strInput);
-        public static bool IsNormalized(this string value, NormalizationForm normalizationForm);
+        public static bool IsNormalized(this string strInput, NormalizationForm normalizationForm);
-        public static string Normalize(this string value);
+        public static string Normalize(this string strInput);
-        public static string Normalize(this string value, NormalizationForm normalizationForm);
+        public static string Normalize(this string strInput, NormalizationForm normalizationForm);
     }
     public enum StringSplitOptions {
+        TrimEntries = 2,
     }
     public abstract class Type : MemberInfo, IReflect {
+        public bool IsAssignableTo(Type targetType);
+        public static Type MakeGenericSignatureType(Type genericTypeDefinition, params Type[] typeArguments);
     }
-    public readonly struct UIntPtr : IEquatable<UIntPtr>, ISerializable {
+    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable {
+        public static UIntPtr MaxValue { get; }
+        public static UIntPtr MinValue { get; }
+        public int CompareTo(object value);
+        public int CompareTo(UIntPtr value);
+        public bool Equals(UIntPtr other);
+        public static UIntPtr Parse(string s);
+        public static UIntPtr Parse(string s, NumberStyles style);
+        public static UIntPtr Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static UIntPtr Parse(string s, IFormatProvider provider);
-        bool System.IEquatable<System.UIntPtr>.Equals(UIntPtr other);

+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out UIntPtr result);
+        public static bool TryParse(string s, out UIntPtr result);
     }
     public sealed class WeakReference<T> : ISerializable where T : class {
+        ~WeakReference();
     }
 }
```

