# Microsoft.AspNetCore.Server.Kestrel.Core

``` diff
 namespace Microsoft.AspNetCore.Server.Kestrel.Core {
+    public class Http3Limits {
+        public Http3Limits();
+        public int HeaderTableSize { get; set; }
+        public int MaxRequestHeaderFieldSize { get; set; }
+    }
     public enum HttpProtocols {
+        Http1AndHttp2AndHttp3 = 7,
+        Http3 = 4,
     }
     public class KestrelServer : IDisposable, IServer {
-        public KestrelServer(IOptions<KestrelServerOptions> options, IConnectionListenerFactory transportFactory, ILoggerFactory loggerFactory);

+        public KestrelServer(IOptions<KestrelServerOptions> options, IEnumerable<IConnectionListenerFactory> transportFactories, ILoggerFactory loggerFactory);
+        public KestrelServer(IOptions<KestrelServerOptions> options, IEnumerable<IConnectionListenerFactory> transportFactories, IEnumerable<IMultiplexedConnectionListenerFactory> multiplexedFactories, ILoggerFactory loggerFactory);
     }
     public class KestrelServerLimits {
+        public Http3Limits Http3 { get; }
     }
     public class KestrelServerOptions {
+        public bool EnableAltSvc { get; set; }
     }
-    public class ListenOptions : IConnectionBuilder {
+    public class ListenOptions : IConnectionBuilder, IMultiplexedConnectionBuilder {
+        MultiplexedConnectionDelegate Microsoft.AspNetCore.Connections.IMultiplexedConnectionBuilder.Build();
+        IMultiplexedConnectionBuilder Microsoft.AspNetCore.Connections.IMultiplexedConnectionBuilder.Use(Func<MultiplexedConnectionDelegate, MultiplexedConnectionDelegate> middleware);
     }
 }
```

