# System

``` diff
 namespace System {
     public readonly struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
+        public Decimal(ReadOnlySpan<int> bits);
+        public static int GetBits(Decimal d, Span<int> destination);
+        public static bool TryGetBits(Decimal d, Span<int> destination, out int valuesWritten);
     }
     public static class GC {
+        public static T[] AllocateArray<T>(int length, bool pinned = false);
+        public static T[] AllocateUninitializedArray<T>(int length, bool pinned = false);
     }
-    public readonly struct IntPtr : IEquatable<IntPtr>, ISerializable {
+    public readonly struct IntPtr : IComparable, IComparable<IntPtr>, IEquatable<IntPtr>, IFormattable, ISerializable {
+        public static IntPtr MaxValue { get; }
+        public static IntPtr MinValue { get; }
+        public int CompareTo(IntPtr value);
+        public int CompareTo(object value);
+        public bool Equals(IntPtr other);
+        public static IntPtr Parse(string s);
+        public static IntPtr Parse(string s, NumberStyles style);
+        public static IntPtr Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static IntPtr Parse(string s, IFormatProvider provider);
-        bool System.IEquatable<System.IntPtr>.Equals(IntPtr other);

+        public string ToString(IFormatProvider provider);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out IntPtr result);
+        public static bool TryParse(string s, out IntPtr result);
     }
     public static class MemoryExtensions {
+        public static void Sort<T, TComparer>(this Span<T> span, TComparer comparer) where TComparer : IComparer<T>;
+        public static void Sort<T>(this Span<T> span);
+        public static void Sort<T>(this Span<T> span, Comparison<T> comparison);
+        public static void Sort<TKey, TValue, TComparer>(this Span<TKey> keys, Span<TValue> items, TComparer comparer) where TComparer : IComparer<TKey>;
+        public static void Sort<TKey, TValue>(this Span<TKey> keys, Span<TValue> items);
+        public static void Sort<TKey, TValue>(this Span<TKey> keys, Span<TValue> items, Comparison<TKey> comparison);
     }
     public sealed class ObsoleteAttribute : Attribute {
+        public string DiagnosticId { get; set; }
+        public string UrlFormat { get; set; }
     }
-    public readonly struct UIntPtr : IEquatable<UIntPtr>, ISerializable {
+    public readonly struct UIntPtr : IComparable, IComparable<UIntPtr>, IEquatable<UIntPtr>, IFormattable, ISerializable {
+        public static UIntPtr MaxValue { get; }
+        public static UIntPtr MinValue { get; }
+        public int CompareTo(object value);
+        public int CompareTo(UIntPtr value);
+        public bool Equals(UIntPtr other);
+        public static UIntPtr Parse(string s);
+        public static UIntPtr Parse(string s, NumberStyles style);
+        public static UIntPtr Parse(string s, NumberStyles style, IFormatProvider provider);
+        public static UIntPtr Parse(string s, IFormatProvider provider);
-        bool System.IEquatable<System.UIntPtr>.Equals(UIntPtr other);

+        public string ToString(IFormatProvider provider);
+        public string ToString(string format);
+        public string ToString(string format, IFormatProvider provider);
+        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out UIntPtr result);
+        public static bool TryParse(string s, out UIntPtr result);
     }
 }
```

