# Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http

``` diff
 namespace Microsoft.AspNetCore.Server.Kestrel.Core.Internal.Http {
     public class HttpParser<TRequestHandler> where TRequestHandler : IHttpHeadersHandler, IHttpRequestLineHandler {
-        public bool ParseRequestLine(TRequestHandler handler, in ReadOnlySequence<byte> buffer, out SequencePosition consumed, out SequencePosition examined);

+        public bool ParseRequestLine(TRequestHandler handler, ref SequenceReader<byte> reader);
     }
-    public enum HttpVersion {
+    public enum HttpVersion : sbyte {
-        Http10 = 0,
+        Http10 = (sbyte)0,
-        Http11 = 1,
+        Http11 = (sbyte)1,
-        Http2 = 2,
+        Http2 = (sbyte)2,
-        Http3 = 3,
+        Http3 = (sbyte)3,
-        Unknown = -1,
+        Unknown = (sbyte)-1,
     }
+    public struct HttpVersionAndMethod {
+        public HttpVersionAndMethod(HttpMethod method, int methodEnd);
+        public HttpMethod Method { get; }
+        public int MethodEnd { get; }
+        public HttpVersion Version { get; set; }
+    }
     public interface IHttpRequestLineHandler {
-        void OnStartLine(HttpMethod method, HttpVersion version, Span<byte> target, Span<byte> path, Span<byte> query, Span<byte> customMethod, bool pathEncoded);

+        void OnStartLine(HttpVersionAndMethod versionAndMethod, TargetOffsetPathLength targetPath, Span<byte> startLine);
     }
+    public readonly struct TargetOffsetPathLength {
+        public TargetOffsetPathLength(int offset, int length, bool isEncoded);
+        public bool IsEncoded { get; }
+        public int Length { get; }
+        public int Offset { get; }
+    }
 }
```

