# .NET 6.0.4 - April 12, 2022

The .NET 6.0.4, .NET 6.0.202 SDK and [.NET SDK 6.0.104](6.0.104.md) releases are available for download. The latest 6.0 release is always listed at [.NET 6.0 Releases](../README.md).

The .NET 6 release includes support for macOS and Windows Arm64 operating systems, see details [.NET support for macOS 11 and Windows 11 for ARM64 and x64](https://github.com/dotnet/sdk/issues/22380).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
6.0.202
```
Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## .NET Multi-Platform App UI (MAUI) Preview Workload Downloads

.NET 6 introduces Android, iOS, and macOS SDKs for developing native applications. These provide the foundational mobile and desktop pieces for the new [.NET MAUI](https://github.com/dotnet/maui). See [documentation](https://docs.microsoft.com/dotnet/maui/get-started/installation) for additional setup instructions and creating your first .NET MAUI application.

After installing the .NET SDK, you can install .NET MAUI using the `dotnet workload install` command:

```console
$ dotnet workload install maui
```

The following workloads are also available to install individually:

```console
$ dotnet workload install android
$ dotnet workload install ios
$ dotnet workload install maccatalyst
$ dotnet workload install macos
$ dotnet workload install tvos
```

</br>

Visit [.NET Documentation](https://docs.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Windows SDK Updates

* .NET SDK 6.0.104 and 6.0.202 includes performance improvements and bug fixes to the Windows SDK packages that provide access to Windows Runtime APIs. For more details see the [C#/WinRT 1.6.1 release notes](https://github.com/microsoft/CsWinRT/releases/tag/1.6.1.220314.1).

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 6.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated:

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Notable Changes
.NET 6.0.4 release carries non-security fixes.

In .NET 6.0.4 the existing ASP.NET Core targeting pack RPM filename was updated:
* Old: aspnetcore-targeting-pack-[version].rpm 
* New: aspnetcore-targeting-pack-[version]-x64.rpm

### Additional fixes in this release

* [Arcade](https://github.com/dotnet/arcade/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3AServicing-approved+)
* [Installer](https://github.com/dotnet/installer/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Linker](https://github.com/dotnet/linker/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [MSBuild](https://github.com/dotnet/msbuild/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Templating](https://github.com/dotnet/templating/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Winforms](https://github.com/dotnet/winforms/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)
* [Runtime](https://github.com/dotnet/runtime/issues?q=milestone%3A6.0.4+is%3Aclosed+label%3Aservicing-approved+)


## Visual Studio Compatibility

You need [Visual Studio 17.0](https://visualstudio.microsoft.com) or later to use .NET 6.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 6.0 and C# 10.0.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7362](https://github.com/dotnet/core/issues/7362) for your questions and comments.


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.4/6.0.4.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.4-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/6.0.4-sha.txt

[linux-install]: https://docs.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/april-2022-updates/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-net-6/
[maui-blog]: https://devblogs.microsoft.com/dotnet/update-on-dotnet-maui/

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
 Microsoft.WindowsDesktop.App.Ref| 6.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x64| 6.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-x86| 6.0.4.nupkg
Microsoft.WindowsDesktop.App.Runtime.win-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64| 6.0.4.nupkg
Microsoft.Win32.SystemEvents| 6.0.1.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-arm64| 6.0.4.nupkg
Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.osx-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x86| 6.0.4.nupkg
Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
System.Text.Json| 6.0.3.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.win-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Host.win-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64| 6.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.win-arm.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64| 6.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.osx-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Host.win-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk| 6.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.osx-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
Microsoft.NETCore.Platforms| 6.0.3.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
Microsoft.NETCore.App.Host.linux-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Host.osx-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Host.win-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-musl-arm| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Runtime.iOS.Sample.Mono| 6.0.4.nupkg
Microsoft.NET.Runtime.Android.Sample.Mono| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm64| 6.0.4.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.linux-arm| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoAOTCompiler.Task| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.200| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100| 6.0.4.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm| 6.0.4.nupkg
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86| 6.0.4.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64| 6.0.4.nupkg
System.Diagnostics.PerformanceCounter| 6.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
Microsoft.NETCore.App.Host.osx-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Host.win-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.100.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.osx-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64| 6.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
System.Runtime.Experimental| 6.0.2.nupkg
System.Net.Http.WinHttpHandler| 6.0.1.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
Microsoft.NETCore.App.Host.linux-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.win-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.osx-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Crossgen2.win-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm| 6.0.4.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64| 6.0.4.nupkg
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.linux-x64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.win-arm| 6.0.4.nupkg
Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.win-x64| 6.0.4.nupkg
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver| 6.0.4.nupkg
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy| 6.0.4.nupkg
runtime.win-x86.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
Microsoft.NETCore.App.Host.linux-musl-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Host.linux-musl-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Composite| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x86.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-musl-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64| 6.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetHost| 6.0.4.nupkg
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
runtime.win-x64.Microsoft.NETCore.DotNetAppHost| 6.0.4.nupkg
Microsoft.NETCore.App.Host.linux-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Ref| 6.0.4.nupkg
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Runtime.wasm.Sample.Mono| 6.0.4.nupkg
Microsoft.NET.Runtime.WebAssembly.Sdk| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Workload.Mono.ToolChain.Manifest-6.0.300.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.linux-x64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.linux-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.ios-arm| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64| 6.0.4.nupkg
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm| 6.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly.DevServer| 6.0.4.nupkg
Microsoft.AspNetCore.AzureAppServices.SiteExtension| 6.0.4.nupkg
Microsoft.AspNetCore.Mvc.Razor.Extensions| 6.0.4.nupkg
Microsoft.AspNetCore.Mvc.NewtonsoftJson| 6.0.4.nupkg
Microsoft.AspNetCore.Hosting.WindowsServices| 6.0.4.nupkg
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation| 6.0.4.nupkg
Microsoft.dotnet-openapi| 6.0.4.nupkg
Microsoft.Authentication.WebAssembly.Msal| 6.0.4.nupkg
Microsoft.AspNetCore.TestHost| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.StackExchangeRedis| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Specification.Tests| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Protocols.Json| 6.0.4.nupkg
AspNetCoreRuntime.6.0.x86| 6.0.4.nupkg
Microsoft.AspNetCore.App.Ref| 6.0.4.nupkg
Microsoft.AspNetCore.Identity.UI| 6.0.4.nupkg
Microsoft.AspNetCore.MiddlewareAnalysis| 6.0.4.nupkg
Microsoft.AspNetCore.Identity.EntityFrameworkCore| 6.0.4.nupkg
Microsoft.AspNetCore.DataProtection.StackExchangeRedis| 6.0.4.nupkg
Microsoft.AspNetCore.DataProtection.Extensions| 6.0.4.nupkg
Microsoft.AspNetCore.DataProtection| 6.0.4.nupkg
Microsoft.DotNet.Web.Client.ItemTemplates| 6.0.4.nupkg
Microsoft.CodeAnalysis.Razor| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Protocols.MessagePack| 6.0.4.nupkg
Microsoft.AspNetCore.Owin| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.osx-arm64| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-x64| 6.0.4.nupkg
Microsoft.DotNet.Web.ItemTemplates.6.0| 6.0.4.nupkg
Microsoft.AspNetCore.Components.Forms| 6.0.4.nupkg
Microsoft.AspNetCore.AzureAppServicesIntegration| 6.0.4.nupkg
Microsoft.AspNetCore.Authorization| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.WsFederation| 6.0.4.nupkg
Microsoft.AspNetCore.AzureAppServices.HostingStartup| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.Twitter| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.Negotiate| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.JwtBearer| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.Google| 6.0.4.nupkg
Microsoft.JSInterop| 6.0.4.nupkg
Microsoft.JSInterop.WebAssembly| 6.0.4.nupkg
Microsoft.Extensions.WebEncoders| 6.0.4.nupkg
Microsoft.Extensions.Localization| 6.0.4.nupkg
Microsoft.Extensions.FileProviders.Embedded| 6.0.4.nupkg
Microsoft.Extensions.Identity.Stores| 6.0.4.nupkg
Microsoft.Extensions.Features| 6.0.4.nupkg
Microsoft.Extensions.Caching.SqlServer| 6.0.4.nupkg
Microsoft.Extensions.ApiDescription.Server| 6.0.4.nupkg
Microsoft.AspNetCore.JsonPatch| 6.0.4.nupkg
Microsoft.AspNetCore.Metadata| 6.0.4.nupkg
Microsoft.AspNetCore.Http.Connections.Client| 6.0.4.nupkg
Microsoft.AspNetCore.HeaderPropagation| 6.0.4.nupkg
Microsoft.AspNetCore.DataProtection.Abstractions| 6.0.4.nupkg
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore| 6.0.4.nupkg
Microsoft.AspNetCore.Cryptography.Internal| 6.0.4.nupkg
Microsoft.AspNetCore.Mvc.Testing| 6.0.4.nupkg
Microsoft.AspNetCore.SpaServices.Extensions| 6.0.4.nupkg
Microsoft.AspNetCore.SpaProxy| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Common| 6.0.4.nupkg
Microsoft.AspNetCore.Server.Kestrel.Transport.Libuv| 6.0.4.nupkg
Microsoft.AspNetCore.Razor.Language| 6.0.4.nupkg
AspNetCoreRuntime.6.0.x64| 6.0.4.nupkg
Microsoft.AspNetCore.Connections.Abstractions| 6.0.4.nupkg
Microsoft.AspNetCore.ConcurrencyLimiter| 6.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Server| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-arm64| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-x64| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-x64| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.AzureADB2C.UI| 6.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly.Authentication| 6.0.4.nupkg
Microsoft.AspNetCore.Components.WebAssembly| 6.0.4.nupkg
Microsoft.AspNetCore.Components.Web| 6.0.4.nupkg
Microsoft.AspNetCore.Components.Authorization| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.MicrosoftAccount| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.Facebook| 6.0.4.nupkg
Microsoft.DotNet.Web.ProjectTemplates.6.0| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.AzureAD.UI| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.Certificate| 6.0.4.nupkg
Microsoft.Extensions.Caching.StackExchangeRedis| 6.0.4.nupkg
Microsoft.Extensions.Logging.AzureAppServices| 6.0.4.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-arm64| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.win-x86| 6.0.4.nupkg
Microsoft.AspNetCore.Components| 6.0.4.nupkg
Microsoft.AspNetCore.Components.Analyzers| 6.0.4.nupkg
Microsoft.Extensions.ApiDescription.Client| 6.0.4.nupkg
Microsoft.Extensions.ObjectPool| 6.0.4.nupkg
Microsoft.Extensions.Localization.Abstractions| 6.0.4.nupkg
Microsoft.Extensions.Identity.Core| 6.0.4.nupkg
Microsoft.AspNetCore.Http.Connections.Common| 6.0.4.nupkg
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore| 6.0.4.nupkg
Microsoft.AspNetCore.Cryptography.KeyDerivation| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Client.Core| 6.0.4.nupkg
Microsoft.AspNetCore.SignalR.Client| 6.0.4.nupkg
Microsoft.AspNetCore.Components.WebView| 6.0.4.nupkg
Microsoft.AspNetCore.ApiAuthorization.IdentityServer| 6.0.4.nupkg
dotnet-sql-cache| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.osx-x64| 6.0.4.nupkg
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64| 6.0.4.nupkg
Microsoft.AspNetCore.Authentication.OpenIdConnect| 6.0.4.nupkg
Microsoft.DotNet.Web.Spa.ProjectTemplates.6.0| 6.0.4.nupkg
Microsoft.Extensions.Http.Polly| 6.0.4.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions| 6.0.4.nupkg
Microsoft.Extensions.Diagnostics.HealthChecks| 6.0.4.nupkg
Microsoft.Extensions.Configuration.KeyPerFile| 6.0.4.nupkg
Microsoft.TemplateSearch.Common| 6.0.202.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.202.nupkg
Microsoft.TemplateEngine.Edge| 6.0.202.nupkg
Microsoft.TemplateEngine.Utils| 6.0.202.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.202.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.202.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.202.nupkg
Microsoft.TemplateEngine.IDE| 6.0.202.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.202.nupkg
Microsoft.TemplateEngine.Core| 6.0.202.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.202.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.202.nupkg
Microsoft.DotNet.Compatibility.1.0.0-servicing.22172.7.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.linux-x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.win-x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.osx-x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.200| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Sdk.osx-x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.win-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.200.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Node.linux-x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.win-x64.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.200.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.200.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.arm64| 6.0.4.nupkg
Microsoft.NET.Runtime.Emscripten.2.0.23.Python.osx-x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.100.Msi.x86| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x64| 6.0.4.nupkg
Microsoft.NET.Workload.Emscripten.Manifest-6.0.300.Msi.x86| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite| 6.0.4.nupkg
dotnet-ef| 6.0.4.nupkg
Microsoft.Data.Sqlite.Core| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Design| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Proxies| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Specification.Tests| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.SqlServer| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Tools| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite| 6.0.4.nupkg
Microsoft.Data.Sqlite| 6.0.4.nupkg
Microsoft.EntityFrameworkCore| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Abstractions| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Relational| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Relational.Specification.Tests| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Analyzers| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Cosmos| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.InMemory| 6.0.4.nupkg
Microsoft.EntityFrameworkCore.Sqlite.Core| 6.0.4.nupkg
Microsoft.TemplateEngine.Utils| 6.0.104.nupkg
Microsoft.DotNet.Common.ProjectTemplates.6.0| 6.0.104.nupkg
Microsoft.TemplateEngine.Core| 6.0.104.nupkg
Microsoft.TemplateEngine.Orchestrator.RunnableProjects| 6.0.104.nupkg
Microsoft.TemplateEngine.Core.Contracts| 6.0.104.nupkg
Microsoft.TemplateEngine.IDE| 6.0.104.nupkg
Microsoft.DotNet.Common.ItemTemplates| 6.0.104.nupkg
Microsoft.TemplateEngine.Abstractions| 6.0.104.nupkg
Microsoft.TemplateEngine.Edge| 6.0.104.nupkg
Microsoft.TemplateEngine.TemplateLocalizer| 6.0.104.nupkg
Microsoft.TemplateSearch.Common| 6.0.104.nupkg
Microsoft.TemplateEngine.TemplateLocalizer.Core| 6.0.104.nupkg
Microsoft.DotNet.Compatibility.1.0.0-servicing.22172.6.nupkg



[//]: # ( Runtime 6.0.4)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f8e1ab66-58f7-4ebb-a9bb-9decfa03501f/88e1fb49af6f75dc54c23383162409c5/dotnet-runtime-6.0.4-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3641affa-8bb0-486f-93d9-68adff4f4af7/1e3df9fb86cba7299b9e575233975734/dotnet-runtime-6.0.4-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ec900704-fb9b-4ba0-bf95-fa3cac970bee/7e8ebe143617abc7621d1d5d0f4c9cb7/dotnet-runtime-6.0.4-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98f2e4c8-0c2f-4947-9c30-61b9889defb1/171f63510ed9b52502f23cc057a85dc8/dotnet-runtime-6.0.4-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ef010dec-9dcd-49a7-89a9-e97931a112ac/bef96075e3d70b1365bd0e82634e79e0/dotnet-runtime-6.0.4-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5b08d331-15ac-4a53-82a5-522fa45b1b99/65ae300dd160ae0b88b91dd78834ce3e/dotnet-runtime-6.0.4-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4b98b2d3-65ff-48c1-b331-05c12505aef9/fc6a053dc379a1a6e0f8b0588e4cb342/dotnet-runtime-6.0.4-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd2f6b72-bf47-4ae5-8a3d-4d394569cc34/87d408439ac5feffe2abf622dbfa5084/dotnet-runtime-6.0.4-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/c8651729-bbc6-479a-b70f-f333895eb8ff/c15a3715673c4a981804197333d6e708/dotnet-runtime-6.0.4-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c0bc0428-852d-4884-b536-3d0969a400ba/fe0a9a221c3e665e88b7020633f2cf8e/dotnet-runtime-6.0.4-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/8b70fab9-94d4-411d-a9ae-fd1654c3e9a5/19b815cc88a13e016413bfc923e3136f/dotnet-runtime-6.0.4-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/961cd054-57ad-4608-97ab-8a390833f452/f203e4c76b1f1e9035f44fd1d11d9fbd/dotnet-runtime-6.0.4-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2e97f1f0-f321-4baf-8d02-0be5f08afc4e/2a011c8f9b2792e17d363a21c0ed8fdc/dotnet-runtime-6.0.4-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3feaabc7-1786-4012-8e00-d664f00581e9/8d9b529256502637663ddd4048de04dc/dotnet-runtime-6.0.4-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/08e41641-f1b4-47b4-9ed9-c8672614f093/ea66a30f9f8ac7320ea0d7f6e4d5d2d9/dotnet-runtime-6.0.4-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4092dc2d-ca5f-4586-b405-d369e99dae2e/abdad72f78700ed1e79d4d2f107e82e3/dotnet-runtime-6.0.4-win-x86.zip

[//]: # ( WindowsDesktop 6.0.4)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/e49c1c5d-af86-4ec1-9cc9-fa6a9d3ace94/98fe87ae72e3e79a3efd82d07e59d1a3/windowsdesktop-runtime-6.0.4-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/23e356e1-2dae-45e1-a364-77a5f4b99542/e51895561b6c10ee49394b63bc5ab756/windowsdesktop-runtime-6.0.4-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/f13d7b5c-608f-432b-b7ec-8fe84f4030a1/5e06998f9ce23c620b9d6bac2dae6c1d/windowsdesktop-runtime-6.0.4-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4d8f03e3-006c-4e34-8b27-cfd7d23bc47b/41a08c2b0314163cd4dbb9995826698b/windowsdesktop-runtime-6.0.4-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/05b30243-5cd2-48c3-a9bb-6ac83d7d481b/03a25aecb5cf4ba53c8b9cf5194e3c86/windowsdesktop-runtime-6.0.4-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/aa7baa92-26eb-45ee-9ac1-b41b475a328b/aadd9fb2a741ffcf44be8444be4ffa20/windowsdesktop-runtime-6.0.4-win-x86.zip

[//]: # ( ASP 6.0.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/adc5bbf5-6cf6-4da6-be27-60de0b8739e5/fecb289bd70834203f2397c18c82bbde/aspnetcore-runtime-6.0.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ba1662bf-50e6-451a-957f-0d55bc6e5713/921fe0e68428ac47c098e97418d3126a/aspnetcore-runtime-6.0.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2377b5d7-2ad4-4caa-a7c5-68ea1f45077d/474cde13b117bcfc72a06c797731bfc8/aspnetcore-runtime-6.0.4-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eabef5ee-95df-4348-ad1e-964c79d3a1b3/5b66dbe250bbf3c22d9d6f3644cb4ab0/aspnetcore-runtime-6.0.4-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/22f9a98b-2b90-4f38-9760-cfa5a262e62f/91ea70c8f5868bfe93c03122be2f365b/aspnetcore-runtime-6.0.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de3f6658-5d5b-4986-aeb1-7efdf5818437/7df572051df15117a0f52be1b79e1823/aspnetcore-runtime-6.0.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d7b60e75-6901-4f68-8943-ce32cadeaf29/f14e40b3e9a69cbd79d47375b16a76e7/aspnetcore-runtime-6.0.4-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b39aa0b4-27e2-4fce-bf36-fb6d46f89e5e/6b8ca3b4c7026db460df1d49f5366f1b/aspnetcore-runtime-6.0.4-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/bbab6b5f-e700-4de5-afef-e3eaca140c71/74e48a4de85af3451d32306af8ab9acd/aspnetcore-runtime-6.0.4-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2162932c-987a-4de8-ae2a-f7d327bb39a8/97fe1cb950c2bccf44b7c3fe6aa45b53/aspnetcore-runtime-6.0.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/bfbc4558-f639-4209-a9bb-f3e9591a4e0b/696b30897550c521b07487b1ddbe67ab/aspnetcore-runtime-6.0.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c2093d31-b27e-4876-891c-750247cf1faa/33b9191b128a1d33671549972403994e/aspnetcore-runtime-6.0.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ce0116e7-fea3-4878-ba71-0b21d79ec974/841e36107efc39704f07786fa06d4bec/aspnetcore-runtime-6.0.4-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/0c2039d2-0072-43a8-bb20-766b9a91d001/0e2288a2f07743e63778416b2367bb88/dotnet-hosting-6.0.4-win.exe

[//]: # ( SDK 6.0.202)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e41a177d-9f0b-4afe-97a4-53587cd89d00/c2c897aa6442d49c1d2d86abb23c20b2/dotnet-sdk-6.0.202-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/952f5525-7227-496f-85e5-09cadfb44629/eefd0f6eb8f809bfaf4f0661809ed826/dotnet-sdk-6.0.202-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5873d93-116d-43cc-99da-ca7bb4c5248c/04da013ca4e8b506a2e28a890d1dae61/dotnet-sdk-6.0.202-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b75ec220-d673-4cc8-ac56-3e11c519f31c/da391e6975d9f2abac9955c46410e0bc/dotnet-sdk-6.0.202-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/10cb475d-6134-4180-9c86-712e6a6778dc/b60fd607a872f6f716cee74d68967eb0/dotnet-sdk-6.0.202-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9d8c7137-2091-4fc6-a419-60ba59c8b9de/db0c5cda94f31d2260d369123de32d59/dotnet-sdk-6.0.202-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/605dfd20-32ac-470a-b366-cbb293ce4cfe/9c1eec28d0e6068721026a5f77af2e60/dotnet-sdk-6.0.202-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/032fc69b-f437-4d17-9e6c-c204ce18a0b0/76386390762a9ba205666a6e45a2ac47/dotnet-sdk-6.0.202-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/4332c16b-5a65-4adf-b25d-f6a46ef2b335/1a1edc2dab547161e2448390c3d4f56d/dotnet-sdk-6.0.202-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a014dee-ff5f-48e3-a817-82b9bd536b56/fed3a710f5e0add13844a6ce400775a1/dotnet-sdk-6.0.202-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/8e21805c-5336-4811-86b3-8d7d99444760/23ff7325a95245bf1aabcad228cfe306/dotnet-sdk-6.0.202-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/4b3dcaa6-f4a2-48c5-a22d-398a575471d1/bb3537b0bafcbbf314fb55f7b49a9e4b/dotnet-sdk-6.0.202-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e4f4bbac-5660-45a9-8316-0ffc10765179/8ade57de09ce7f12d6411ed664f74eca/dotnet-sdk-6.0.202-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b1461027-6daa-467d-aebe-6326343e5840/01656d95b28f16c53cd947a8072d004b/dotnet-sdk-6.0.202-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/dc7ccd64-e6d7-43a9-8c81-1adcea6f315b/d0c63b6ab8c42ec91dc8a5d512fee1a6/dotnet-sdk-6.0.202-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e71628cc-8b6c-498f-ae7a-c0dc60019696/aaadc51ad300f1aa58250427e5373527/dotnet-sdk-6.0.202-win-x86.zip
