# System.Collections.Generic

``` diff
 namespace System.Collections.Generic {
     public class List<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+        public int EnsureCapacity(int capacity);
     }
+    public class PriorityQueue<TElement, TPriority> {
+        public PriorityQueue();
+        public PriorityQueue(IComparer<TPriority> comparer);
+        public PriorityQueue(IEnumerable<ValueTuple<TElement, TPriority>> items);
+        public PriorityQueue(IEnumerable<ValueTuple<TElement, TPriority>> items, IComparer<TPriority> comparer);
+        public PriorityQueue(int initialCapacity);
+        public PriorityQueue(int initialCapacity, IComparer<TPriority> comparer);
+        public IComparer<TPriority> Comparer { get; }
+        public int Count { get; }
+        public PriorityQueue<TElement, TPriority>.UnorderedItemsCollection UnorderedItems { get; }
+        public void Clear();
+        public TElement Dequeue();
+        public void Enqueue(TElement element, TPriority priority);
+        public TElement EnqueueDequeue(TElement element, TPriority priority);
+        public void EnqueueRange(IEnumerable<ValueTuple<TElement, TPriority>> items);
+        public void EnqueueRange(IEnumerable<TElement> elements, TPriority priority);
+        public int EnsureCapacity(int capacity);
+        public TElement Peek();
+        public void TrimExcess();
+        public bool TryDequeue(out TElement element, out TPriority priority);
+        public bool TryPeek(out TElement element, out TPriority priority);
+        public sealed class UnorderedItemsCollection : ICollection, IEnumerable, IEnumerable<ValueTuple<TElement, TPriority>>, IReadOnlyCollection<ValueTuple<TElement, TPriority>> {
+            public int Count { get; }
+            bool System.Collections.ICollection.IsSynchronized { get; }
+            object System.Collections.ICollection.SyncRoot { get; }
+            public PriorityQueue<TElement, TPriority>.UnorderedItemsCollection.Enumerator GetEnumerator();
+            IEnumerator<ValueTuple<TElement, TPriority>> System.Collections.Generic.IEnumerable<(TElementElement,TPriorityPriority)>.GetEnumerator();
+            void System.Collections.ICollection.CopyTo(Array array, int index);
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<ValueTuple<TElement, TPriority>> {
+                public (TElement Element, TPriority Priority) Current { get; }
+                (TElement Element, TPriority Priority) System.Collections.Generic.IEnumerator<(TElementElement,TPriorityPriority)>.Current { get; }
+                object System.Collections.IEnumerator.Current { get; }
+                public void Dispose();
+                public bool MoveNext();
+                void System.Collections.IEnumerator.Reset();
+            }
+        }
+    }
     public class Queue<T> : ICollection, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
+        public int EnsureCapacity(int capacity);
     }
     public class SortedList<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
-        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
+        void System.Collections.ICollection.CopyTo(Array array, int index);
     }
     public class Stack<T> : ICollection, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
+        public int EnsureCapacity(int capacity);
     }
 }
```

