# System.Data.Common

``` diff
 namespace System.Data.Common {
+    public abstract class DbBatch : IAsyncDisposable, IDisposable {
+        protected DbBatch();
+        public DbBatchCommandCollection BatchCommands { get; }
+        public DbConnection Connection { get; set; }
+        protected abstract DbBatchCommandCollection DbBatchCommands { get; }
+        protected abstract DbConnection DbConnection { get; set; }
+        protected abstract DbTransaction DbTransaction { get; set; }
+        public abstract int Timeout { get; set; }
+        public DbTransaction Transaction { get; set; }
+        public abstract void Cancel();
+        public DbBatchCommand CreateBatchCommand();
+        protected abstract DbBatchCommand CreateDbBatchCommand();
+        public virtual void Dispose();
+        public virtual ValueTask DisposeAsync();
+        protected abstract DbDataReader ExecuteDbDataReader(CommandBehavior behavior);
+        protected abstract Task<DbDataReader> ExecuteDbDataReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
+        public abstract int ExecuteNonQuery();
+        public abstract Task<int> ExecuteNonQueryAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public DbDataReader ExecuteReader(CommandBehavior behavior = CommandBehavior.Default);
+        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<DbDataReader> ExecuteReaderAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public abstract object ExecuteScalar();
+        public abstract Task<object> ExecuteScalarAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public abstract void Prepare();
+        public abstract Task PrepareAsync(CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public abstract class DbBatchCommand {
+        protected DbBatchCommand();
+        public abstract string CommandText { get; set; }
+        public abstract CommandType CommandType { get; set; }
+        protected abstract DbParameterCollection DbParameterCollection { get; }
+        public DbParameterCollection Parameters { get; }
+        public abstract int RecordsAffected { get; }
+    }
+    public abstract class DbBatchCommandCollection : ICollection<DbBatchCommand>, IEnumerable, IEnumerable<DbBatchCommand>, IList<DbBatchCommand> {
+        protected DbBatchCommandCollection();
+        public abstract int Count { get; }
+        public abstract bool IsReadOnly { get; }
+        public DbBatchCommand this[int index] { get; set; }
+        public abstract void Add(DbBatchCommand item);
+        public abstract void Clear();
+        public abstract bool Contains(DbBatchCommand item);
+        public abstract void CopyTo(DbBatchCommand[] array, int arrayIndex);
+        protected abstract DbBatchCommand GetBatchCommand(int index);
+        public abstract IEnumerator<DbBatchCommand> GetEnumerator();
+        public abstract int IndexOf(DbBatchCommand item);
+        public abstract void Insert(int index, DbBatchCommand item);
+        public abstract bool Remove(DbBatchCommand item);
+        public abstract void RemoveAt(int index);
+        protected abstract void SetBatchCommand(int index, DbBatchCommand batchCommand);
+        IEnumerator System.Collections.IEnumerable.GetEnumerator();
+    }
     public abstract class DbConnection : Component, IAsyncDisposable, IDbConnection, IDisposable {
+        public virtual bool CanCreateBatch { get; }
+        public DbBatch CreateBatch();
+        protected virtual DbBatch CreateDbBatch();
     }
     public abstract class DbException : ExternalException {
+        public DbBatchCommand BatchCommand { get; }
+        protected virtual DbBatchCommand DbBatchCommand { get; }
     }
     public abstract class DbProviderFactory {
+        public virtual bool CanCreateBatch { get; }
+        public virtual DbBatch CreateBatch();
+        public virtual DbBatchCommand CreateBatchCommand();
     }
 }
```

