# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public class NetworkStream : Stream {
-        public override IAsyncResult BeginRead(byte[] buffer, int offset, int size, AsyncCallback callback, object state);
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int size, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
-        public override int Read(byte[] buffer, int offset, int size);
+        public override int Read(byte[] buffer, int offset, int count);
-        public override Task<int> ReadAsync(byte[] buffer, int offset, int size, CancellationToken cancellationToken);
+        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
-        public override void Write(byte[] buffer, int offset, int size);
+        public override void Write(byte[] buffer, int offset, int count);
-        public override Task WriteAsync(byte[] buffer, int offset, int size, CancellationToken cancellationToken);
+        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
     }
     public sealed class SafeSocketHandle : SafeHandleMinusOneIsInvalid {
+        public SafeSocketHandle();
     }
     public class SendPacketsElement {
+        public SendPacketsElement(ReadOnlyMemory<byte> buffer);
+        public SendPacketsElement(ReadOnlyMemory<byte> buffer, bool endOfPacket);
+        public ReadOnlyMemory<byte>? MemoryBuffer { get; }
     }
     public class Socket : IDisposable {
+        public Task<Socket> AcceptAsync();
+        public Task<Socket> AcceptAsync(Socket acceptSocket);
+        public ValueTask<Socket> AcceptAsync(Socket acceptSocket, CancellationToken cancellationToken);
+        public ValueTask<Socket> AcceptAsync(CancellationToken cancellationToken);
+        public Task ConnectAsync(EndPoint remoteEP);
+        public ValueTask ConnectAsync(EndPoint remoteEP, CancellationToken cancellationToken);
+        public Task ConnectAsync(IPAddress address, int port);
+        public ValueTask ConnectAsync(IPAddress address, int port, CancellationToken cancellationToken);
+        public Task ConnectAsync(IPAddress[] addresses, int port);
+        public ValueTask ConnectAsync(IPAddress[] addresses, int port, CancellationToken cancellationToken);
+        public Task ConnectAsync(string host, int port);
+        public ValueTask ConnectAsync(string host, int port, CancellationToken cancellationToken);
+        public ValueTask DisconnectAsync(bool reuseSocket, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<int> ReceiveAsync(ArraySegment<byte> buffer, SocketFlags socketFlags);
+        public Task<int> ReceiveAsync(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags);
+        public ValueTask<int> ReceiveAsync(Memory<byte> buffer, SocketFlags socketFlags, CancellationToken cancellationToken = default(CancellationToken));
+        public int ReceiveFrom(Span<byte> buffer, ref EndPoint remoteEP);
+        public int ReceiveFrom(Span<byte> buffer, SocketFlags socketFlags, ref EndPoint remoteEP);
+        public Task<SocketReceiveFromResult> ReceiveFromAsync(ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint);
+        public ValueTask<SocketReceiveFromResult> ReceiveFromAsync(Memory<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public int ReceiveMessageFrom(Span<byte> buffer, ref SocketFlags socketFlags, ref EndPoint remoteEP, out IPPacketInformation ipPacketInformation);
+        public Task<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint);
+        public ValueTask<SocketReceiveMessageFromResult> ReceiveMessageFromAsync(Memory<byte> buffer, SocketFlags socketFlags, EndPoint remoteEndPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<int> SendAsync(ArraySegment<byte> buffer, SocketFlags socketFlags);
+        public Task<int> SendAsync(IList<ArraySegment<byte>> buffers, SocketFlags socketFlags);
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> buffer, SocketFlags socketFlags, CancellationToken cancellationToken = default(CancellationToken));
+        public void SendFile(string fileName, ReadOnlySpan<byte> preBuffer, ReadOnlySpan<byte> postBuffer, TransmitFileOptions flags);
+        public ValueTask SendFileAsync(string fileName, ReadOnlyMemory<byte> preBuffer, ReadOnlyMemory<byte> postBuffer, TransmitFileOptions flags, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask SendFileAsync(string fileName, CancellationToken cancellationToken = default(CancellationToken));
+        public int SendTo(ReadOnlySpan<byte> buffer, EndPoint remoteEP);
+        public int SendTo(ReadOnlySpan<byte> buffer, SocketFlags socketFlags, EndPoint remoteEP);
+        public Task<int> SendToAsync(ArraySegment<byte> buffer, SocketFlags socketFlags, EndPoint remoteEP);
+        public ValueTask<int> SendToAsync(ReadOnlyMemory<byte> buffer, SocketFlags socketFlags, EndPoint remoteEP, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class TcpClient : IDisposable {
+        public Task ConnectAsync(IPEndPoint remoteEP);
+        public ValueTask ConnectAsync(IPEndPoint remoteEP, CancellationToken cancellationToken);
     }
     public class TcpListener {
+        public ValueTask<Socket> AcceptSocketAsync(CancellationToken cancellationToken);
+        public ValueTask<TcpClient> AcceptTcpClientAsync(CancellationToken cancellationToken);
     }
     public class UdpClient : IDisposable {
+        public ValueTask<UdpReceiveResult> ReceiveAsync(CancellationToken cancellationToken);
+        public int Send(ReadOnlySpan<byte> datagram);
+        public int Send(ReadOnlySpan<byte> datagram, IPEndPoint endPoint);
+        public int Send(ReadOnlySpan<byte> datagram, string hostname, int port);
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> datagram, IPEndPoint endPoint, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> datagram, string hostname, int port, CancellationToken cancellationToken = default(CancellationToken));
+        public ValueTask<int> SendAsync(ReadOnlyMemory<byte> datagram, CancellationToken cancellationToken = default(CancellationToken));
     }
 }
```

