# System.Net

``` diff
 namespace System.Net {
     public class CookieContainer {
+        public CookieCollection GetAllCookies();
     }
     public static class Dns {
+        public static IPAddress[] GetHostAddresses(string hostNameOrAddress, AddressFamily family);
+        public static Task<IPAddress[]> GetHostAddressesAsync(string hostNameOrAddress, AddressFamily family, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task<IPAddress[]> GetHostAddressesAsync(string hostNameOrAddress, CancellationToken cancellationToken);
+        public static IPHostEntry GetHostEntry(string hostNameOrAddress, AddressFamily family);
+        public static Task<IPHostEntry> GetHostEntryAsync(string hostNameOrAddress, AddressFamily family, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task<IPHostEntry> GetHostEntryAsync(string hostNameOrAddress, CancellationToken cancellationToken);
     }
     public static class HttpVersion {
+        public static readonly Version Version30;
     }
     public class IPAddress {
+        public bool IsIPv6UniqueLocal { get; }
     }
 }
```

