# Microsoft.AspNetCore.Server.Kestrel.Transport.Sockets

``` diff
 namespace Microsoft.AspNetCore.Server.Kestrel.Transport.Sockets {
+    public sealed class SocketConnectionContextFactory : IDisposable {
+        public SocketConnectionContextFactory(SocketConnectionFactoryOptions options, ILogger logger);
+        public ConnectionContext Create(Socket socket);
+        public void Dispose();
+    }
+    public class SocketConnectionFactoryOptions {
+        public SocketConnectionFactoryOptions();
+        public int IOQueueCount { get; set; }
+        public long? MaxReadBufferSize { get; set; }
+        public long? MaxWriteBufferSize { get; set; }
+        public bool UnsafePreferInlineScheduling { get; set; }
+        public bool WaitForDataBeforeAllocatingBuffer { get; set; }
+    }
     public class SocketTransportOptions {
+        public Func<EndPoint, Socket> CreateBoundListenSocket { get; set; }
+        public static Socket CreateDefaultBoundListenSocket(EndPoint endpoint);
     }
 }
```

