# Microsoft.AspNetCore.WebUtilities

``` diff
 namespace Microsoft.AspNetCore.WebUtilities {
     public class BufferedReadStream : Stream {
+        public override ValueTask<int> ReadAsync(Memory<byte> buffer, CancellationToken cancellationToken);
     }
     public class FileBufferingReadStream : Stream {
+        public int MemoryThreshold { get; }
     }
     public sealed class FileBufferingWriteStream : Stream {
+        public int MemoryThreshold { get; }
+        public override ValueTask WriteAsync(ReadOnlyMemory<byte> buffer, CancellationToken cancellationToken = default(CancellationToken));
     }
+    public readonly struct QueryStringEnumerable {
+        public QueryStringEnumerable(ReadOnlyMemory<char> queryString);
+        public QueryStringEnumerable(string queryString);
+        public QueryStringEnumerable.Enumerator GetEnumerator();
+        public readonly struct EncodedNameValuePair {
+            public ReadOnlyMemory<char> EncodedName { get; }
+            public ReadOnlyMemory<char> EncodedValue { get; }
+            public ReadOnlyMemory<char> DecodeName();
+            public ReadOnlyMemory<char> DecodeValue();
+        }
+        public struct Enumerator {
+            public QueryStringEnumerable.EncodedNameValuePair Current { get; }
+            public bool MoveNext();
+        }
+    }
 }
```

