# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public static class BindConverter {
+        public static string FormatValue(DateOnly value, CultureInfo culture = null);
+        public static string FormatValue(DateOnly value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateOnly? value, CultureInfo culture = null);
+        public static string FormatValue(DateOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly? value, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly value, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly value, string format, CultureInfo culture = null);
+        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, out DateOnly value);
+        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, string format, out DateOnly value);
+        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, out DateOnly? value);
+        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, string format, out DateOnly? value);
+        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, out TimeOnly? value);
+        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly? value);
+        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly value);
+        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, out TimeOnly value);
     }
-    public class ComponentApplicationState {
 {
-        public event ComponentApplicationState.OnPersistingCallback OnPersisting;

-        public void PersistAsJson<TValue>(string key, TValue instance);

-        public void PersistState(string key, byte[] value);

-        public bool TryTakeAsJson<TValue>(string key, out TValue instance);

-        public bool TryTakePersistedState(string key, out byte[] value);

-        public delegate Task OnPersistingCallback();

-    }
     public static class EventCallbackFactoryBinderExtensions {
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly> setter, DateOnly existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly> setter, DateOnly existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly?> setter, DateOnly? existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<DateOnly?> setter, DateOnly? existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly?> setter, TimeOnly? existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly?> setter, TimeOnly? existingValue, string format, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly> setter, TimeOnly existingValue, CultureInfo culture = null);
+        public static EventCallback<ChangeEventArgs> CreateBinder(this EventCallbackFactory factory, object receiver, Action<TimeOnly> setter, TimeOnly existingValue, string format, CultureInfo culture = null);
     }
+    public interface IPersistentComponentStateStore {
+        Task<IDictionary<string, byte[]>> GetPersistedStateAsync();
+        Task PersistStateAsync(IReadOnlyDictionary<string, byte[]> state);
+    }
+    public static class NavigationManagerExtensions {
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, bool value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateOnly value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateTime value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, decimal value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, double value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, Guid value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, int value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, long value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, bool? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateOnly? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, DateTime? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, decimal? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, double? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, Guid? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, int? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, long? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, float? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, TimeOnly? value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, float value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, string value);
+        public static string GetUriWithQueryParameter(this NavigationManager navigationManager, string name, TimeOnly value);
+        public static string GetUriWithQueryParameters(this NavigationManager navigationManager, IReadOnlyDictionary<string, object> parameters);
+        public static string GetUriWithQueryParameters(this NavigationManager navigationManager, string uri, IReadOnlyDictionary<string, object> parameters);
+    }
+    public class PersistentComponentState {
+        public void PersistAsJson<TValue>(string key, TValue instance);
+        public PersistingComponentStateSubscription RegisterOnPersisting(Func<Task> callback);
+        public bool TryTakeFromJson<TValue>(string key, out TValue instance);
+    }
+    public readonly struct PersistingComponentStateSubscription : IDisposable {
+        public void Dispose();
+    }
 }
```

