# .NET 7.0.0 Preview 5  - June 14, 2022

The .NET 7.0.0 Preview 5 and .NET SDK 7.0.100-preview.5.22307.18 releases are available for download. The latest 7.0 release is always listed at [.NET 7.0 Releases](../README.md).

## What's new in .NET 7 Preview 5

.NET 7 is the next major release of .NET following .NET 6.0. You can see some of the new features available with .NET 7 Preview 5 at [dotnet/core #7441](https://github.com/dotnet/core/issues/7441).

See the [.NET][dotnet-blog], [EF Core][ef-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.
Here is list of some of the additions and updates we're excited to bring in Preview 5.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]

</br>

1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.

</br>

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
7.0.100-preview.5.22307.18
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 7.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://hub.docker.com/_/microsoft-dotnet-sdk/): .NET SDK
* [dotnet/aspnet](https://hub.docker.com/_/microsoft-dotnet-aspnet/): ASP.NET Core Runtime
* [dotnet/runtime](https://hub.docker.com/_/microsoft-dotnet-runtime/): .NET Runtime
* [dotnet/runtime-deps](https://hub.docker.com/_/microsoft-dotnet-runtime-deps/): .NET Runtime Dependencies
* [dotnet/samples](https://hub.docker.com/_/microsoft-dotnet-samples/): .NET Samples

## Visual Studio Compatibility

You need [Visual Studio 17.2 latest preview](https://visualstudio.microsoft.com) to use .NET 7.0 on Windows. On macOS, you need the latest version of [Visual Studio for Mac](https://visualstudio.microsoft.com/vs/mac/). The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 7.0 and C# 11.


## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #7535](https://github.com/dotnet/core/issues/7535) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: https://github.com/dotnet/core/blob/main/release-notes/7.0/preview/7.0.0-preview.5.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.5-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/7.0.0-preview.5-sha.txt

[linux-install]: https://github.com/dotnet/core/blob/main/release-notes/7.0/install-linux.md
[linux-setup]: https://github.com/dotnet/core/blob/main/Documentation/linux-setup.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-7-preview-5/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/asp-net-core-updates-in-dotnet-7-preview-5
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef7-preview5
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview5+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A7.0.0-preview5+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview5+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A7.0.0-preview5+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A7.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A7.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A7.0.1xx

[linux-packages]: ../install-linux.md



[//]: # ( Runtime 7.0.0-preview.5.22301.12)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b8f44599-e5f1-4a7b-b2dd-f9bee228c54e/7522bdd1cae9ea7f2923ba6e3598c1bd/dotnet-runtime-7.0.0-preview.5.22301.12-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ec6c59b-9ee8-4cf0-93b0-7ac4151a2bec/40970cdd60707cc3f21f9ee3766a876c/dotnet-runtime-7.0.0-preview.5.22301.12-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c20ca814-d961-4152-9579-d2f616d058db/c0899ef3449e0b128cbfc7cd0f4dc63d/dotnet-runtime-7.0.0-preview.5.22301.12-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/03b61a38-7ca1-4a22-8a4e-0ba89a4b9b7e/81950d134ad556fbfdabacbdb8c66d05/dotnet-runtime-7.0.0-preview.5.22301.12-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f27b47c5-9bbc-4ad9-b609-dd684dac68b1/2ce81e413586e8aff261a80980edf6ac/dotnet-runtime-7.0.0-preview.5.22301.12-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3937a22-27d5-4c37-816f-801efe033301/77bb70ea418386cbb31962f1cb0446cd/dotnet-runtime-7.0.0-preview.5.22301.12-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/920477f9-28a1-47d7-8d09-5b22dcb91b64/90debd9228afd1938d37b29908e83767/dotnet-runtime-7.0.0-preview.5.22301.12-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ce093c1-acae-47c2-9523-5946773e3a2d/4fc3117587145dee00305dfed13b8f58/dotnet-runtime-7.0.0-preview.5.22301.12-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e0cc2aa2-6605-4a72-9d9d-be0cf9a5e76e/ec7d746edb1066ef985e7601a0c0b35f/dotnet-runtime-7.0.0-preview.5.22301.12-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/35e2b13a-9cb1-446c-906a-1fe08deda59d/5ccd4109c6ffd446809c4a5bb1561fb1/dotnet-runtime-7.0.0-preview.5.22301.12-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/a9424ed6-b0c6-422a-8d1b-8edd7e7d24c2/bb0ad12e282151d4a3cd2307daf8479b/dotnet-runtime-7.0.0-preview.5.22301.12-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/0f5a0f1b-6623-4a74-8ef3-2bb1c1fc6d71/fa0723c02bcbf985173d36e445a97643/dotnet-runtime-7.0.0-preview.5.22301.12-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/525e27ca-909a-49c2-b130-c307e4729962/6d34db09b2651447b74f1c7a118509df/dotnet-runtime-7.0.0-preview.5.22301.12-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7f0760ca-a92c-44ff-a70c-7f72ada83daf/1df4c9fb01c71fe9d0d5c1c2bf426977/dotnet-runtime-7.0.0-preview.5.22301.12-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c98b6130-8c1b-49f2-8ae1-7c057a749fc0/815ab221314bf75d849f39d743e525d6/dotnet-runtime-7.0.0-preview.5.22301.12-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/245bffda-9656-4c17-91b7-2652cd8516f0/3fad460060b5385acbf7c59261987a5e/dotnet-runtime-7.0.0-preview.5.22301.12-win-x86.zip

[//]: # ( WindowsDesktop 7.0.0-preview.5.22302.5)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f0db829-eb74-429d-9efa-9f653e580a58/50e1c7ee798ee6079632b0dcb8825987/windowsdesktop-runtime-7.0.0-preview.5.22302.5-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/8c913e67-49e5-4569-b0a9-f95c92027c14/5a4465a99fb9490074bc2fda0fae9661/windowsdesktop-runtime-7.0.0-preview.5.22302.5-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0673b837-370e-4a07-968e-02c0f0e00fe1/a16408258a59c12fda9f64604911857d/windowsdesktop-runtime-7.0.0-preview.5.22302.5-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/38089c80-c585-49f6-95b2-ca53010bf78a/00a68bd2fc7f290cedd576fc0c48711c/windowsdesktop-runtime-7.0.0-preview.5.22302.5-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9b696061-ac42-4718-bc68-f05cdf7687a5/8d3183677715ef4f8a1296eecf78ed9f/windowsdesktop-runtime-7.0.0-preview.5.22302.5-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ba2c459d-658f-45c2-bb80-da219bd522fc/e04a44b88fe83bddb54a99242de75faa/windowsdesktop-runtime-7.0.0-preview.5.22302.5-win-x86.zip

[//]: # ( ASP 7.0.0-preview.5.22303.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9a0da074-bd0e-4241-b3d0-e0076bb304cf/368a270168dd46a359b5c4b65f2c3eb7/aspnetcore-runtime-7.0.0-preview.5.22303.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3eb22afb-6454-4c90-9d32-24d7f9fadd8f/f98c80d32ca3df072fccd3579aff1a13/aspnetcore-runtime-7.0.0-preview.5.22303.8-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f8740ae-ec37-4b02-b053-4f6ffc239b87/b9120fbd248fb82f51fe57ae5944952f/aspnetcore-runtime-7.0.0-preview.5.22303.8-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d9b0c62-e98a-4b6a-aaf6-56a48713235c/8efd14426301b077546491dea8f2e19f/aspnetcore-runtime-7.0.0-preview.5.22303.8-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ac03de8-51e4-460a-8c18-6ddcefc8b833/9f24ea44661d69cff3d3e47e9c9a010b/aspnetcore-runtime-7.0.0-preview.5.22303.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57cfa892-9154-40a2-9643-4b74366115b3/cd04f7b035b3b7b485f422f2584d6da7/aspnetcore-runtime-7.0.0-preview.5.22303.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/87b70ee5-8e21-4ba6-8576-5045dd1ccb44/7e067f83e35bf8a1c69ebd361727fc30/aspnetcore-runtime-7.0.0-preview.5.22303.8-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eb2110ee-7dc1-494f-baa9-e3aabea1a008/d1cbc2de8f0e88882d4faa8759401cf7/aspnetcore-runtime-7.0.0-preview.5.22303.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/f198f83b-c0f0-4346-8161-97e8b029739f/c1c8ae257e17a260e4b9972b92f700ea/aspnetcore-runtime-7.0.0-preview.5.22303.8-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/93cc1616-6624-476b-82b3-0bb2a63b9f4a/a4446b4f4218506d51b8217d7390b391/aspnetcore-runtime-7.0.0-preview.5.22303.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ca914709-0abb-48c2-aaf0-6ea145791621/d5956bb6278ff8bda5309a25e2f1dfd9/aspnetcore-runtime-7.0.0-preview.5.22303.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5dada56e-5dae-4bdf-acf0-eaf7d25dc1bf/4c215e34b6a0f6089321dc5a5ff44fdf/aspnetcore-runtime-7.0.0-preview.5.22303.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/123997c2-92fb-4b98-8f96-3e74a741bb84/1e2316760bc1d693f7c463404f9ac35b/aspnetcore-runtime-7.0.0-preview.5.22303.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/3e56e811-4a8e-49b1-9217-18c936d93f76/5b74116c4e5e87a1eb4239d07784caa8/dotnet-hosting-7.0.0-preview.5.22303.8-win.exe

[//]: # ( SDK 7.0.100-preview.5.22307.18)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1e73113f-92ca-436b-9e95-9c68c95ea5c0/8f969ce55125b1e1ed39ca2103b18425/dotnet-sdk-7.0.100-preview.5.22307.18-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/25092f42-500b-43da-9994-7577f6c7734c/507ea02dc7cf86ae94004afd2e916f58/dotnet-sdk-7.0.100-preview.5.22307.18-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7fadc5a9-c509-426e-b95f-591161fec0e5/fca815504b5619060748d554198371ad/dotnet-sdk-7.0.100-preview.5.22307.18-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/08c5defe-49c4-4080-8e54-ac20cf7f4f2c/87b1ef3da78d03ddaf086ae3b7b122c9/dotnet-sdk-7.0.100-preview.5.22307.18-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1461daed-6a0c-4d65-81ec-c6343e3c6076/df39d465aa9d37855e63dc51e2d71827/dotnet-sdk-7.0.100-preview.5.22307.18-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1c28fb12-c30d-411f-8d63-4dd9835387fe/cfe3d86f5600568ac354f7546f876589/dotnet-sdk-7.0.100-preview.5.22307.18-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d8afcb7b-07c8-4834-8dc7-44e67d4db713/25de501bb6482bfee466cec9426af845/dotnet-sdk-7.0.100-preview.5.22307.18-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1264a7ff-d09d-424f-84ed-efab470cb615/9f6bdeb3997f68344a9d561d10cbd9cb/dotnet-sdk-7.0.100-preview.5.22307.18-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/eb929c1e-1148-49fe-ab31-a711a678a023/f8b7c7eaec03e178e8a515ce8a3a7955/dotnet-sdk-7.0.100-preview.5.22307.18-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dd15b5e1-7765-4ddb-8bfb-e3ddb501fad5/d4d7b26819da837fc9df7aeb39caa370/dotnet-sdk-7.0.100-preview.5.22307.18-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/35145956-2281-4093-9d1d-a3cbc8778cfc/f639e6cb5314bea35d4b118f8161bc2b/dotnet-sdk-7.0.100-preview.5.22307.18-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/66d92456-d028-4a0d-a205-2ef2fd17271f/f96ee8f4bdb4526932fe86e2580cb306/dotnet-sdk-7.0.100-preview.5.22307.18-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/23001df5-62ec-423a-8eba-bec6967fad49/cc2cf74b399899b03e278f532216e214/dotnet-sdk-7.0.100-preview.5.22307.18-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2182e8e2-4fac-4270-ad51-898cd15f481d/75870ce0fd2814a3b45f083d4cfaa73d/dotnet-sdk-7.0.100-preview.5.22307.18-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ea05854d-0d8d-4bcd-a469-0b9961b7926e/b072cc5ecda017ad643a984936df33b0/dotnet-sdk-7.0.100-preview.5.22307.18-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/16986c48-9e5a-4c81-a36f-99bd1049ffb4/520f2227fbe248fb8f364c3502ca76ea/dotnet-sdk-7.0.100-preview.5.22307.18-win-x86.zip
